/*
 * Decompiled with CFR 0.152.
 */
package combat_dash;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class WASDInputResponsePacket {
    private final boolean[] inputs;

    public WASDInputResponsePacket(boolean[] inputs) {
        this.inputs = inputs;
    }

    public static void encode(WASDInputResponsePacket packet, FriendlyByteBuf buf) {
        for (boolean input : packet.inputs) {
            buf.writeBoolean(input);
        }
    }

    public static WASDInputResponsePacket decode(FriendlyByteBuf buf) {
        boolean[] inputs = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            inputs[i] = buf.readBoolean();
        }
        return new WASDInputResponsePacket(inputs);
    }

    public static void handle(WASDInputResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            boolean[] inputs = packet.inputs;
        });
        ctx.get().setPacketHandled(true);
    }
}

