/*
 * Decompiled with CFR 0.152.
 */
package combat_dash;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class WASDInputPacket {
    private final boolean forward;
    private final boolean left;
    private final boolean backward;
    private final boolean right;

    public WASDInputPacket(boolean forward, boolean left, boolean backward, boolean right) {
        this.forward = forward;
        this.left = left;
        this.backward = backward;
        this.right = right;
    }

    public static void encode(WASDInputPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.forward);
        buf.writeBoolean(packet.left);
        buf.writeBoolean(packet.backward);
        buf.writeBoolean(packet.right);
    }

    public static WASDInputPacket decode(FriendlyByteBuf buf) {
        return new WASDInputPacket(buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(WASDInputPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                sender.getPersistentData().m_128379_("combat_dash_forward", packet.forward);
                sender.getPersistentData().m_128379_("combat_dash_left", packet.left);
                sender.getPersistentData().m_128379_("combat_dash_backward", packet.backward);
                sender.getPersistentData().m_128379_("combat_dash_right", packet.right);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

