/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.CreeperMinionEgg;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.AbstractMutantMonster;
import fuzs.mutantmonsters.world.level.MutatedExplosion;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantCreeper
extends AbstractMutantMonster {
    private static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.m_135353_(MutantCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final int MAX_CHARGE_TIME = 100;
    public static final int MAX_DEATH_TIME = 100;
    private int chargeTime;
    private int chargeHits;
    private int lastJumpTick;
    private int jumpTick;
    private boolean summonLightning;
    private DamageSource deathCause;

    public MutantCreeper(EntityType<? extends MutantCreeper> type, Level worldIn) {
        super(type, worldIn);
        this.chargeHits = 3 + this.f_19796_.m_188503_(3);
        this.m_274367_(1.0f);
        this.f_21364_ = 30;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JumpAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new SpawnMinionsGoal());
        this.f_21345_.m_25352_(1, (Goal)new ChargeAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(3, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(200));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 100, true, true, EntityUtil::isFeline));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MutantCreeper.m_33035_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, 0.26).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATUS, (Object)0);
    }

    public boolean isCharged() {
        return ((Byte)this.f_19804_.m_135370_(STATUS) & 1) != 0;
    }

    private void setCharged(boolean charged) {
        byte b0 = (Byte)this.f_19804_.m_135370_(STATUS);
        this.f_19804_.m_135381_(STATUS, (Object)(charged ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isJumpAttacking() {
        return ((Byte)this.f_19804_.m_135370_(STATUS) & 2) != 0;
    }

    private void setJumpAttacking(boolean jumping) {
        byte b0 = (Byte)this.f_19804_.m_135370_(STATUS);
        this.f_19804_.m_135381_(STATUS, (Object)(jumping ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public boolean isCharging() {
        return ((Byte)this.f_19804_.m_135370_(STATUS) & 4) != 0;
    }

    private void setCharging(boolean flag) {
        byte b0 = (Byte)this.f_19804_.m_135370_(STATUS);
        this.f_19804_.m_135381_(STATUS, (Object)(flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.6f;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new MutantGroundPathNavigation((Mob)this, worldIn);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean m_5825_() {
        return this.isCharged() || super.m_5825_();
    }

    public boolean m_7327_(Entity entityIn) {
        double z;
        double y;
        double x;
        double d;
        boolean flag = entityIn.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        if ((d = Math.sqrt((x = entityIn.m_20185_() - this.m_20185_()) * x + (y = entityIn.m_20186_() - this.m_20186_()) * y + (z = entityIn.m_20189_() - this.m_20189_()) * z)) > 0.0) {
            entityIn.m_5997_(x / d * 0.5, y / d * (double)0.05f + (double)0.15f, z / d * 0.5);
        }
        this.m_6674_(InteractionHand.MAIN_HAND);
        return flag;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            float healAmount = amount / 2.0f;
            if (this.m_6084_() && this.m_21223_() < this.m_21233_() && !(source.m_7639_() instanceof MutantCreeper)) {
                this.m_5634_(healAmount);
                EntityUtil.sendParticlePacket((Entity)this, (ParticleOptions)ParticleTypes.f_123750_, (int)(healAmount / 2.0f));
            }
            return false;
        }
        boolean takenDamage = super.m_6469_(source, amount);
        if (this.isCharging()) {
            if (!source.m_269533_(DamageTypeTags.f_268731_) && source.m_7640_() instanceof LivingEntity) {
                source.m_7640_().m_6469_(this.m_269291_().m_269374_((Entity)this), 2.0f);
            }
            if (takenDamage && amount > 0.0f) {
                --this.chargeHits;
            }
        }
        return takenDamage;
    }

    public double m_20968_(@Nullable Entity lookingEntity) {
        return !(lookingEntity instanceof IronGolem) && !(lookingEntity instanceof Zoglin) ? super.m_20968_(lookingEntity) : 0.0;
    }

    public void m_8038_(ServerLevel serverWorld, LightningBolt lightningBolt) {
        this.setCharged(true);
    }

    public int m_5792_() {
        return 1;
    }

    protected void m_7562_() {
    }

    public void m_7822_(byte id) {
        if (id == 6) {
            for (int i = 0; i < 15; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.lastJumpTick = this.jumpTick;
        if (this.isJumpAttacking()) {
            if (this.jumpTick == 0) {
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModRegistry.ENTITY_MUTANT_CREEPER_PRIMED_SOUND_EVENT.get(), this.m_5720_(), 2.0f, this.m_6100_());
            }
            ++this.jumpTick;
            this.f_19865_ = Vec3.f_82478_;
            if (!(this.m_9236_().f_46443_ || !this.m_20096_() && this.m_146900_().m_60819_().m_76178_())) {
                MutatedExplosion.create((Entity)this, this.isCharged() ? 6.0f : 4.0f, false, Level.ExplosionInteraction.MOB);
                this.setJumpAttacking(false);
            }
        } else if (this.jumpTick > 0) {
            this.jumpTick = 0;
        }
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected void m_6731_(LivingEntity livingEntity) {
        livingEntity.f_19864_ = true;
    }

    public float getOverlayColor(float partialTicks) {
        if (this.f_20919_ > 0) {
            return (float)this.f_20919_ / 100.0f;
        }
        if (this.isCharging()) {
            return this.f_19797_ % 20 < 10 ? 0.6f : 0.0f;
        }
        return Mth.m_14179_((float)partialTicks, (float)this.lastJumpTick, (float)this.jumpTick) / 28.0f;
    }

    public void m_6667_(DamageSource cause) {
        if (!this.m_9236_().f_46443_) {
            this.deathCause = cause;
            this.setCharging(false);
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModRegistry.ENTITY_MUTANT_CREEPER_DEATH_SOUND_EVENT.get(), this.m_5720_(), 2.0f, 1.0f);
            if (this.f_20889_ > 0) {
                this.f_20889_ += 100;
            }
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        this.m_274367_(0.0f);
        float power = this.isCharged() ? 12.0f : 8.0f;
        float radius = power * 1.5f;
        for (Entity entity : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)radius), EntitySelector.f_20406_)) {
            double x = this.m_20185_() - entity.m_20185_();
            double y = this.m_20186_() - entity.m_20186_();
            double z = this.m_20189_() - entity.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            float scale = (float)this.f_20919_ / 100.0f;
            entity.m_20256_(entity.m_20184_().m_82520_(x / d * (double)scale * 0.09, y / d * (double)scale * 0.09, z / d * (double)scale * 0.09));
        }
        this.m_20343_(this.m_20185_() + (double)(this.f_19796_.m_188501_() * 0.2f) - (double)0.1f, this.m_20186_(), this.m_20189_() + (double)(this.f_19796_.m_188501_() * 0.2f) - (double)0.1f);
        if (this.f_20919_ >= 100) {
            if (!this.m_9236_().f_46443_) {
                MutatedExplosion.create((Entity)this, power, this.m_6060_(), Level.ExplosionInteraction.MOB);
                super.m_6667_(this.deathCause != null ? this.deathCause : this.m_269291_().m_269264_());
                if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_) && this.f_20888_ != null && this.f_20889_ > 0) {
                    this.m_9236_().m_7967_((Entity)new CreeperMinionEgg(this, (Entity)this.f_20888_));
                }
            }
            this.m_146870_();
        }
    }

    public float m_7077_(Explosion explosionIn, BlockGetter worldIn, BlockPos pos, BlockState blockStateIn, FluidState fluidState, float resistance) {
        return this.isCharged() && blockStateIn.m_60800_(worldIn, pos) > -1.0f ? Math.min(0.8f, resistance) : resistance;
    }

    public void m_8032_() {
        if (this.m_5448_() == null) {
            super.m_8032_();
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_CREEPER_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_CREEPER_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_CREEPER_HURT_SOUND_EVENT.get();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("JumpAttacking", this.isJumpAttacking());
        compound.m_128379_("Charging", this.isCharging());
        compound.m_128405_("ChargeTime", this.chargeTime);
        compound.m_128405_("ChargeHits", this.chargeHits);
        compound.m_128379_("SummonLightning", this.summonLightning);
        if (this.isCharged()) {
            compound.m_128379_("Powered", true);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCharged(compound.m_128471_("powered") || compound.m_128471_("Powered"));
        this.setJumpAttacking(compound.m_128471_("JumpAttacking"));
        this.setCharging(compound.m_128471_("Charging"));
        this.chargeTime = compound.m_128451_("ChargeTime");
        this.chargeHits = compound.m_128451_("ChargeHits");
        this.summonLightning = compound.m_128471_("SummonLightning");
    }

    class JumpAttackGoal
    extends Goal {
        JumpAttackGoal() {
        }

        public boolean m_8036_() {
            LivingEntity target = MutantCreeper.this.m_5448_();
            return target != null && MutantCreeper.this.m_20096_() && MutantCreeper.this.m_20280_((Entity)target) <= 1024.0 && !MutantCreeper.this.isJumpAttacking() && !MutantCreeper.this.isCharging() && MutantCreeper.this.f_19796_.m_188501_() * 100.0f < 0.9f;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            MutantCreeper.this.setJumpAttacking(true);
            MutantCreeper.this.m_20334_((MutantCreeper.this.m_5448_().m_20185_() - MutantCreeper.this.m_20185_()) * 0.2, 1.4 * (double)MutantCreeper.this.m_20098_(), (MutantCreeper.this.m_5448_().m_20189_() - MutantCreeper.this.m_20189_()) * 0.2);
        }
    }

    class SpawnMinionsGoal
    extends Goal {
        SpawnMinionsGoal() {
        }

        public boolean m_8036_() {
            float chance = MutantCreeper.this.m_21691_() && (MutantCreeper.this.m_21225_() == null || !MutantCreeper.this.m_21225_().m_269533_(DamageTypeTags.f_268524_)) ? 0.6f : 0.9f;
            return MutantCreeper.this.m_5448_() != null && MutantCreeper.this.m_20280_((Entity)MutantCreeper.this.m_5448_()) <= 1024.0 && !MutantCreeper.this.isCharging() && !MutantCreeper.this.isJumpAttacking() && MutantCreeper.this.f_19796_.m_188501_() * 100.0f < chance;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            for (int i = (int)Math.ceil((double)(MutantCreeper.this.m_21223_() / MutantCreeper.this.m_21233_()) * 4.0); i > 0; --i) {
                CreeperMinion minion = (CreeperMinion)((EntityType)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get()).m_20615_(MutantCreeper.this.m_9236_());
                double x = MutantCreeper.this.m_20185_() + (double)MutantCreeper.this.f_19796_.m_188501_() - (double)MutantCreeper.this.f_19796_.m_188501_();
                double y = MutantCreeper.this.m_20186_() + (double)(MutantCreeper.this.f_19796_.m_188501_() * 0.5f);
                double z = MutantCreeper.this.m_20189_() + (double)MutantCreeper.this.f_19796_.m_188501_() - (double)MutantCreeper.this.f_19796_.m_188501_();
                double xx = MutantCreeper.this.m_5448_().m_20185_() - MutantCreeper.this.m_20185_();
                double yy = MutantCreeper.this.m_5448_().m_20186_() - MutantCreeper.this.m_20186_();
                double zz = MutantCreeper.this.m_5448_().m_20189_() - MutantCreeper.this.m_20189_();
                minion.m_20334_(xx * (double)0.15f + (double)(MutantCreeper.this.f_19796_.m_188501_() * 0.05f), yy * (double)0.15f + (double)(MutantCreeper.this.f_19796_.m_188501_() * 0.05f), zz * (double)0.15f + (double)(MutantCreeper.this.f_19796_.m_188501_() * 0.05f));
                minion.m_6034_(x, y, z);
                minion.m_6710_(MutantCreeper.this.m_5448_());
                minion.m_21816_(MutantCreeper.this.f_19820_);
                if (MutantCreeper.this.isCharged()) {
                    minion.setCharged(true);
                }
                MutantCreeper.this.m_9236_().m_7967_((Entity)minion);
            }
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity target = MutantCreeper.this.m_5448_();
            return target != null && !MutantCreeper.this.isJumpAttacking() && !(MutantCreeper.this.m_21233_() - MutantCreeper.this.m_21223_() < MutantCreeper.this.m_21233_() / 6.0f) && MutantCreeper.this.m_20280_((Entity)target) >= 25.0 && MutantCreeper.this.m_20280_((Entity)target) <= 1024.0 && MutantCreeper.this.f_19796_.m_188501_() * 100.0f < 0.7f || MutantCreeper.this.isCharging();
        }

        public boolean m_8045_() {
            LivingEntity target = MutantCreeper.this.m_5448_();
            if (MutantCreeper.this.summonLightning && target != null && MutantCreeper.this.m_20280_((Entity)target) < 25.0) {
                return false;
            }
            return MutantCreeper.this.chargeTime < 100 && MutantCreeper.this.chargeHits > 0;
        }

        public void m_8056_() {
            MutantCreeper.this.setCharging(true);
            if (MutantCreeper.this.f_19796_.m_188503_(MutantCreeper.this.m_9236_().m_46470_() ? 2 : 6) == 0 && !MutantCreeper.this.isCharged()) {
                MutantCreeper.this.summonLightning = true;
            }
        }

        public void m_8037_() {
            MutantCreeper.this.m_21573_().m_26573_();
            int i = MutantCreeper.this.chargeTime % 20;
            if (i == 0) {
                MutantCreeper.this.m_5496_((SoundEvent)ModRegistry.ENTITY_MUTANT_CREEPER_CHARGE_SOUND_EVENT.get(), 0.6f, 0.7f + MutantCreeper.this.f_19796_.m_188501_() * 0.6f);
            }
            ++MutantCreeper.this.chargeTime;
        }

        public void m_8041_() {
            if (MutantCreeper.this.summonLightning && MutantCreeper.this.m_5448_() != null && MutantCreeper.this.m_20280_((Entity)MutantCreeper.this.m_5448_()) < 25.0 && MutantCreeper.this.m_9236_().m_45527_(MutantCreeper.this.m_20183_())) {
                LightningBolt lightningBoltEntity = (LightningBolt)EntityType.f_20465_.m_20615_(MutantCreeper.this.m_9236_());
                lightningBoltEntity.m_6027_(MutantCreeper.this.m_20185_(), MutantCreeper.this.m_20186_(), MutantCreeper.this.m_20189_());
                MutantCreeper.this.m_9236_().m_7967_((Entity)lightningBoltEntity);
            } else if (MutantCreeper.this.chargeTime >= 100) {
                MutantCreeper.this.m_5634_(30.0f);
                MutantCreeper.this.m_9236_().m_7605_((Entity)MutantCreeper.this, (byte)6);
            }
            MutantCreeper.this.chargeTime = 0;
            MutantCreeper.this.chargeHits = 4 + MutantCreeper.this.f_19796_.m_188503_(3);
            MutantCreeper.this.setCharging(false);
            MutantCreeper.this.summonLightning = false;
        }
    }
}

