/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.client.MutantMonstersClient;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantSnowGolemModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;

public class MutantSnowGolemRenderer
extends MobRenderer<MutantSnowGolem, MutantSnowGolemModel> {
    static final ResourceLocation TEXTURE = MutantMonstersClient.entityTexture("mutant_snow_golem/mutant_snow_golem");
    private static final ResourceLocation JACK_O_LANTERN_TEXTURE = MutantMonstersClient.entityTexture("mutant_snow_golem/jack_o_lantern");
    private static final RenderType GLOW_RENDER_TYPE = MutantRenderTypes.m_110488_(MutantMonstersClient.entityTexture("mutant_snow_golem/glow"));

    public MutantSnowGolemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MutantSnowGolemModel(context.m_174023_(ClientModRegistry.MUTANT_SNOW_GOLEM)), 0.7f);
        this.m_115326_(new JackOLanternLayer((RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel>)this, context.m_174027_()));
        this.m_115326_(new HeldBlockLayer((RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel>)this, context.m_234597_()));
    }

    public void render(MutantSnowGolem entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        Player owner = entityIn.getOwner();
        if (owner != null) {
            matrixStackIn.m_85836_();
            if (this.m_6512_((Mob)entityIn)) {
                matrixStackIn.m_85837_(0.0, (double)0.25875f, 0.0);
            }
            this.m_7649_((Entity)entityIn, (Component)owner.m_5446_().m_6881_().m_130938_(style -> style.m_131155_(Boolean.valueOf(true))), matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.m_85849_();
        }
    }

    public ResourceLocation getTextureLocation(MutantSnowGolem entity) {
        return TEXTURE;
    }

    static class JackOLanternLayer
    extends RenderLayer<MutantSnowGolem, MutantSnowGolemModel> {
        private final MutantSnowGolemModel headModel;

        public JackOLanternLayer(RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel> entityRendererIn, EntityModelSet entityModelSet) {
            super(entityRendererIn);
            this.headModel = new MutantSnowGolemModel(entityModelSet.m_171103_(ClientModRegistry.MUTANT_SNOW_GOLEM_HEAD)).setRenderHeadOnly();
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MutantSnowGolem livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.hasJackOLantern()) {
                if (!livingEntity.m_20145_()) {
                    ((MutantSnowGolemModel)this.m_117386_()).copyPropertiesTo(this.headModel);
                    JackOLanternLayer.m_117376_((EntityModel)this.headModel, (ResourceLocation)JACK_O_LANTERN_TEXTURE, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)livingEntity, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                float green = Math.max(0.0f, 0.8f + 0.05f * Mth.m_14089_((float)(ageInTicks * 0.15f)));
                float blue = Math.max(0.0f, 0.15f + 0.2f * Mth.m_14089_((float)(ageInTicks * 0.1f)));
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(GLOW_RENDER_TYPE);
                ((MutantSnowGolemModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.f_118083_, 1.0f, green, blue, 1.0f);
            }
        }
    }

    static class HeldBlockLayer
    extends RenderLayer<MutantSnowGolem, MutantSnowGolemModel> {
        private final BlockRenderDispatcher blockRenderer;

        public HeldBlockLayer(RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel> entityRendererIn, BlockRenderDispatcher blockRenderer) {
            super(entityRendererIn);
            this.blockRenderer = blockRenderer;
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MutantSnowGolem livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.isThrowing() && livingEntity.getThrowingTick() < 7) {
                matrixStackIn.m_85836_();
                boolean leftHanded = livingEntity.m_21526_();
                float scale = Math.min(0.8f, ((float)livingEntity.getThrowingTick() + partialTicks) / 7.0f);
                matrixStackIn.m_85837_(leftHanded ? -0.4 : 0.4, 0.0, 0.0);
                ((MutantSnowGolemModel)this.m_117386_()).translateArm(leftHanded, matrixStackIn);
                matrixStackIn.m_85837_(0.0, 0.9, 0.0);
                matrixStackIn.m_85841_(-scale, -scale, scale);
                matrixStackIn.m_85837_(-0.5, -0.5, 0.5);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                this.blockRenderer.m_110912_(Blocks.f_50126_.m_49966_(), matrixStackIn, bufferIn, packedLightIn, OverlayTexture.f_118083_);
                matrixStackIn.m_85849_();
            }
        }
    }
}

