/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CreeperMinionTrackerScreen
extends Screen {
    private static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/gui/creeper_minion_tracker.png");
    private static final MutableComponent HEALTH_COMPONENT = Component.m_237115_((String)"gui.mutantmonsters.creeper_minion_tracker.health");
    private static final MutableComponent EXPLOSION_COMPONENT = Component.m_237115_((String)"gui.mutantmonsters.creeper_minion_tracker.explosion");
    private static final MutableComponent BLAST_RADIUS_COMPONENT = Component.m_237115_((String)"gui.mutantmonsters.creeper_minion_tracker.blast_radius");
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.0"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private final CreeperMinion creeperMinion;
    private int leftPos;
    private int topPos;
    private EditBox name;
    private boolean canRideOnShoulder;
    private boolean canDestroyBlocks;
    private boolean alwaysShowName;
    private int titleLabelX;
    private int titleLabelY;

    public CreeperMinionTrackerScreen(CreeperMinion creeperMinion) {
        super(creeperMinion.m_6095_().m_20676_());
        this.creeperMinion = creeperMinion;
    }

    private static Component onOffComponent(String translationKey, boolean on) {
        return Component.m_237115_((String)("gui.mutantmonsters.creeper_minion_tracker." + translationKey)).m_130946_(": ").m_7220_(on ? CommonComponents.f_130653_ : CommonComponents.f_130654_);
    }

    protected void m_7856_() {
        this.canDestroyBlocks = this.creeperMinion.canDestroyBlocks();
        this.alwaysShowName = this.creeperMinion.m_20151_();
        this.canRideOnShoulder = this.creeperMinion.canRideOnShoulder();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.name = new EditBox(this.f_96547_, this.leftPos + 5, this.topPos - 24, this.imageHeight, 20, (Component)Component.m_237119_());
        this.name.m_94202_(-1);
        this.name.m_94205_(-1);
        this.name.m_94199_(50);
        this.name.m_94151_(this::onNameChanged);
        this.name.m_94144_(this.creeperMinion.m_7755_().getString());
        this.m_7787_((GuiEventListener)this.name);
        int buttonWidth = this.imageWidth / 2 - 10;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.canDestroyBlocks(), button -> {
            this.canDestroyBlocks = !this.canDestroyBlocks;
            MutantMonsters.NETWORK.sendToServer((MessageV2)new C2SCreeperMinionTrackerMessage(this.creeperMinion, 0, this.canDestroyBlocks));
            button.m_93666_(this.canDestroyBlocks());
        }).m_252987_(this.leftPos + 8, this.topPos + this.imageHeight - 75, buttonWidth * 2 + 4, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.alwaysShowName(), button -> {
            this.alwaysShowName = !this.alwaysShowName;
            MutantMonsters.NETWORK.sendToServer((MessageV2)new C2SCreeperMinionTrackerMessage(this.creeperMinion, 1, this.alwaysShowName));
            button.m_93666_(this.alwaysShowName());
        }).m_252987_(this.leftPos + 8, this.topPos + this.imageHeight - 51, buttonWidth * 2 + 4, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.canRideOnShoulder(), button -> {
            this.canRideOnShoulder = !this.canRideOnShoulder;
            MutantMonsters.NETWORK.sendToServer((MessageV2)new C2SCreeperMinionTrackerMessage(this.creeperMinion, 2, this.canRideOnShoulder));
            button.m_93666_(this.canRideOnShoulder());
        }).m_252987_(this.leftPos + 8, this.topPos + this.imageHeight - 27, buttonWidth * 2 + 4, 20).m_253136_());
        if (!this.creeperMinion.m_21830_((LivingEntity)this.f_96541_.f_91074_)) {
            this.f_169369_.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(widget -> {
                widget.f_93623_ = false;
            });
        }
        this.titleLabelX = (this.imageWidth - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.titleLabelY = 6;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return this.name.m_7933_(keyCode, scanCode, modifiers) || this.name.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        if (!this.creeperMinion.m_6084_()) {
            this.f_96541_.f_91074_.m_6915_();
        }
        this.name.m_94120_();
    }

    private void onNameChanged(String input) {
        if (!(input = input.trim()).equals(this.creeperMinion.m_7755_().getString())) {
            this.creeperMinion.m_6593_((Component)Component.m_237113_((String)input));
            MutantMonsters.NETWORK.sendToServer((MessageV2)new C2SCreeperMinionNameMessage((Entity)this.creeperMinion, input));
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String string = this.name.m_94155_();
        this.m_6575_(minecraft, width, height);
        this.name.m_94144_(string);
    }

    private Component alwaysShowName() {
        return CreeperMinionTrackerScreen.onOffComponent("show_name", this.alwaysShowName);
    }

    private Component canDestroyBlocks() {
        return CreeperMinionTrackerScreen.onOffComponent("destroys_blocks", this.canDestroyBlocks);
    }

    private Component canRideOnShoulder() {
        return CreeperMinionTrackerScreen.onOffComponent("ride_on_shoulder", this.canRideOnShoulder);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.m_280218_(TEXTURE_LOCATION, this.leftPos + 15, this.topPos + 16, 0, 166, 146, 5);
        float healthProgress = Mth.m_14036_((float)(this.creeperMinion.m_21223_() / this.creeperMinion.m_21233_()), (float)0.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE_LOCATION, this.leftPos + 15, this.topPos + 16, 0, 171, (int)(healthProgress * 146.0f), 5);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, 0x404040, false);
        this.name.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280614_(this.f_96547_, (Component)HEALTH_COMPONENT, this.leftPos + 13, this.topPos + 31, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)EXPLOSION_COMPONENT, this.leftPos + 13, this.topPos + 51, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)BLAST_RADIUS_COMPONENT, this.leftPos + 13, this.topPos + 71, 0x404040, false);
        guiGraphics.m_280137_(this.f_96547_, String.format("%s / %s", DECIMAL_FORMAT.format(this.creeperMinion.m_21223_()), DECIMAL_FORMAT.format(this.creeperMinion.m_21233_())), this.leftPos + this.imageWidth / 2 + 38, this.topPos + 31, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, (Component)(this.creeperMinion.canExplodeContinuously() ? Component.m_237115_((String)"gui.mutantmonsters.creeper_minion_tracker.explosion.continuous") : Component.m_237115_((String)"gui.mutantmonsters.creeper_minion_tracker.explosion.one_time")), this.leftPos + this.imageWidth / 2 + 38, this.topPos + 51, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, DECIMAL_FORMAT.format(this.creeperMinion.getExplosionRadius()), this.leftPos + this.imageWidth / 2 + 38, this.topPos + 71, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }
}

