/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.travel;

import com.pedrorok.hypertube.core.camera.DetachedPlayerDirController;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeActionPoint;
import com.pedrorok.hypertube.network.NetworkHandler;
import com.pedrorok.hypertube.network.packets.ActionPointReachPacket;
import com.pedrorok.hypertube.network.packets.FinishPathPacket;
import com.pedrorok.hypertube.network.packets.MovePathPacket;
import com.pedrorok.hypertube.network.packets.SpeedChangePacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientTravelPathMover {
    private static final Int2ObjectArrayMap<PathData> ACTIVE_PATHS = new Int2ObjectArrayMap();

    public static void startMoving(MovePathPacket packet) {
        boolean isPlayer = Minecraft.m_91087_().f_91074_.m_19879_() == packet.entityId();
        ACTIVE_PATHS.put(packet.entityId(), (Object)new PathData(packet.pathPoints(), packet.actionPoints(), packet.travelSpeed(), isPlayer));
    }

    public static void updateEntitySpeed(SpeedChangePacket packet) {
        PathData data = (PathData)ACTIVE_PATHS.get(packet.entityId());
        if (data != null) {
            data.travelSpeed = packet.newSpeed();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        ObjectIterator it = ACTIVE_PATHS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            int id = (Integer)entry.getKey();
            PathData data = (PathData)entry.getValue();
            Entity entity = level.m_6815_(id);
            if (entity == null || !entity.m_6084_() || entity.m_5833_()) {
                it.remove();
                continue;
            }
            if (data.isDone()) {
                it.remove();
                NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new FinishPathPacket(entity.m_20148_()));
                continue;
            }
            data.updateLogicalPosition();
            entity.m_20256_(data.getCurrentDirection());
            if (data.isClientPlayer()) {
                ClientTravelPathMover.handleEntityDirection(data.getCurrentDirection());
                continue;
            }
            data.handleEntityDirection((LivingEntity)entity, data.getCurrentDirection());
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        float partialTicks = event.renderTickTime;
        for (Map.Entry entry : ACTIVE_PATHS.entrySet()) {
            int id = (Integer)entry.getKey();
            PathData data = (PathData)entry.getValue();
            if (data.isDone()) {
                return;
            }
            Entity entity = level.m_6815_(id);
            if (entity == null || !entity.m_6084_() || entity.m_5833_()) continue;
            data.handleActionPoint((LivingEntity)entity);
            Vec3 renderPos = data.getRenderPosition(partialTicks);
            entity.m_6027_(renderPos.f_82479_, renderPos.f_82480_, renderPos.f_82481_);
        }
    }

    private static void handleEntityDirection(Vec3 direction) {
        float yaw = (float)Math.toDegrees(Math.atan2(-direction.f_82479_, direction.f_82481_));
        float pitch = (float)Math.toDegrees(Math.atan2(-direction.f_82480_, Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)));
        DetachedPlayerDirController.get().setDetached(true);
        DetachedPlayerDirController.get().updateRotation(yaw, pitch);
    }

    public static void updateSegment(int entityId, int segment) {
        PathData data = (PathData)ACTIVE_PATHS.get(entityId);
        if (data != null && data.lastUpdateTick > 0) {
            --data.lastUpdateTick;
            return;
        }
    }

    public static PathData getData(int entityId) {
        return (PathData)ACTIVE_PATHS.get(entityId);
    }

    public static class PathData {
        private final List<Vec3> points;
        private final Set<BlockPos> actionPoints;
        private double travelSpeed;
        private int currentIndex = 0;
        private int lastUpdateTick = 0;
        private Vec3 currentLogicalPos;
        private Vec3 previousLogicalPos;
        private float previousPitch = 0.0f;
        private boolean clientPlayer;

        public PathData(List<Vec3> points, Set<BlockPos> actionPoints, double blocksPerSecond, boolean clientPlayer) {
            this.points = points;
            this.actionPoints = actionPoints;
            this.travelSpeed = blocksPerSecond;
            this.clientPlayer = clientPlayer;
            if (!points.isEmpty()) {
                this.previousLogicalPos = this.currentLogicalPos = points.get(0).m_82492_(0.0, 0.25, 0.0);
            }
        }

        public boolean isDone() {
            return this.currentIndex >= this.points.size();
        }

        public Vec3 getCurrentTarget() {
            if (this.currentIndex < this.points.size()) {
                return this.points.get(this.currentIndex).m_82492_(0.0, 0.25, 0.0);
            }
            return this.currentLogicalPos;
        }

        public void updateLogicalPosition() {
            if (this.isDone()) {
                return;
            }
            Vec3 target = this.getCurrentTarget();
            double distanceToTarget = this.currentLogicalPos.m_82554_(target);
            boolean doHalfStep = true;
            this.previousLogicalPos = this.currentLogicalPos;
            if (distanceToTarget < this.travelSpeed) {
                this.currentLogicalPos = target;
                this.currentIndex = (int)((double)this.currentIndex + Math.max(1.0, this.travelSpeed));
                if (this.travelSpeed <= 1.0) {
                    doHalfStep = false;
                }
            }
            if (doHalfStep) {
                Vec3 direction = target.m_82546_(this.currentLogicalPos).m_82541_().m_82490_(this.travelSpeed);
                this.currentLogicalPos = this.currentLogicalPos.m_82549_(direction);
            }
        }

        public float getPitch() {
            float degrees;
            Vec3 dir = this.getCurrentDirection();
            if (dir.equals((Object)Vec3.f_82478_) && this.previousPitch != -1.0f) {
                return this.previousPitch;
            }
            this.previousPitch = degrees = (float)Math.toDegrees(Math.atan2(-dir.f_82480_, Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)));
            return degrees;
        }

        public void handleActionPoint(LivingEntity entity) {
            BlockPos entityPos = entity.m_20097_();
            if (!this.actionPoints.contains(entityPos)) {
                return;
            }
            this.actionPoints.remove(entityPos);
            BlockPos actionPos = entity.m_20097_();
            Block block = entity.m_9236_().m_8055_(actionPos).m_60734_();
            if (block instanceof ITubeActionPoint) {
                ITubeActionPoint travelAction = (ITubeActionPoint)block;
                NetworkHandler.INSTANCE.sendToServer((Object)new ActionPointReachPacket(entity.m_20148_(), actionPos));
            }
        }

        public Vec3 getCurrentDirection() {
            if (this.currentLogicalPos.equals((Object)this.previousLogicalPos)) {
                return Vec3.f_82478_;
            }
            return this.currentLogicalPos.m_82546_(this.previousLogicalPos).m_82541_();
        }

        public Vec3 getRenderPosition(float partialTicks) {
            return this.previousLogicalPos.m_165921_(this.currentLogicalPos, (double)partialTicks);
        }

        private void handleEntityDirection(LivingEntity entity, Vec3 direction) {
            float yaw = (float)Math.toDegrees(Math.atan2(-direction.f_82479_, direction.f_82481_));
            float pitch = (float)Math.toDegrees(Math.atan2(-direction.f_82480_, Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)));
            entity.m_146922_(yaw);
            entity.m_146926_(pitch);
        }

        public boolean isClientPlayer() {
            return this.clientPlayer;
        }
    }
}

