/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks;

import com.pedrorok.hypertube.blocks.ActionTubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.blocks.blockentities.HyperAcceleratorBlockEntity;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeActionPoint;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelPathMover;
import com.pedrorok.hypertube.network.NetworkHandler;
import com.pedrorok.hypertube.network.packets.SpeedChangePacket;
import com.pedrorok.hypertube.registry.ModBlockEntities;
import com.pedrorok.hypertube.registry.ModBlocks;
import com.pedrorok.hypertube.utils.MessageUtils;
import com.pedrorok.hypertube.utils.TubeUtils;
import com.pedrorok.hypertube.utils.VoxelUtils;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HyperAcceleratorBlock
extends ActionTubeBlock
implements EntityBlock,
ICogWheel,
ITubeActionPoint {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty ACCELERATE = BooleanProperty.m_61465_((String)"accelerate");

    public HyperAcceleratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACCELERATE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, WATERLOGGED, POWER, ACTIVE, ACCELERATE, POWERED});
        super.m_7926_(builder);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (player == null) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_192917_((Fluid)Fluids.f_76193_)));
        }
        Direction direction = player.m_6350_();
        if (player.m_146909_() < -45.0f) {
            direction = Direction.UP;
        } else if (player.m_146909_() > 45.0f) {
            direction = Direction.DOWN;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_192917_((Fluid)Fluids.f_76193_)));
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    @Override
    public Item getItem() {
        return ModBlocks.HYPER_ACCELERATOR.m_5456_();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return ((BlockEntityType)ModBlockEntities.HYPER_ACCELERATOR.get()).m_155264_(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level1, pos, state1, be) -> ((ActionTubeBlockEntity)be).tick();
    }

    @Override
    public List<Direction> getConnectedFaces(BlockState state) {
        return new ArrayList<Direction>(List.of(((Direction)state.m_61143_((Property)FACING)).m_122424_(), (Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        HyperAcceleratorBlockEntity entrance;
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (super.onWrenched(state, context) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof HyperAcceleratorBlockEntity && (entrance = (HyperAcceleratorBlockEntity)blockEntity).wrenchClicked(context.m_43719_())) {
            IWrenchable.playRotateSound((Level)context.m_43725_(), (BlockPos)context.m_8083_());
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        BlockState blockState = (BlockState)state.m_61124_((Property)ACCELERATE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)ACCELERATE) == false));
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        level.m_7731_(pos, blockState, 3);
        if (((Boolean)blockState.m_61143_((Property)ACCELERATE)).booleanValue()) {
            MessageUtils.sendActionMessage(player, (Component)Component.m_237115_((String)"block.hypertube.hyper_accelerator.accelerate_mode").m_130940_(ChatFormatting.YELLOW), true);
        } else {
            MessageUtils.sendActionMessage(player, (Component)Component.m_237115_((String)"block.hypertube.hyper_accelerator.brake_mode").m_130940_(ChatFormatting.GOLD), true);
        }
        IWrenchable.playRotateSound((Level)context.m_43725_(), (BlockPos)context.m_8083_());
        return InteractionResult.SUCCESS;
    }

    @Override
    public void handleTravelPath(LivingEntity entity, TravelPathMover mover, BlockPos pos) {
        Level level = entity.m_9236_();
        HyperAcceleratorBlockEntity tube = (HyperAcceleratorBlockEntity)level.m_7702_(pos);
        if (tube == null || mover == null) {
            return;
        }
        float speed = TubeUtils.calculateTravelSpeed(Math.abs(tube.getSpeed())) / 2.0f;
        float newSpeed = mover.getTravelSpeed() + speed * (float)((Boolean)tube.m_58900_().m_61143_((Property)ACCELERATE) != false ? 1 : -1);
        newSpeed = Math.max(0.4333f, newSpeed);
        mover.setTravelSpeed(newSpeed);
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SpeedChangePacket(entity.m_19879_(), newSpeed));
        TubeSoundManager.playTubeSuctionSound(entity, entity.m_20182_());
    }

    @Override
    public VoxelShape getShape(BlockState state, @Nullable CollisionContext ctx) {
        EntityCollisionContext ecc;
        if (ctx instanceof EntityCollisionContext && (ecc = (EntityCollisionContext)ctx).m_193113_() != null && ecc.m_193113_().getPersistentData().m_128471_("hypertube_travel")) {
            return VoxelUtils.empty();
        }
        return Shapes.m_83144_();
    }

    @Override
    protected BooleanProperty propertyToUpdate() {
        return ACCELERATE;
    }

    public boolean isSmallCog() {
        return true;
    }
}

