/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.ecostackmanager.config;

import de.markusbordihn.ecostackmanager.config.Config;
import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemEntityConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "item_entity.cfg";
    public static final String CONFIG_FILE_HEADER = "Item Entity Configuration";
    private static final Logger log = LogManager.getLogger((String)"Eco Stack Manager");
    public static Set<String> allowList = Set.of();
    public static Set<String> denyList = Set.of("minecraft:diamond", "minecraft:diamond_block");
    public static int collectRadius = 3;
    public static int maxNumberOfItemsPerWorld = 128;
    public static int maxNumberOfItemsPerType = 32;
    public static int maxStackSize = 64;
    public static boolean movePositionToLastDrop = false;
    public static int verificationCycle = 64;

    public static void registerConfig() {
        ItemEntityConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        ItemEntityConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = ItemEntityConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = ItemEntityConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        allowList = ItemEntityConfig.parseConfigValue(properties, "allow_list", allowList);
        denyList = ItemEntityConfig.parseConfigValue(properties, "deny_list", denyList);
        collectRadius = ItemEntityConfig.validateAndParseRadius(properties, "collect_radius", collectRadius);
        maxNumberOfItemsPerWorld = ItemEntityConfig.validateAndParsePositiveInteger(properties, "max_number_of_items_per_world", maxNumberOfItemsPerWorld);
        maxNumberOfItemsPerType = ItemEntityConfig.validateAndParsePositiveInteger(properties, "max_number_of_items_per_type", maxNumberOfItemsPerType);
        maxStackSize = ItemEntityConfig.validateAndParseStackSize(properties, "max_stack_size", maxStackSize);
        movePositionToLastDrop = ItemEntityConfig.parseConfigValue(properties, "move_position_to_last_drop", movePositionToLastDrop);
        verificationCycle = ItemEntityConfig.validateAndParseVerificationCycle(properties, "verification_cycle", verificationCycle);
        ItemEntityConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    private static int validateAndParseRadius(Properties properties, String key, int defaultValue) {
        int value = ItemEntityConfig.parseConfigValue(properties, key, defaultValue);
        if (value < 0) {
            log.warn("Invalid collect_radius value: {}. Using default: {}", (Object)value, (Object)defaultValue);
            return defaultValue;
        }
        if (value > 64) {
            log.warn("Collect_radius value too large ({}), capping at 64 to prevent performance issues", (Object)value);
            return 64;
        }
        return value;
    }

    private static int validateAndParsePositiveInteger(Properties properties, String key, int defaultValue) {
        int value = ItemEntityConfig.parseConfigValue(properties, key, defaultValue);
        if (value < 0) {
            log.warn("Invalid {} value: {}. Using default: {}", (Object)key, (Object)value, (Object)defaultValue);
            return defaultValue;
        }
        return value;
    }

    private static int validateAndParseStackSize(Properties properties, String key, int defaultValue) {
        int value = ItemEntityConfig.parseConfigValue(properties, key, defaultValue);
        if (value < 1) {
            log.warn("Invalid max_stack_size value: {}. Using default: {}", (Object)value, (Object)defaultValue);
            return defaultValue;
        }
        if (value > 64) {
            log.warn("Max_stack_size value too large ({}), capping at 64 to match Minecraft limits", (Object)value);
            return 64;
        }
        return value;
    }

    private static int validateAndParseVerificationCycle(Properties properties, String key, int defaultValue) {
        int value = ItemEntityConfig.parseConfigValue(properties, key, defaultValue);
        if (value < 1) {
            log.warn("Invalid verification_cycle value: {}. Using default: {}", (Object)value, (Object)defaultValue);
            return defaultValue;
        }
        if (value > 1000) {
            log.warn("Verification_cycle value too large ({}), capping at 1000 for performance", (Object)value);
            return 1000;
        }
        return value;
    }
}

