/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots.util;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.loader.Platform;
import snownee.skillslots.SkillSlotsModule;
import snownee.skillslots.client.SimpleSkillClientHandler;
import snownee.skillslots.client.SkillSlotsClient;
import snownee.skillslots.client.gui.PlaceScreen;
import snownee.skillslots.client.gui.UseScreen;
import snownee.skillslots.compat.JEIPlugin;
import snownee.skillslots.skill.SimpleSkill;

public class ClientProxy {
    private static final boolean hasJEI = Platform.isModLoaded((String)"jei");

    public static void init() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(ClientProxy::registerItemColors);
        eventBus.addListener(ClientProxy::registerKeyMapping);
        MinecraftForge.EVENT_BUS.addListener(ClientProxy::renderOverlay);
        MinecraftForge.EVENT_BUS.addListener(ClientProxy::onKeyInput);
    }

    public static int pickItemColor(ItemStack stack, int fallback) {
        int color = Minecraft.m_91087_().getItemColors().m_92676_(stack, 0);
        if (color != -1) {
            return color;
        }
        if (hasJEI) {
            return JEIPlugin.pickItemColor(stack, fallback);
        }
        return fallback;
    }

    public static void loadComplete() {
        MenuScreens.m_96206_((MenuType)((MenuType)SkillSlotsModule.PLACE.get()), PlaceScreen::new);
        SkillSlotsClient.registerClientHandler(SimpleSkill.class, new SimpleSkillClientHandler());
    }

    private static void onKeyInput(InputEvent.Key event) {
        if (event.getAction() == 1) {
            SkillSlotsClient.onKeyInput();
        }
    }

    private static void renderOverlay(RenderGuiOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && mc.f_91080_ != null && mc.f_91080_.getClass() == UseScreen.class) {
            event.setCanceled(true);
        }
    }

    private static void registerKeyMapping(RegisterKeyMappingsEvent event) {
        SkillSlotsClient.kbOpen.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        event.register(SkillSlotsClient.kbOpen);
        for (KeyMapping kbUse : SkillSlotsClient.kbUses) {
            event.register(kbUse);
        }
    }

    private static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        SkillSlotsClient.registerItemColors((ItemColor x$0, ItemLike xva$1) -> event.register(x$0, new ItemLike[]{xva$1}));
    }

    public static InputConstants.Key getBoundKeyOf(KeyMapping keyMapping) {
        return keyMapping.getKey();
    }

    @Nullable
    public static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

