/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots.skill;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.jetbrains.annotations.Nullable;
import snownee.skillslots.SkillSlotsHandler;
import snownee.skillslots.SkillSlotsModule;

public abstract class Skill {
    public static final Skill EMPTY = new Skill(ItemStack.f_41583_){};
    public final ItemStack item;
    public float progress;
    public float speed = 1.0f;
    public int color = 0xCCCCCC;

    public Skill(ItemStack item) {
        this.item = item.m_41777_();
    }

    public void finishUsing(Player player, int slot) {
    }

    public void startUsing(Player player, int slot) {
    }

    public void abortUsing(Player player, int slot) {
    }

    public final Component getDisplayName() {
        if (this.item.m_41619_()) {
            return Component.m_237119_();
        }
        if (this.item.m_41788_()) {
            return this.item.m_41786_();
        }
        return this.getDisplayNameInternal();
    }

    protected Component getDisplayNameInternal() {
        List effects = PotionUtils.m_43547_((ItemStack)this.item);
        if (effects.size() == 1) {
            return ((MobEffectInstance)effects.get(0)).m_19544_().m_19482_();
        }
        return this.item.m_41786_();
    }

    public Component getActionDescription() {
        return this.getDisplayName();
    }

    public final boolean isEmpty() {
        return this == EMPTY;
    }

    public int getUseDuration() {
        return this.item.m_41779_();
    }

    public boolean canBeToggled() {
        return false;
    }

    public void onToggled(Player player, SkillSlotsHandler handler, int slot) {
    }

    public int getChargeDuration(Player player) {
        return 0;
    }

    public boolean canUse(Player player) {
        return this.progress >= (float)this.getChargeDuration(player);
    }

    public float getChargeSpeed(Player player) {
        return this.speed;
    }

    public boolean isConflicting(Skill that) {
        return false;
    }

    @Nullable
    public Holder<SoundEvent> getChargeCompleteSound() {
        return BuiltInRegistries.f_256894_.m_263177_((Object)((SoundEvent)SkillSlotsModule.POTION_CHARGE_COMPLETE_SOUND.get()));
    }
}

