/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots.skill;

import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.skillslots.SkillSlotsHandler;
import snownee.skillslots.skill.Skill;
import snownee.skillslots.util.CommonProxy;

public class SimpleSkill
extends Skill {
    public boolean wasOnCooldown;

    public SimpleSkill(ItemStack item) {
        super(item);
    }

    @Override
    public void finishUsing(Player player, int slot) {
        Level level = player.m_9236_();
        ServerPlayer serverPlayer = level.f_46443_ ? null : (ServerPlayer)player;
        ItemStack prev = player.m_21205_();
        ItemStack copy = this.item.m_41777_();
        CompoundTag tag = copy.m_41698_("SkillSlots");
        tag.m_128379_("IsUsing", true);
        Inventory inventory = player.m_150109_();
        inventory.f_35974_.set(inventory.f_35977_, (Object)copy);
        player.m_21008_(InteractionHand.MAIN_HAND, copy);
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(player.m_20154_().m_82490_(CommonProxy.getBlockReach(player)));
        BlockHitResult hit = level.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        end = hit.m_6662_() != HitResult.Type.MISS ? hit.m_82450_() : start.m_82549_(player.m_20154_().m_82490_(CommonProxy.getEntityReach(player)));
        EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)start, (Vec3)end, (AABB)player.m_20191_().m_82369_(end).m_82400_(1.0), entity -> entity != player);
        if (entityHit != null) {
            hit = entityHit;
        }
        InteractionResult result = InteractionResult.PASS;
        switch (hit.m_6662_()) {
            case BLOCK: {
                if (level.f_46443_) {
                    UseOnContext ctx = new UseOnContext(player, InteractionHand.MAIN_HAND, hit);
                    result = copy.m_41661_(ctx);
                    break;
                }
                result = serverPlayer.f_8941_.m_7179_(serverPlayer, level, copy, InteractionHand.MAIN_HAND, hit);
                break;
            }
            case ENTITY: {
                if (level.f_46443_) break;
                ServerboundInteractPacket.m_179608_((Entity)entityHit.m_82443_(), (boolean)player.m_36341_(), (InteractionHand)InteractionHand.MAIN_HAND).m_5797_((ServerGamePacketListener)serverPlayer.f_8906_);
                result = InteractionResult.CONSUME;
                break;
            }
        }
        if (result == InteractionResult.PASS && !copy.m_41619_()) {
            if (level.f_46443_) {
                copy.m_41682_(level, player, InteractionHand.MAIN_HAND);
            } else {
                serverPlayer.f_8941_.m_6261_(serverPlayer, level, copy, InteractionHand.MAIN_HAND);
                if (this.getUseDuration() > 0) {
                    copy.m_41671_(level, (LivingEntity)player);
                }
            }
        }
        ItemStack now = player.m_21205_();
        tag = now.m_41698_("SkillSlots");
        tag.m_128473_("IsUsing");
        if (tag.m_128456_()) {
            now.m_41784_().m_128473_("SkillSlots");
            if (now.m_41784_().m_128456_()) {
                now.m_41751_(null);
            }
        }
        if (!ItemStack.m_41728_((ItemStack)this.item, (ItemStack)now)) {
            SkillSlotsHandler handler = SkillSlotsHandler.of(player);
            if (handler.m_7013_(slot, now)) {
                handler.m_6836_(slot, now);
            } else {
                handler.m_6836_(slot, ItemStack.f_41583_);
                player.m_36356_(now);
            }
        }
        inventory.f_35974_.set(inventory.f_35977_, (Object)prev);
        if (!level.f_46443_) {
            this.wasOnCooldown = player.m_36335_().m_41519_(this.item.m_41720_());
        }
    }

    @Override
    public int getUseDuration() {
        CompoundTag tag = this.item.m_41737_("SkillSlots");
        if (tag != null && tag.m_128425_("UseDuration", 99)) {
            return tag.m_128451_("UseDuration");
        }
        if (this.item.m_41720_() instanceof InstrumentItem || this.item.m_41720_() instanceof ThrowablePotionItem) {
            return 0;
        }
        return super.getUseDuration();
    }

    @Override
    public boolean canBeToggled() {
        CompoundTag tag = this.item.m_41737_("SkillSlots");
        if (tag != null && tag.m_128425_("CanBeToggled", 1)) {
            return tag.m_128471_("CanBeToggled");
        }
        return false;
    }

    @Override
    public boolean canUse(Player player) {
        return !player.m_36335_().m_41519_(this.item.m_41720_());
    }

    @Override
    @Nullable
    public Holder<SoundEvent> getChargeCompleteSound() {
        CompoundTag tag = this.item.m_41737_("SkillSlots");
        if (tag != null && tag.m_128425_("ChargeCompleteSound", 8)) {
            String s = tag.m_128461_("ChargeCompleteSound");
            if (s.isEmpty()) {
                return null;
            }
            ResourceLocation id = ResourceLocation.m_135820_((String)s);
            if (id != null) {
                return Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)id));
            }
        }
        return super.getChargeCompleteSound();
    }
}

