/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots.network;

import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PacketHandler;
import snownee.skillslots.SkillSlotsHandler;
import snownee.skillslots.skill.Skill;
import snownee.skillslots.util.ClientProxy;

@KiwiPacket(value="sync_slots", dir=KiwiPacket.Direction.PLAY_TO_CLIENT)
public class SSyncSlotsPacket
extends PacketHandler {
    public static SSyncSlotsPacket I;

    public static void send(ServerPlayer player) {
        SkillSlotsHandler handler = SkillSlotsHandler.of((Player)player);
        handler.dirty = false;
        I.send(player, buf -> {
            int slots = handler.m_6643_();
            buf.writeByte(slots);
            for (int i = 0; i < slots; ++i) {
                buf.m_130055_(handler.m_8020_(i));
                Skill skill = (Skill)handler.skills.get(i);
                buf.writeFloat(skill.progress);
            }
            buf.writeByte(handler.chargeIndex);
            buf.m_178350_(handler.toggles);
            buf.writeFloat(handler.acceleration);
        });
    }

    public CompletableFuture<FriendlyByteBuf> receive(Function<Runnable, CompletableFuture<FriendlyByteBuf>> executor, FriendlyByteBuf buf, ServerPlayer sender) {
        int slots = buf.readByte();
        ItemStack[] stacks = new ItemStack[slots];
        float[] progresses = new float[slots];
        for (int i = 0; i < slots; ++i) {
            stacks[i] = buf.m_130267_();
            progresses[i] = buf.readFloat();
        }
        byte chargeIndex = buf.readByte();
        BitSet toggles = buf.m_178384_();
        float acceleration = buf.readFloat();
        return executor.apply(() -> {
            Player player = ClientProxy.getPlayer();
            if (player == null) {
                return;
            }
            SkillSlotsHandler handler = SkillSlotsHandler.of(player);
            handler.setSlots(slots);
            for (int i = 0; i < slots; ++i) {
                handler.m_6836_(i, stacks[i]);
                ((Skill)handler.skills.get((int)i)).progress = progresses[i];
            }
            handler.chargeIndex = chargeIndex;
            handler.toggles = toggles;
            handler.acceleration = acceleration;
        });
    }
}

