/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.item.ItemCategoryFiller;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.NotNullByDefault;
import snownee.skillslots.SkillSlotsCommonConfig;
import snownee.skillslots.SkillSlotsHandler;
import snownee.skillslots.client.SkillSlotsClient;

@NotNullByDefault
public class UnlockSlotItem
extends ModItem
implements ItemCategoryFiller {
    public UnlockSlotItem() {
        super(new Item.Properties());
    }

    private static void sendMsg(Player player, String translationKey, Object ... objects) {
        if (player.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)("msg.skillslots." + translationKey), (Object[])objects), true);
        }
    }

    public static int getTier(ItemStack stack) {
        return Mth.m_14045_((int)NBTHelper.of((ItemStack)stack).getInt("Tier"), (int)0, (int)4);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        SkillSlotsHandler handler = SkillSlotsHandler.of(playerIn);
        boolean force = NBTHelper.of((ItemStack)stack).getBoolean("Force");
        int tier = UnlockSlotItem.getTier(stack);
        if (!force) {
            if (handler.m_6643_() >= SkillSlotsCommonConfig.maxSlots) {
                UnlockSlotItem.sendMsg(playerIn, "maxLevel", new Object[0]);
                if (!worldIn.f_46443_) {
                    handler.dirty = true;
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (tier > 0) {
                if (handler.m_6643_() + 1 < tier) {
                    UnlockSlotItem.sendMsg(playerIn, "tooHigh", new Object[0]);
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                if (handler.m_6643_() + 1 > tier) {
                    UnlockSlotItem.sendMsg(playerIn, "tooLow", new Object[0]);
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
            } else {
                tier = handler.m_6643_() + 1;
            }
        }
        worldIn.m_5594_(playerIn, playerIn.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!worldIn.f_46443_) {
            stack.m_41774_(1);
            handler.setSlots(tier);
        } else if (tier > handler.m_6643_()) {
            UnlockSlotItem.sendMsg(playerIn, "newSlot", SkillSlotsClient.kbOpen.m_90863_());
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)worldIn.f_46443_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (NBTHelper.of((ItemStack)stack).getBoolean("Force")) {
            tooltip.add((Component)Component.m_237115_((String)"tip.skillslots.force").m_130940_(ChatFormatting.RED));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public String m_5671_(ItemStack stack) {
        int tier = UnlockSlotItem.getTier(stack);
        if (tier > 0 && tier <= 4) {
            return this.m_5524_() + "." + tier;
        }
        return this.m_5524_();
    }

    public Rarity m_41460_(ItemStack stack) {
        return switch (UnlockSlotItem.getTier(stack)) {
            case 2 -> Rarity.UNCOMMON;
            case 3 -> Rarity.RARE;
            case 4 -> Rarity.EPIC;
            default -> Rarity.COMMON;
        };
    }

    public void fillItemCategory(CreativeModeTab group, FeatureFlagSet featureFlagSet, boolean hasPermissions, List<ItemStack> items) {
        ItemStack stack = new ItemStack((ItemLike)this);
        NBTHelper data = NBTHelper.of((ItemStack)stack);
        for (int i = 0; i < 2; ++i) {
            items.add(stack.m_41777_());
            for (int j = 1; j <= 4; ++j) {
                data.setInt("Tier", j);
                items.add(stack.m_41777_());
            }
            stack.m_41783_().m_128431_().clear();
            data.setBoolean("Force", true);
        }
    }
}

