/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots.compat;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import snownee.skillslots.SkillSlotsHandler;
import snownee.skillslots.SkillSlotsModule;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("skillslots", "main");
    private static IColorHelper colorHelper;

    public static int pickItemColor(ItemStack stack, int fallback) {
        if (colorHelper == null) {
            return fallback;
        }
        List colors = colorHelper.getColors(stack, 1);
        return colors.isEmpty() ? fallback : (Integer)colors.get(colors.size() - 1);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)SkillSlotsModule.UNLOCK_SLOT.get()});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        colorHelper = jeiRuntime.getJeiHelpers().getColorHelper();
        SkillSlotsHandler.of((Player)Minecraft.m_91087_().f_91074_).updateColors();
    }

    public void onRuntimeUnavailable() {
        colorHelper = null;
    }
}

