/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Matrix4f;
import snownee.skillslots.SkillSlotsCommonConfig;
import snownee.skillslots.SkillSlotsHandler;
import snownee.skillslots.SkillSlotsModule;
import snownee.skillslots.client.SkillClientHandler;
import snownee.skillslots.client.SkillSlotsClient;
import snownee.skillslots.network.COpenContainerPacket;
import snownee.skillslots.skill.Skill;
import snownee.skillslots.util.ClientProxy;

public class UseScreen
extends Screen {
    private static final Component TITLE = Component.m_237115_((String)"gui.skillslots.use.title");
    private final float[] scales = new float[4];
    private final Component[] names = new Component[4];
    private SkillSlotsHandler handler;
    private boolean closing;
    private float openTick;
    private int clickIndex = -1;
    private int useIndex = -1;
    private float useTicks;
    private float useTicksTotal;

    public UseScreen() {
        super(TITLE);
    }

    protected void m_7856_() {
        Objects.requireNonNull(this.f_96541_);
        Objects.requireNonNull(this.f_96541_.f_91074_);
        this.handler = SkillSlotsHandler.of((Player)this.f_96541_.f_91074_);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        if (this.handler == null) {
            return;
        }
        this.openTick += this.closing ? -pTicks * 0.4f : pTicks * 0.2f;
        if (this.closing && this.openTick <= 0.0f) {
            Minecraft.m_91087_().m_91152_(null);
            return;
        }
        this.openTick = Mth.m_14036_((float)this.openTick, (float)0.0f, (float)1.0f);
        float xCenter = (float)this.f_96543_ / 2.0f;
        float yCenter = (float)this.f_96544_ / 2.0f;
        if (SkillSlotsCommonConfig.maxSlots == 3) {
            yCenter += 20.0f;
        }
        if (!this.closing && this.useIndex != -1) {
            this.useTicks += pTicks;
            if (this.useTicks >= this.useTicksTotal) {
                this.useTicks = this.useTicksTotal;
                this.m_7379_();
            }
        }
        int oClickIndex = this.clickIndex;
        float offset = 35.0f + this.openTick * 25.0f;
        if (SkillSlotsCommonConfig.maxSlots == 1) {
            this.drawButton(graphics, xCenter, yCenter, mouseX, mouseY, 0, pTicks);
        } else if (SkillSlotsCommonConfig.maxSlots == 2) {
            this.drawButton(graphics, xCenter - offset, yCenter, mouseX, mouseY, 0, pTicks);
            this.drawButton(graphics, xCenter + offset, yCenter, mouseX, mouseY, 1, pTicks);
        } else if (SkillSlotsCommonConfig.maxSlots == 3) {
            this.drawButton(graphics, xCenter - offset, yCenter, mouseX, mouseY, 0, pTicks);
            this.drawButton(graphics, xCenter, yCenter - offset, mouseX, mouseY, 1, pTicks);
            this.drawButton(graphics, xCenter + offset, yCenter, mouseX, mouseY, 2, pTicks);
        } else if (SkillSlotsCommonConfig.maxSlots == 4) {
            this.drawButton(graphics, xCenter - offset, yCenter, mouseX, mouseY, 0, pTicks);
            this.drawButton(graphics, xCenter, yCenter - offset, mouseX, mouseY, 1, pTicks);
            this.drawButton(graphics, xCenter + offset, yCenter, mouseX, mouseY, 2, pTicks);
            this.drawButton(graphics, xCenter, yCenter + offset, mouseX, mouseY, 3, pTicks);
        }
        if (this.clickIndex < 0) {
            int range = SkillSlotsCommonConfig.maxSlots == 1 ? 60 : 120;
            boolean out = Math.abs((float)mouseX - xCenter) + Math.abs((float)mouseY - yCenter) > (float)range;
            this.clickIndex = out ? -2 : -1;
        } else {
            Skill skill = (Skill)this.handler.skills.get(this.clickIndex);
            if (skill.isEmpty() && this.clickIndex < this.handler.m_6643_() && SkillSlotsCommonConfig.playerCustomizable) {
                MutableComponent tooltip = Component.m_237110_((String)"tip.skillslots.emptySlot", (Object[])new Object[]{SkillSlotsClient.kbOpen.m_90863_()});
                graphics.m_280557_(this.f_96547_, (Component)tooltip, mouseX, mouseY);
            }
            if (!skill.isEmpty() && oClickIndex != this.clickIndex) {
                SkillSlotsClient.playSound((SoundEvent)SkillSlotsModule.HOVER_SOUND.get());
            }
        }
        RenderSystem.disableBlend();
        super.m_88315_(graphics, mouseX, mouseY, pTicks);
    }

    private void drawButton(GuiGraphics graphics, float xCenter, float yCenter, int mouseX, int mouseY, int index, float pTicks) {
        float progress;
        float hdshadow;
        float b;
        float g;
        float r;
        Skill skill = (Skill)this.handler.skills.get(index);
        float a = 0.5f * this.openTick;
        float hd = 40.0f;
        boolean hover = !this.closing && this.openTick == 1.0f && index < this.handler.m_6643_() && Math.abs((float)mouseX - xCenter) + Math.abs((float)mouseY - yCenter) < hd + 10.0f;
        boolean bl = hover = hover && (this.useIndex == index || this.useIndex == -1);
        if (hover) {
            this.clickIndex = index;
            if (skill.isEmpty()) {
                hover = false;
            }
        } else if (this.clickIndex == index) {
            this.clickIndex = -1;
        }
        int n = index;
        this.scales[n] = this.scales[n] + (hover ? pTicks : -pTicks) * 0.5f;
        this.scales[index] = Mth.m_14036_((float)this.scales[index], (float)0.0f, (float)1.0f);
        hd += this.scales[index] * 5.0f;
        if (hover) {
            int color = skill.color;
            float scale = this.scales[index] * 0.2f;
            r = Math.max(0.1f, (float)(color >> 16 & 0xFF) / 255.0f * scale);
            g = Math.max(0.1f, (float)(color >> 8 & 0xFF) / 255.0f * scale);
            b = Math.max(0.1f, (float)(color & 0xFF) / 255.0f * scale);
        } else {
            r = 0.1f;
            g = 0.1f;
            b = 0.1f;
        }
        PoseStack matrix = graphics.m_280168_();
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix4f, xCenter - hd, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter + hd, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter + hd, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter - hd, 0.0f).m_85950_(r, g, b, a).m_5752_();
        a = 0.75f * this.openTick;
        if (hover || this.handler.toggles.get(index) || this.useIndex == index) {
            int color = skill.color;
            float scale = this.scales[index];
            if (!hover) {
                scale = Math.max(scale, 0.75f);
            }
            r = Math.max(0.1f, (float)(color >> 16 & 0xFF) / 255.0f * scale);
            g = Math.max(0.1f, (float)(color >> 8 & 0xFF) / 255.0f * scale);
            b = Math.max(0.1f, (float)(color & 0xFF) / 255.0f * scale);
        }
        float hdborder = hd + 3.0f;
        buffer.m_252986_(matrix4f, xCenter, yCenter - hd, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter + hd, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter + hdborder, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter - hdborder, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter + hdborder, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter + hdborder, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter + hd, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter + hd, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter + hd, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter - hd, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter - hdborder, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter + hdborder, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter - hdborder, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter - hdborder, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter - hd, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter - hd, 0.0f).m_85950_(r, g, b, a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        if (this.useIndex == index) {
            float h = hd * 2.0f * this.useTicks / this.useTicksTotal - hd;
            float ia = this.openTick * 0.2f;
            buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(matrix4f, xCenter - hd + Math.abs(h), yCenter - h, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, ia).m_5752_();
            if (h > 0.0f) {
                buffer.m_252986_(matrix4f, xCenter - hd, yCenter, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, ia).m_5752_();
            }
            buffer.m_252986_(matrix4f, xCenter, yCenter + hd, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, ia).m_5752_();
            if (h > 0.0f) {
                buffer.m_252986_(matrix4f, xCenter + hd, yCenter, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, ia).m_5752_();
            }
            buffer.m_252986_(matrix4f, xCenter + hd - Math.abs(h), yCenter - h, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, ia).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        }
        if (hover) {
            a = 0.3f * this.openTick;
            hdshadow = hdborder + 6.0f;
        } else {
            a = 0.2f * this.openTick;
            hdshadow = hdborder + 5.0f;
        }
        r = 0.1f;
        g = 0.1f;
        b = 0.1f;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix4f, xCenter, yCenter - hdborder, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter + hdborder, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter + hdshadow, yCenter, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter - hdshadow, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter + hdshadow, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xCenter + hdshadow, yCenter, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xCenter + hdborder, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter + hdborder, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter + hdborder, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter - hdborder, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter - hdshadow, yCenter, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter + hdshadow, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter - hdshadow, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xCenter - hdshadow, yCenter, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xCenter - hdborder, yCenter, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix4f, xCenter, yCenter - hdborder, 0.0f).m_85950_(r, g, b, a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        this.refreshName(index);
        matrix.m_85836_();
        int textAlpha = (int)(this.openTick * 255.0f);
        int textColor = textAlpha << 24 | 0xFFFFFF;
        Component name = hover ? skill.getActionDescription() : this.names[index];
        Objects.requireNonNull(this.f_96541_);
        SkillClientHandler<Skill> handler = null;
        if (!skill.isEmpty()) {
            handler = SkillSlotsClient.getClientHandler(skill);
        }
        if (handler != null && (progress = handler.getDisplayChargeProgress(skill, (Player)this.f_96541_.f_91074_, pTicks)) != 1.0f) {
            float percent = 100.0f * progress;
            name = Component.m_237113_((String)((int)percent + "%"));
        }
        if (skill.isEmpty()) {
            matrix.m_252880_(xCenter, yCenter - 3.0f, 0.0f);
            matrix.m_85841_(0.75f, 0.75f, 0.75f);
            graphics.m_280653_(this.f_96547_, name, 0, 0, textColor);
        } else if (handler != null) {
            MutableInt textYOffset = new MutableInt(0);
            handler.renderGUI(skill, graphics, xCenter, yCenter, this.scales[index], this.openTick, textColor, textYOffset);
            if (textYOffset.getValue() != Integer.MIN_VALUE) {
                matrix.m_252880_(xCenter, yCenter + 10.0f + (float)textYOffset.getValue().intValue(), 300.0f);
                matrix.m_85841_(0.75f, 0.75f, 0.75f);
                graphics.m_280653_(this.f_96547_, name, 0, 0, textColor);
            }
        }
        matrix.m_85849_();
    }

    private void refreshName(int i) {
        if (this.names[i] != null) {
            return;
        }
        Skill skill = (Skill)this.handler.skills.get(i);
        this.names[i] = skill.isEmpty() ? (i < this.handler.m_6643_() ? Component.m_237119_() : Component.m_237115_((String)"msg.skillslots.locked").m_130940_(ChatFormatting.GRAY)) : skill.getDisplayName();
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.clickIndex == -2) {
            this.m_7379_();
            return true;
        }
        if (this.closing || this.clickIndex == -1) {
            return false;
        }
        Skill skill = (Skill)this.handler.skills.get(this.clickIndex);
        if (skill.isEmpty()) {
            if (SkillSlotsCommonConfig.playerCustomizable) {
                COpenContainerPacket.I.sendToServer($ -> {});
            }
            return true;
        }
        this.startUse(this.clickIndex);
        return true;
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (this.closing || this.useIndex != -1) {
            return false;
        }
        InputConstants.Key pressedKey = InputConstants.m_84827_((int)key, (int)scanCode);
        for (int i = 0; i < this.handler.m_6643_(); ++i) {
            if (!ClientProxy.getBoundKeyOf(SkillSlotsClient.kbUses[i]).equals((Object)pressedKey)) continue;
            this.startUse(i);
            return true;
        }
        if (ClientProxy.getBoundKeyOf(SkillSlotsClient.kbOpen).equals((Object)pressedKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    private void startUse(int i) {
        if (!this.handler.canUseSlot(i)) {
            return;
        }
        this.clickIndex = i;
        this.scales[i] = 1.0f;
        this.handler.startUsing(this.clickIndex);
        if (this.handler.useIndex == -1) {
            this.m_7379_();
        }
        this.useTicksTotal = ((Skill)this.handler.skills.get(i)).getUseDuration();
        this.useIndex = i;
    }

    public void m_7379_() {
        this.closing = true;
    }

    public boolean m_7043_() {
        return false;
    }
}

