/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import snownee.skillslots.SkillSlotsCommonConfig;
import snownee.skillslots.SkillSlotsHandler;
import snownee.skillslots.SkillSlotsModule;
import snownee.skillslots.client.SkillClientHandler;
import snownee.skillslots.client.gui.UseScreen;
import snownee.skillslots.item.UnlockSlotItem;
import snownee.skillslots.network.COpenContainerPacket;
import snownee.skillslots.skill.Skill;

public final class SkillSlotsClient {
    public static final KeyMapping kbOpen = new KeyMapping("keybind.skillslots.open", 82, "gui.skillslots.keygroup");
    public static final KeyMapping[] kbUses = new KeyMapping[4];
    private static final Map<Class<? extends Skill>, SkillClientHandler<?>> CLIENT_HANDLERS = Maps.newIdentityHashMap();

    public static void registerItemColors(BiConsumer<ItemColor, ItemLike> consumer) {
        consumer.accept((stack, i) -> {
            if (i == 1) {
                int tier = UnlockSlotItem.getTier(stack);
                return switch (tier) {
                    default -> 0xFF5555;
                    case 1 -> 0xFFFFFF;
                    case 2 -> 0xFFFF55;
                    case 3 -> 0x55FFFF;
                    case 4 -> 0xFF55FF;
                };
            }
            return -1;
        }, (ItemLike)SkillSlotsModule.UNLOCK_SLOT.get());
    }

    public static void onKeyInput() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91080_ != null || mc.f_91074_.m_5833_()) {
            return;
        }
        SkillSlotsHandler handler = SkillSlotsHandler.of((Player)mc.f_91074_);
        while (kbOpen.m_90859_()) {
            if (SkillSlotsCommonConfig.playerCustomizable && mc.f_91074_.m_6144_()) {
                COpenContainerPacket.I.sendToServer($ -> {});
                continue;
            }
            mc.m_91152_((Screen)new UseScreen());
        }
        block1: for (int i = 0; i < handler.m_6643_(); ++i) {
            while (kbUses[i].m_90859_()) {
                if (!handler.canUseSlot(i)) continue;
                handler.startUsing(i);
                continue block1;
            }
        }
    }

    public static void playSound(SoundEvent soundEvent) {
        SkillSlotsClient.playSound(soundEvent, 1.0f);
    }

    public static void playSound(SoundEvent soundEvent, float vol) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)soundEvent, (float)vol));
    }

    public static <T extends Skill> SkillClientHandler<T> getClientHandler(T skill) {
        Preconditions.checkArgument((!skill.isEmpty() ? 1 : 0) != 0, (Object)"Skill is empty");
        return CLIENT_HANDLERS.get(skill.getClass());
    }

    public static <T extends Skill> void registerClientHandler(Class<T> skill, SkillClientHandler<T> handler) {
        CLIENT_HANDLERS.put(skill, handler);
    }

    static {
        for (int i = 0; i < kbUses.length; ++i) {
            SkillSlotsClient.kbUses[i] = new KeyMapping("keybind.skillslots.use." + (i + 1), -1, "gui.skillslots.keygroup");
        }
    }
}

