/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.skillslots.SkillSlots;
import snownee.skillslots.SkillSlotsCommand;
import snownee.skillslots.SkillSlotsCommonConfig;
import snownee.skillslots.SkillSlotsHandler;
import snownee.skillslots.item.UnlockSlotItem;
import snownee.skillslots.menu.PlaceMenu;
import snownee.skillslots.network.SAbortUsingPacket;
import snownee.skillslots.network.SSyncSlotsPacket;
import snownee.skillslots.skill.SimpleSkill;
import snownee.skillslots.util.ClientProxy;
import snownee.skillslots.util.CommonProxy;

@KiwiModule(value="skillslots")
public class SkillSlotsModule
extends AbstractModule {
    public static final TagKey<Item> SKILL = SkillSlotsModule.itemTag((String)"skillslots", (String)"skill");
    @KiwiModule.Category(value={"tools"})
    public static final KiwiGO<UnlockSlotItem> UNLOCK_SLOT = SkillSlotsModule.go(UnlockSlotItem::new);
    public static final KiwiGO<MenuType<PlaceMenu>> PLACE = SkillSlotsModule.go(() -> new MenuType(PlaceMenu::new, FeatureFlags.f_244377_));
    public static final KiwiGO<SoundEvent> HOVER_SOUND = SkillSlotsModule.go(() -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("skillslots", "hover")));
    public static final KiwiGO<SoundEvent> POTION_CHARGE_COMPLETE_SOUND = SkillSlotsModule.go(() -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("skillslots", "potion_charge_complete")));
    public static final KiwiGO<SoundEvent> USE_SHORT_SOUND = SkillSlotsModule.go(() -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("skillslots", "use_short")));
    public static final KiwiGO<SoundEvent> USE_LONG_SOUND = SkillSlotsModule.go(() -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("skillslots", "use_long")));

    public static void sync(ServerPlayer player) {
        if (CommonProxy.isFakePlayer((Player)player)) {
            return;
        }
        SSyncSlotsPacket.send(player);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(SkillSlotsCommand.init(dispatcher));
    }

    public static void causeDamage(DamageSource source, LivingEntity target, float amount) {
        SkillSlotsHandler targetHandler;
        if (target.m_9236_().f_46443_) {
            return;
        }
        Entity entity = source.m_7639_();
        if (entity == null) {
            return;
        }
        if (SkillSlotsCommonConfig.interruptedOnHurt && target instanceof ServerPlayer && (targetHandler = SkillSlotsHandler.of(target)) != null) {
            targetHandler.abortUsing();
            SAbortUsingPacket.I.send((ServerPlayer)target, $ -> {});
        }
        if (SkillSlotsCommonConfig.damageAcceleration > 0.0 && entity instanceof ServerPlayer) {
            ServerPlayer sourceEntity = (ServerPlayer)entity;
            SkillSlotsHandler.of((Player)sourceEntity).accelerate(0.05f * amount * (float)SkillSlotsCommonConfig.damageAcceleration);
        }
    }

    public static void clonePlayer(Player original, Player clone) {
        SkillSlotsHandler newHandler = SkillSlotsHandler.of(clone);
        SkillSlotsHandler oldHandler = SkillSlotsHandler.of(original);
        newHandler.copyFrom(oldHandler);
    }

    protected void init(InitEvent event) {
        event.enqueueWork(() -> SkillSlots.SKILL_FACTORIES.add(SimpleSkill::new));
    }

    protected void clientInit(ClientInitEvent event) {
        event.enqueueWork(ClientProxy::loadComplete);
    }
}

