/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots;

import java.util.BitSet;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import snownee.kiwi.util.MathUtil;
import snownee.kiwi.util.NotNullByDefault;
import snownee.skillslots.SkillSlots;
import snownee.skillslots.SkillSlotsCommonConfig;
import snownee.skillslots.SkillSlotsModule;
import snownee.skillslots.client.SkillSlotsClient;
import snownee.skillslots.duck.SkillSlotsPlayer;
import snownee.skillslots.network.CStartUsingPacket;
import snownee.skillslots.skill.SimpleSkill;
import snownee.skillslots.skill.Skill;

@NotNullByDefault
public class SkillSlotsHandler
extends SimpleContainer {
    public static final int MAX_SLOTS = 4;
    public final NonNullList<Skill> skills = NonNullList.m_122780_((int)4, (Object)Skill.EMPTY);
    public BitSet toggles = new BitSet(4);
    public int chargeIndex = -1;
    public int useIndex = -1;
    public int useTick;
    public float acceleration;
    public boolean dirty;
    @Nullable
    private Player owner;
    private int slots;

    public SkillSlotsHandler() {
        super(4);
    }

    public SkillSlotsHandler(@Nullable Player owner) {
        this();
        this.owner = owner;
    }

    @Nullable
    public static SkillSlotsHandler of(@Nullable LivingEntity player) {
        if (player instanceof SkillSlotsPlayer) {
            SkillSlotsPlayer epp = (SkillSlotsPlayer)player;
            return epp.skillslots$getHandler();
        }
        return null;
    }

    @NotNull
    public static SkillSlotsHandler of(Player player) {
        return ((SkillSlotsPlayer)player).skillslots$getHandler();
    }

    public int m_6643_() {
        return this.slots;
    }

    public void setSlots(int slots) {
        this.slots = slots = Mth.m_14045_((int)slots, (int)0, (int)SkillSlotsCommonConfig.maxSlots);
        if (this.useIndex >= slots) {
            this.useIndex = -1;
        }
        this.toggles.clear(slots, 4);
        this.updateCharge();
        this.dirty = true;
    }

    public void m_6596_() {
        super.m_6596_();
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.m_8020_(i);
            if (ItemStack.m_41728_((ItemStack)stack, (ItemStack)((Skill)this.skills.get((int)i)).item)) continue;
            Skill skill = SkillSlots.createSkill(stack);
            this.skills.set(i, (Object)skill);
            this.toggles.clear(i);
            this.updateColor(i);
            if (i == this.chargeIndex) {
                this.updateCharge();
            }
            this.dirty = true;
        }
        if (this.chargeIndex == -1) {
            this.updateCharge();
            if (this.chargeIndex != -1) {
                this.dirty = true;
            }
        }
    }

    public void updateColor(int slot) {
        Skill skill = (Skill)this.skills.get(slot);
        if (this.owner != null && this.owner.m_9236_().f_46443_ && !skill.isEmpty()) {
            SkillSlotsClient.getClientHandler(skill).pickColor(skill, color -> {
                Vector3f hsv = MathUtil.RGBtoHSV((int)color);
                if (Float.isNaN(hsv.x())) {
                    return 0xCCCCCC;
                }
                return Mth.m_14169_((float)hsv.x(), (float)hsv.y(), (float)0.9f);
            });
        }
    }

    public void updateColors() {
        for (int i = 0; i < 4; ++i) {
            this.updateColor(i);
        }
    }

    public void updateCharge() {
        for (int i = 0; i < this.slots; ++i) {
            Skill skill = (Skill)this.skills.get(i);
            int chargeDuration = skill.getChargeDuration(this.owner);
            if (chargeDuration == 0 || !(skill.progress < (float)chargeDuration)) continue;
            this.chargeIndex = i;
            this.dirty = true;
            return;
        }
        if (this.chargeIndex != -1) {
            this.chargeIndex = -1;
            this.dirty = true;
        }
    }

    @NotNull
    public ListTag m_7927_() {
        ListTag listTag = new ListTag();
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Slot", (byte)i);
            stack.m_41739_(tag);
            listTag.add((Object)tag);
        }
        return listTag;
    }

    public void m_7797_(ListTag listTag) {
        int i;
        for (i = 0; i < 4; ++i) {
            this.m_8016_(i);
        }
        for (i = 0; i < listTag.size(); ++i) {
            CompoundTag tag = listTag.m_128728_(i);
            int j = tag.m_128445_("Slot") & 0xFF;
            if (j >= 4) continue;
            this.m_6836_(j, ItemStack.m_41712_((CompoundTag)tag));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Items", (Tag)this.m_7927_());
        tag.m_128405_("UnlockedSlots", this.slots - SkillSlotsCommonConfig.beginnerSlots);
        for (int i = 0; i < 4; ++i) {
            Skill skill = (Skill)this.skills.get(i);
            if (skill.getChargeDuration(this.owner) <= 0) continue;
            tag.m_128350_("Progress" + i, skill.progress);
        }
        byte[] bytes = this.toggles.toByteArray();
        if (bytes.length > 0) {
            tag.m_128382_("Toggles", bytes);
        }
        tag.m_128350_("Acceleration", this.acceleration);
        return tag;
    }

    public void deserializeNBT(CompoundTag data) {
        if (data.m_128425_("Items", 9)) {
            this.m_7797_(data.m_128437_("Items", 10));
        }
        this.slots = data.m_128425_("UnlockedSlots", 3) ? Mth.m_14045_((int)(SkillSlotsCommonConfig.beginnerSlots + data.m_128451_("UnlockedSlots")), (int)0, (int)SkillSlotsCommonConfig.maxSlots) : Math.max(SkillSlotsCommonConfig.beginnerSlots, data.m_128451_("Slots"));
        this.m_6596_();
        for (int i = 0; i < 4; ++i) {
            Skill skill = (Skill)this.skills.get(i);
            if (skill.getChargeDuration(this.owner) <= 0) continue;
            skill.progress = data.m_128457_("Progress" + i);
        }
        if (data.m_128425_("Toggles", 7)) {
            this.toggles = BitSet.valueOf(data.m_128463_("Toggles"));
        }
        this.acceleration = data.m_128457_("Acceleration");
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        if (!stack.m_204117_(SkillSlotsModule.SKILL)) {
            return false;
        }
        Skill skill = SkillSlots.createSkill(stack);
        if (skill.isEmpty()) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (i == slot) continue;
            Skill skillIn = (Skill)this.skills.get(i);
            if (skill.isEmpty() || !skillIn.isConflicting(skill)) continue;
            return false;
        }
        return true;
    }

    public void copyFrom(SkillSlotsHandler that) {
        this.slots = that.slots;
        for (int i = 0; i < 4; ++i) {
            this.m_6836_(i, that.m_8020_(i).m_41777_());
            Skill skill = (Skill)this.skills.get(i);
            if (skill.isEmpty()) continue;
            skill.progress = ((Skill)that.skills.get((int)i)).progress;
        }
        this.chargeIndex = that.chargeIndex;
        this.toggles = (BitSet)that.toggles.clone();
        this.acceleration = that.acceleration;
        this.m_6596_();
    }

    public void tick() {
        if (this.owner == null) {
            return;
        }
        this.acceleration = Math.max(0.0f, this.acceleration - 0.005f);
        for (int i = 0; i < 4; ++i) {
            Skill skill = (Skill)this.skills.get(i);
            if (!(skill instanceof SimpleSkill)) continue;
            SimpleSkill simpleSkill = (SimpleSkill)skill;
            if (!simpleSkill.wasOnCooldown) continue;
            simpleSkill.wasOnCooldown = this.owner.m_36335_().m_41519_(skill.item.m_41720_());
            if (simpleSkill.wasOnCooldown) continue;
            this.playChargeCompleteSound(skill);
        }
        if (this.chargeIndex != -1) {
            Skill skill = (Skill)this.skills.get(this.chargeIndex);
            int chargeDuration = skill.getChargeDuration(this.owner);
            if (chargeDuration == 0) {
                this.updateCharge();
                return;
            }
            float speed = skill.getChargeSpeed(this.owner);
            skill.progress = Mth.m_14036_((float)(skill.progress + speed * this.acceleration), (float)0.0f, (float)chargeDuration);
            if (SkillSlotsCommonConfig.naturallyCharging) {
                skill.progress = Mth.m_14036_((float)(skill.progress + speed), (float)0.0f, (float)chargeDuration);
            }
            if (skill.progress == (float)chargeDuration) {
                this.updateCharge();
                this.playChargeCompleteSound(skill);
            }
        }
        if (this.useIndex != -1) {
            Skill skill = (Skill)this.skills.get(this.useIndex);
            if (skill.canBeToggled()) {
                this.useTick = 0;
                return;
            }
            if (++this.useTick >= skill.getUseDuration()) {
                skill.progress = 0.0f;
                skill.finishUsing(this.owner, this.useIndex);
                this.useTick = 0;
                this.useIndex = -1;
                if (this.chargeIndex == -1) {
                    this.updateCharge();
                }
            }
        }
        if (this.dirty && this.owner instanceof ServerPlayer) {
            SkillSlotsModule.sync((ServerPlayer)this.owner);
        }
    }

    public void startUsing(int slot) {
        if (this.owner == null) {
            return;
        }
        Skill skill = (Skill)this.skills.get(slot);
        if (skill.isEmpty()) {
            return;
        }
        if (skill.canBeToggled()) {
            this.toggles.flip(slot);
            skill.onToggled(this.owner, this, slot);
            if (this.owner.m_9236_().f_46443_) {
                CStartUsingPacket.send(slot);
            }
            return;
        }
        skill.startUsing(this.owner, slot);
        if (skill.getUseDuration() == 0) {
            skill.finishUsing(this.owner, slot);
        } else {
            this.useIndex = slot;
        }
        if (this.owner.m_9236_().f_46443_) {
            CStartUsingPacket.send(slot);
        }
    }

    public void abortUsing() {
        if (this.useIndex == -1) {
            return;
        }
        Skill skill = (Skill)this.skills.get(this.useIndex);
        skill.abortUsing(this.owner, this.useIndex);
        this.useIndex = -1;
        this.useTick = 0;
    }

    public void setOwner(@Nullable Player owner) {
        this.owner = owner;
    }

    public boolean canUseSlot(int slot) {
        if (slot < 0 || slot >= this.slots) {
            return false;
        }
        if (this.owner != null && this.useIndex == -1) {
            Skill skill = (Skill)this.skills.get(slot);
            if (skill.canBeToggled()) {
                return true;
            }
            return skill.canUse(this.owner);
        }
        return false;
    }

    public void accelerate(float f) {
        this.acceleration = Math.min(this.acceleration + f, 2.0f);
        this.dirty = true;
    }

    public void setAll(boolean fill) {
        for (Skill skill : this.skills) {
            int duration = skill.getChargeDuration(this.owner);
            if (duration == 0) continue;
            if (fill && skill.progress < (float)duration) {
                this.playChargeCompleteSound(skill);
            }
            skill.progress = fill ? (float)duration : 0.0f;
        }
        this.updateCharge();
    }

    private void playChargeCompleteSound(Skill skill) {
        if (this.owner == null || this.owner.m_9236_().f_46443_ || !SkillSlotsCommonConfig.playChargeCompleteSound) {
            return;
        }
        @Nullable Holder<SoundEvent> sound = skill.getChargeCompleteSound();
        if (sound != null && sound.m_203633_()) {
            ((ServerPlayer)this.owner).f_8906_.m_9829_((Packet)new ClientboundSoundPacket(sound, SoundSource.PLAYERS, this.owner.m_20182_().m_7096_(), this.owner.m_20182_().m_7098_(), this.owner.m_20182_().m_7094_(), 0.5f, 1.0f, this.owner.m_9236_().m_213780_().m_188505_()));
        }
    }

    public int findActivatedPassiveSkill(Predicate<Skill> predicate) {
        for (int i = 0; i < 4; ++i) {
            Skill skill;
            if (!this.toggles.get(i) || !predicate.test(skill = (Skill)this.skills.get(i))) continue;
            return i;
        }
        return -1;
    }
}

