/*
 * Decompiled with CFR 0.152.
 */
package snownee.skillslots;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import snownee.skillslots.skill.Skill;

public class SkillSlots {
    public static final String ID = "skillslots";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final List<Function<ItemStack, Skill>> SKILL_FACTORIES = Lists.newArrayList();

    public static void registerSkillFactory(Function<ItemStack, Skill> factory) {
        SKILL_FACTORIES.add(0, factory);
    }

    public static Skill createSkill(ItemStack stack) {
        if (stack.m_41619_()) {
            return Skill.EMPTY;
        }
        for (Function<ItemStack, Skill> factory : SKILL_FACTORIES) {
            Skill skill = factory.apply(stack);
            if (skill == null) continue;
            return skill;
        }
        return Skill.EMPTY;
    }
}

