/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateRandomizer {
    public static final Codec<BlockStateRandomizer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().optionalFieldOf("entries").forGetter(selector -> selector.entries), (App)BlockState.f_61039_.fieldOf("default").forGetter(selector -> selector.defaultState)).apply((Applicative)instance, BlockStateRandomizer::new));
    private Optional<List<Entry>> entries = Optional.empty();
    private BlockState defaultState = Blocks.f_50016_.m_49966_();

    public BlockStateRandomizer(Optional<List<Entry>> entries, BlockState defaultBlockState) {
        this.entries = entries;
        this.defaultState = defaultBlockState;
    }

    public BlockState chooseRandomState(RandomSource randomSource) {
        if (this.entries.isPresent()) {
            float total = 0.0f;
            for (Entry entry : this.entries.get()) {
                total += (float)entry.weight;
            }
            if (total != 0.0f) {
                float target = randomSource.m_188501_();
                float currBottom = 0.0f;
                for (Entry entry : this.entries.get()) {
                    if (currBottom <= target && target < currBottom + (float)entry.weight / total) {
                        return entry.blockState;
                    }
                    currBottom += (float)entry.weight / total;
                }
            }
        }
        return this.defaultState;
    }

    public static class Entry {
        public static Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("blockState").forGetter(entry -> entry.blockState), (App)Codec.INT.fieldOf("weight").forGetter(entry -> entry.weight)).apply((Applicative)instance, Entry::new));
        public BlockState blockState;
        public int weight;

        public Entry(BlockState blockState, int weight) {
            this.blockState = blockState;
            this.weight = weight;
        }
    }
}

