/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DecalParticleData
extends AdvancedParticleData {
    public static final ParticleOptions.Deserializer<DecalParticleData> DESERIALIZER = new ParticleOptions.Deserializer<DecalParticleData>(){

        public DecalParticleData fromCommand(ParticleType<DecalParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double airDrag = reader.readDouble();
            reader.expect(' ');
            double red = reader.readDouble();
            reader.expect(' ');
            double green = reader.readDouble();
            reader.expect(' ');
            double blue = reader.readDouble();
            reader.expect(' ');
            double alpha = reader.readDouble();
            reader.expect(' ');
            double scale = reader.readDouble();
            reader.expect(' ');
            double angle = reader.readDouble();
            reader.expect(' ');
            boolean emissive = reader.readBoolean();
            reader.expect(' ');
            double duration = reader.readDouble();
            reader.expect(' ');
            int spriteSize = reader.readInt();
            reader.expect(' ');
            int bufferSize = reader.readInt();
            reader.expect(' ');
            return new DecalParticleData(particleTypeIn, angle, scale, red, green, blue, alpha, airDrag, duration, emissive, spriteSize, bufferSize);
        }

        public DecalParticleData fromNetwork(ParticleType<DecalParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            double airDrag = buffer.readFloat();
            double red = buffer.readFloat();
            double green = buffer.readFloat();
            double blue = buffer.readFloat();
            double alpha = buffer.readFloat();
            double scale = buffer.readFloat();
            double angle = buffer.readFloat();
            boolean emissive = buffer.readBoolean();
            double duration = buffer.readFloat();
            int spriteSize = buffer.readInt();
            int bufferSize = buffer.readInt();
            return new DecalParticleData(particleTypeIn, angle, scale, red, green, blue, alpha, airDrag, duration, emissive, spriteSize, bufferSize);
        }
    };
    private final int spriteSize;
    private final int bufferSize;

    public DecalParticleData(ParticleType<? extends DecalParticleData> type, double rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, int spriteSize, int bufferSize) {
        this(type, rotation, scale, r, g, b, a, drag, duration, emissive, spriteSize, bufferSize, new ParticleComponent[0]);
    }

    public DecalParticleData(ParticleType<? extends DecalParticleData> type, double angle, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, int spriteSize, int bufferSize, ParticleComponent[] components) {
        super(type, new ParticleRotation.EulerAngles((float)angle, 0.0f, 0.0f), scale, r, g, b, a, drag, duration, emissive, false, components);
        this.spriteSize = spriteSize;
        this.bufferSize = bufferSize;
    }

    @Override
    public void m_7711_(FriendlyByteBuf buffer) {
        super.m_7711_(buffer);
    }

    @Override
    public String m_5942_() {
        return super.m_5942_() + " " + this.spriteSize + " " + this.bufferSize;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getAngle() {
        if (this.getRotation() instanceof ParticleRotation.EulerAngles) {
            return ((ParticleRotation.EulerAngles)this.getRotation()).yaw;
        }
        return 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSpriteSize() {
        return this.spriteSize;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBufferSize() {
        return this.bufferSize;
    }

    public static Codec<DecalParticleData> CODEC_DECAL(ParticleType<DecalParticleData> particleType) {
        return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.DOUBLE.fieldOf("scale").forGetter(AdvancedParticleData::getScale), (App)Codec.DOUBLE.fieldOf("r").forGetter(AdvancedParticleData::getRed), (App)Codec.DOUBLE.fieldOf("g").forGetter(AdvancedParticleData::getGreen), (App)Codec.DOUBLE.fieldOf("b").forGetter(AdvancedParticleData::getBlue), (App)Codec.DOUBLE.fieldOf("a").forGetter(AdvancedParticleData::getAlpha), (App)Codec.DOUBLE.fieldOf("drag").forGetter(AdvancedParticleData::getAirDrag), (App)Codec.DOUBLE.fieldOf("duration").forGetter(AdvancedParticleData::getDuration), (App)Codec.BOOL.fieldOf("emissive").forGetter(AdvancedParticleData::isEmissive), (App)Codec.DOUBLE.fieldOf("angle").forGetter(DecalParticleData::getAngle), (App)Codec.INT.fieldOf("sprite_size").forGetter(DecalParticleData::getSpriteSize), (App)Codec.INT.fieldOf("buffer_size").forGetter(DecalParticleData::getBufferSize)).apply((Applicative)codecBuilder, (scale, r, g, b, a, drag, duration, emissive, angle, spriteSize, bufferSize) -> new DecalParticleData((ParticleType<? extends DecalParticleData>)particleType, (double)angle, (double)scale, (double)r, (double)g, (double)b, (double)a, (double)drag, (double)duration, (boolean)emissive, (int)spriteSize, (int)bufferSize, new ParticleComponent[0])));
    }
}

