/*
 * Decompiled with CFR 0.152.
 */
package net.sdm.sdm_core.api;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class ChunkHelper {
    @Nullable
    public static BlockPos getSafeSpawnPos(ServerLevel level, BlockPos pos, int zone) {
        int x1 = pos.m_123341_() - zone;
        int y1 = pos.m_123342_() - zone;
        int z1 = pos.m_123343_() - zone;
        int x2 = pos.m_123341_() + zone;
        int y2 = pos.m_123342_() + zone;
        int z2 = pos.m_123343_() + zone;
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    BlockPos d1 = new BlockPos(x, y, z);
                    if (!level.m_8055_(d1.m_7495_()).m_60815_() || !level.m_8055_(d1).m_60795_() || !level.m_8055_(d1.m_7494_()).m_60795_()) continue;
                    return d1;
                }
            }
        }
        return null;
    }

    public static void unloadChunk(ServerLevel serverLevel, ChunkPos pos) {
        LevelChunk chunk = serverLevel.m_7726_().m_7131_(pos.f_45578_, pos.f_45579_);
        if (chunk != null) {
            serverLevel.m_8712_(chunk);
        }
    }

    public static ChunkAccess getChunkAndLoad(ServerLevel world, ChunkPos pos) {
        return world.m_7726_().m_7587_(pos.f_45578_, pos.f_45579_, ChunkStatus.f_62326_, true);
    }

    public static boolean isLevelHavePlayers(LevelAccessor level) {
        return !level.m_6907_().isEmpty();
    }

    public static Player getNearestPlayer(LevelAccessor level, BlockPos pos) {
        List players = level.m_6907_();
        Player nearestPlayer = null;
        double minDistance = Double.MAX_VALUE;
        for (Player player : players) {
            double distance = player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    public static Player getNearestPlayer(MinecraftServer level, BlockPos pos) {
        List players = level.m_6846_().m_11314_();
        Player nearestPlayer = null;
        double minDistance = Double.MAX_VALUE;
        for (Player player : players) {
            double distance = player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }
}

