/*
 * Decompiled with CFR 0.152.
 */
package net.sdm.sdm_core.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sdm.sdm_core.SDMCore;
import net.sdm.sdm_core.api.ChunkHelper;
import net.sdm.sdm_core.generation.GenerationProperties;
import net.sdm.sdm_core.generation.GenerationProperty;

public class ChunkGenerationHelper {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();

    public static void despawnAllEntities(ServerLevel level, BoundingBox bx) {
        List entities = level.m_45976_(Mob.class, new AABB((double)bx.m_162395_(), (double)bx.m_162396_(), (double)bx.m_162398_(), (double)bx.m_162399_(), (double)bx.m_162400_(), (double)bx.m_162401_()));
        entities.forEach(Entity::m_146870_);
        List cards = level.m_45976_(AbstractMinecart.class, new AABB((double)bx.m_162395_(), (double)bx.m_162396_(), (double)bx.m_162398_(), (double)bx.m_162399_(), (double)bx.m_162400_(), (double)bx.m_162401_()));
        cards.forEach(entity -> {
            if (entity instanceof MinecartChest) {
                MinecartChest chest = (MinecartChest)entity;
                for (int i = 0; i < chest.m_6643_(); ++i) {
                    chest.m_6836_(i, ItemStack.f_41583_);
                }
            }
            entity.m_146870_();
        });
    }

    public static void destroyAllChests(ServerLevel level, BoundingBox bx) {
        for (int i = bx.m_162395_(); i < bx.m_162399_(); ++i) {
            for (int j = bx.m_162396_(); j < bx.m_162400_(); ++j) {
                for (int k = bx.m_162398_(); k < bx.m_162401_(); ++k) {
                    BlockPos pb = new BlockPos(i, j, k);
                    BlockEntity blockEntity = level.m_7702_(pb);
                    if (!(blockEntity instanceof BaseContainerBlockEntity)) continue;
                    BaseContainerBlockEntity chest = (BaseContainerBlockEntity)blockEntity;
                    for (int i1 = 0; i1 < chest.m_6643_(); ++i1) {
                        chest.m_6836_(i1, ItemStack.f_41583_);
                    }
                    level.m_46597_(pb, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    public static void respawnStructureBasicMainThread(ServerLevel serverlevel, BlockPos pos, Predicate<Structure> predicate, boolean despawnAllEntities) {
        List start = serverlevel.m_215010_().m_220477_(new ChunkPos(pos), predicate);
        if (!start.isEmpty()) {
            if (despawnAllEntities) {
                ChunkGenerationHelper.despawnAllEntities(serverlevel, ((StructureStart)start.get(0)).m_73601_());
            }
            serverlevel.m_7654_().m_18707_(() -> {
                ChunkHelper.getChunkAndLoad(serverlevel, new ChunkPos(pos));
                ChunkGenerationHelper.destroyAllChests(serverlevel, ((StructureStart)start.get(0)).m_73601_());
                ((StructureStart)start.get(0)).m_226850_((WorldGenLevel)serverlevel, serverlevel.m_215010_(), serverlevel.m_7726_().m_8481_(), serverlevel.f_46441_, ((StructureStart)start.get(0)).m_73601_(), ((StructureStart)start.get(0)).m_163625_());
                SDMCore.LOGGER.info("Structure reseted !");
                ChunkHelper.unloadChunk(serverlevel, new ChunkPos(pos));
            });
        }
    }

    public static void respawnStructureBasic(ServerLevel serverlevel, BlockPos pos, Predicate<Structure> predicate, boolean despawnAllEntities) {
        List start = serverlevel.m_215010_().m_220477_(new ChunkPos(pos), predicate);
        if (!start.isEmpty()) {
            if (despawnAllEntities) {
                ChunkGenerationHelper.despawnAllEntities(serverlevel, ((StructureStart)start.get(0)).m_73601_());
            }
            executor.execute(() -> {
                ChunkHelper.getChunkAndLoad(serverlevel, new ChunkPos(pos));
                ChunkGenerationHelper.destroyAllChests(serverlevel, ((StructureStart)start.get(0)).m_73601_());
                ((StructureStart)start.get(0)).m_226850_((WorldGenLevel)serverlevel, serverlevel.m_215010_(), serverlevel.m_7726_().m_8481_(), serverlevel.f_46441_, ((StructureStart)start.get(0)).m_73601_(), ((StructureStart)start.get(0)).m_163625_());
                SDMCore.LOGGER.info("Structure reseted !");
                ChunkHelper.unloadChunk(serverlevel, new ChunkPos(pos));
            });
        }
    }

    public static void regenerateChunk(ServerLevel serverlevel, ResourceLocation dimID, Vec3 vec3, int counts, boolean ignoreOldChunks) {
        for (ServerLevel allLevel : serverlevel.m_7654_().m_129785_()) {
            if (!allLevel.m_46472_().m_135782_().equals((Object)dimID)) continue;
            ChunkGenerationHelper.regenerateChunk(serverlevel, vec3, counts, ignoreOldChunks, new GenerationProperties().addProperty(GenerationProperty.create("chunkGenerator", allLevel.m_7726_().m_8481_())));
            return;
        }
    }

    public static void regenerateChunk(ServerLevel serverlevel, Vec3 vec3, int counts, boolean ignoreOldChunks) {
        ChunkGenerationHelper.regenerateChunk(serverlevel, vec3, counts, ignoreOldChunks, (ImmutableList<ChunkStatus>)ImmutableList.of((Object)ChunkStatus.f_62317_, (Object)ChunkStatus.f_62318_, (Object)ChunkStatus.f_62319_, (Object)ChunkStatus.f_62320_, (Object)ChunkStatus.f_62322_, (Object)ChunkStatus.f_279614_), new GenerationProperties().addProperty(GenerationProperty.create("chunkGenerator", serverlevel.m_7726_().m_8481_())));
    }

    public static void regenerateChunk(ServerLevel serverlevel, Vec3 vec3, int counts, boolean ignoreOldChunks, GenerationProperties properties) {
        ChunkGenerationHelper.regenerateChunk(serverlevel, vec3, counts, ignoreOldChunks, (ImmutableList<ChunkStatus>)ImmutableList.of((Object)ChunkStatus.f_62317_, (Object)ChunkStatus.f_62318_, (Object)ChunkStatus.f_62319_, (Object)ChunkStatus.f_62320_, (Object)ChunkStatus.f_62322_, (Object)ChunkStatus.f_279614_), properties);
    }

    public static void regenerateChunk(ServerLevel serverlevel, Vec3 vec3, int counts, boolean ignoreOldChunks, ImmutableList<ChunkStatus> statuses, GenerationProperties properties) {
        ServerChunkCache serverchunkcache = serverlevel.m_7726_();
        serverchunkcache.f_8325_.m_183825_();
        ChunkPos chunkpos = new ChunkPos(BlockPos.m_274446_((Position)vec3));
        int i = chunkpos.f_45579_ - counts;
        int j = chunkpos.f_45579_ + counts;
        int k = chunkpos.f_45578_ - counts;
        int l = chunkpos.f_45578_ + counts;
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                ChunkPos chunkpos1 = new ChunkPos(j1, i1);
                LevelChunk levelchunk = serverchunkcache.m_62227_(j1, i1, false);
                if (levelchunk == null || ignoreOldChunks && levelchunk.m_187675_()) continue;
                for (BlockPos blockpos : BlockPos.m_121976_((int)chunkpos1.m_45604_(), (int)serverlevel.m_141937_(), (int)chunkpos1.m_45605_(), (int)chunkpos1.m_45608_(), (int)(serverlevel.m_151558_() - 1), (int)chunkpos1.m_45609_())) {
                    serverlevel.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 16);
                }
            }
        }
        ProcessorMailbox processormailbox = ProcessorMailbox.m_18751_((Executor)Util.m_183991_(), (String)"worldgen-resetchunks");
        long j3 = System.currentTimeMillis();
        int k3 = (counts * 2 + 1) * (counts * 2 + 1);
        for (ChunkStatus chunkstatus : statuses) {
            long k1 = System.currentTimeMillis();
            CompletionStage<Object> completablefuture = CompletableFuture.supplyAsync(() -> Unit.INSTANCE, arg_0 -> ((ProcessorMailbox)processormailbox).m_6937_(arg_0));
            for (int i2 = chunkpos.f_45579_ - counts; i2 <= chunkpos.f_45579_ + counts; ++i2) {
                for (int j2 = chunkpos.f_45578_ - counts; j2 <= chunkpos.f_45578_ + counts; ++j2) {
                    ChunkPos chunkpos2 = new ChunkPos(j2, i2);
                    LevelChunk levelchunk1 = serverchunkcache.m_62227_(j2, i2, false);
                    if (levelchunk1 == null || ignoreOldChunks && levelchunk1.m_187675_()) continue;
                    ArrayList list = Lists.newArrayList();
                    int k2 = Math.max(1, chunkstatus.m_62488_());
                    for (int l2 = chunkpos2.f_45579_ - k2; l2 <= chunkpos2.f_45579_ + k2; ++l2) {
                        for (int i3 = chunkpos2.f_45578_ - k2; i3 <= chunkpos2.f_45578_ + k2; ++i3) {
                            ChunkAccess chunkaccess = serverchunkcache.m_7587_(i3, l2, chunkstatus.m_62482_(), true);
                            Object chunkaccess1 = chunkaccess instanceof ImposterProtoChunk ? new ImposterProtoChunk(((ImposterProtoChunk)chunkaccess).m_62768_(), true) : (chunkaccess instanceof LevelChunk ? new ImposterProtoChunk((LevelChunk)chunkaccess, true) : chunkaccess);
                            list.add(chunkaccess1);
                        }
                    }
                    completablefuture = completablefuture.thenComposeAsync(p_280957_ -> {
                        Object d1 = properties.propertyHashMap.get("chunkGenerator").value();
                        return chunkstatus.m_280308_(arg_0 -> ((ProcessorMailbox)processormailbox).m_6937_(arg_0), serverlevel, d1 != null ? (ChunkGenerator)d1 : serverchunkcache.m_8481_(), serverlevel.m_215082_(), serverchunkcache.m_7827_(), p_183691_ -> {
                            throw new UnsupportedOperationException("Not creating full chunks here");
                        }, list).thenApply(p_183681_ -> {
                            if (chunkstatus == ChunkStatus.f_62318_) {
                                p_183681_.left().ifPresent(p_183671_ -> Heightmap.m_64256_((ChunkAccess)p_183671_, (Set)ChunkStatus.f_62328_));
                            }
                            return Unit.INSTANCE;
                        });
                    }, arg_0 -> ((ProcessorMailbox)processormailbox).m_6937_(arg_0));
                }
            }
            serverlevel.m_7654_().m_18701_(() -> completablefuture.isDone());
            SDMCore.LOGGER.debug(chunkstatus + " took " + (System.currentTimeMillis() - k1) + " ms");
        }
        long l3 = System.currentTimeMillis();
        for (int i4 = chunkpos.f_45579_ - counts; i4 <= chunkpos.f_45579_ + counts; ++i4) {
            for (int l1 = chunkpos.f_45578_ - counts; l1 <= chunkpos.f_45578_ + counts; ++l1) {
                ChunkPos chunkpos3 = new ChunkPos(l1, i4);
                LevelChunk levelchunk2 = serverchunkcache.m_62227_(l1, i4, false);
                if (levelchunk2 == null || ignoreOldChunks && levelchunk2.m_187675_()) continue;
                for (BlockPos blockpos1 : BlockPos.m_121976_((int)chunkpos3.m_45604_(), (int)serverlevel.m_141937_(), (int)chunkpos3.m_45605_(), (int)chunkpos3.m_45608_(), (int)(serverlevel.m_151558_() - 1), (int)chunkpos3.m_45609_())) {
                    serverchunkcache.m_8450_(blockpos1);
                }
            }
        }
        SDMCore.LOGGER.debug("blockChanged took " + (System.currentTimeMillis() - l3) + " ms");
        long j4 = System.currentTimeMillis() - j3;
        SDMCore.LOGGER.info(String.format(Locale.ROOT, "%d chunks have been reset. This took %d ms for %d chunks, or %02f ms per chunk", k3, j4, k3, Float.valueOf((float)j4 / (float)k3)));
    }
}

