/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.mobplayeranimator.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.Thelnfamous1.mobplayeranimator.Constants;
import me.Thelnfamous1.mobplayeranimator.api.PlayerAnimatorHelper;
import me.Thelnfamous1.mobplayeranimator.api.part.MPAModelModifier;
import me.Thelnfamous1.mobplayeranimator.config.MPAClientConfig;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ClientConfigHelper {
    private final MPAClientConfig clientConfig;
    private final Set<EntityType<?>> emfAnimationHaltBlacklist = new HashSet();
    private final Set<EntityType<?>> emfForceVanillaModels = new HashSet();
    private final Set<ResourceLocation> emfAnimationHaltAnimationBlacklist = new HashSet<ResourceLocation>();
    private final Map<EntityType<?>, MPAModelModifier> emfModelModifiers = new LinkedHashMap();

    public ClientConfigHelper(MPAClientConfig clientConfig, boolean log) {
        this.clientConfig = clientConfig;
        ClientConfigHelper.fillEntityTypeSetWithEntries(clientConfig.emf_animation_halt_blacklist, this.emfAnimationHaltBlacklist, "emf_animation_halt_blacklist", log);
        ClientConfigHelper.fillEntityTypeSetWithEntries(clientConfig.emf_force_vanilla_models, this.emfForceVanillaModels, "emf_force_vanilla_models", log);
        ClientConfigHelper.fillResourceLocationSetWithEntries(clientConfig.emf_animation_halt_animation_blacklist, this.emfAnimationHaltAnimationBlacklist, "emf_animation_halt_animation_blacklist", log);
        clientConfig.emf_model_modifiers.forEach((key, value) -> {
            Codec<? extends EntityType<?>> resourceLocationToEntityType = ClientConfigHelper.getResourceLocationToEntityTypeCodec();
            EntityType entityType = resourceLocationToEntityType.parse((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(key)).result().orElse(null);
            if (entityType == null) {
                if (log) {
                    Constants.LOG.error("Could not parse {} entry key {}, not a valid namespaced id", (Object)"emf_model_modifiers", key);
                }
                return;
            }
            MPAModelModifier modelModifier = (MPAModelModifier)MPAModelModifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)new Gson().fromJson(value, JsonObject.class))).getOrThrow(false, arg_0 -> ((Logger)Constants.LOG).error(arg_0));
            if (modelModifier == null) {
                if (log) {
                    Constants.LOG.error("Could not parse {} entry value {} mapped to {}, not a valid model modifier", new Object[]{"emf_model_modifiers", key, value});
                }
                return;
            }
            if (log) {
                Constants.LOG.debug("Entered {}:{} into the emf_model_modifiers map!", key, value);
            }
            this.emfModelModifiers.put(entityType, modelModifier);
        });
    }

    private static Codec<? extends EntityType<?>> getResourceLocationToEntityTypeCodec() {
        return ResourceLocation.f_135803_.comapFlatMap(rl -> {
            if (BuiltInRegistries.f_256780_.m_7804_(rl)) {
                return DataResult.success((Object)((EntityType)BuiltInRegistries.f_256780_.m_7745_(rl)));
            }
            return DataResult.error(() -> String.format("Could not parse %s, not a valid entity type", rl));
        }, arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256780_).m_7981_(arg_0));
    }

    private static void fillResourceLocationSetWithEntries(String[] configEntries, Set<ResourceLocation> configSet, String configName, boolean log) {
        for (String entry : configEntries) {
            ResourceLocation id = ResourceLocation.m_135820_((String)entry);
            if (id == null) {
                if (!log) continue;
                Constants.LOG.error("Could not parse " + configName + " entry {}, not a valid namespaced id", (Object)entry);
                continue;
            }
            configSet.add(id);
            if (!log) continue;
            Constants.LOG.info("Entered {} into the " + configName + " set!", (Object)id);
        }
    }

    private static void fillEntityTypeSetWithEntries(String[] configEntries, Set<EntityType<?>> configSet, String configName, boolean log) {
        for (String entry : configEntries) {
            ResourceLocation id = ResourceLocation.m_135820_((String)entry);
            if (id == null) {
                if (!log) continue;
                Constants.LOG.error("Could not parse " + configName + " entry {}, not a valid namespaced id", (Object)entry);
                continue;
            }
            Optional entityType = BuiltInRegistries.f_256780_.m_6612_(id);
            entityType.ifPresentOrElse(et -> {
                configSet.add((EntityType<?>)et);
                if (log) {
                    Constants.LOG.info("Entered {} into the " + configName + " set!", (Object)id);
                }
            }, () -> {
                if (log) {
                    Constants.LOG.error("Could not find " + configName + " entry {}, not a valid entity type", (Object)id);
                }
            });
        }
    }

    public boolean isAnimationHaltedForEMF(Entity entity) {
        return !this.emfAnimationHaltBlacklist.contains(entity.m_6095_());
    }

    public boolean isVanillaModelForcedForEMF(Entity entity) {
        return this.emfForceVanillaModels.contains(entity.m_6095_());
    }

    public boolean isAnimatingAnyNonBlacklistedAnimation(LivingEntity entity) {
        if (entity instanceof IAnimatedPlayer) {
            IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)entity;
            AnimationStack animationStack = animatedPlayer.getAnimationStack();
            if (this.emfAnimationHaltAnimationBlacklist.isEmpty()) {
                return animationStack.isActive();
            }
            return ClientConfigHelper.isAnyNonBlacklistedAnimationActive((IAnimation)animationStack, this.emfAnimationHaltAnimationBlacklist);
        }
        return false;
    }

    private static boolean isAnyNonBlacklistedAnimationActive(IAnimation animation, Collection<ResourceLocation> blacklistedAnimationIds) {
        return PlayerAnimatorHelper.recursiveAnimationTest(animation, keyframeAnimationPlayer -> ClientConfigHelper.isNonBlacklistedAnimationActive(keyframeAnimationPlayer, blacklistedAnimationIds));
    }

    private static boolean isNonBlacklistedAnimationActive(KeyframeAnimationPlayer keyframeAnimationPlayer, Collection<ResourceLocation> blacklistedAnimationIds) {
        if (keyframeAnimationPlayer.isActive()) {
            if (blacklistedAnimationIds.isEmpty()) {
                return true;
            }
            for (ResourceLocation id : blacklistedAnimationIds) {
                KeyframeAnimation blacklistedAnimation = PlayerAnimationRegistry.getAnimation((ResourceLocation)id);
                if (keyframeAnimationPlayer.getData().equals((Object)blacklistedAnimation)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public MPAModelModifier getModelModifier(EntityType<?> type) {
        return this.emfModelModifiers.get(type);
    }
}

