/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.mobplayeranimator.api.part;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.Thelnfamous1.mobplayeranimator.MobPlayerAnimatorClient;
import me.Thelnfamous1.mobplayeranimator.api.part.DefaultAnimatedGroups;
import me.Thelnfamous1.mobplayeranimator.api.part.MPABodyPart;
import me.Thelnfamous1.mobplayeranimator.api.part.MPAPartModifier;
import me.Thelnfamous1.mobplayeranimator.api.part.MPAPartPath;
import net.minecraft.client.model.geom.ModelPart;

public class MPAModelModifier {
    public static final Codec<MPAModelModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(MPAPartPath.CODEC, MPAPartModifier.CODEC).fieldOf("part_modifiers").forGetter(o -> o.partModifiers)).apply((Applicative)instance, MPAModelModifier::new));
    private final Map<MPAPartPath, MPAPartModifier> partModifiers = new HashMap<MPAPartPath, MPAPartModifier>();

    public MPAModelModifier(Map<MPAPartPath, MPAPartModifier> partModifiers) {
        this.partModifiers.putAll(partModifiers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<MPAPartPath, ModelPart> modify(ModelPart root, Set<MPABodyPart> animatedParts) {
        HashMap<MPAPartPath, ModelPart> modifiedParts = new HashMap<MPAPartPath, ModelPart>();
        for (Map.Entry<MPAPartPath, MPAPartModifier> entry : this.partModifiers.entrySet()) {
            MPAPartModifier partModifier;
            MPAPartPath partPath = entry.getKey();
            ModelPart part = partPath.findPart(root);
            if (part == null || !MPAModelModifier.canApplyPartModifier(partPath, partModifier = entry.getValue(), animatedParts)) continue;
            partModifier.modify(part);
            modifiedParts.put(partPath, part);
        }
        return modifiedParts;
    }

    private static boolean canApplyPartModifier(MPAPartPath partPath, MPAPartModifier partModifier, Set<MPABodyPart> animatedParts) {
        Set<MPABodyPart> animatedGroup = partModifier.getAnimatedGroup();
        if (animatedGroup.isEmpty() && MobPlayerAnimatorClient.getClientConfig().guess_emf_part_modifier_animated_groups) {
            animatedGroup = DefaultAnimatedGroups.guessAnimatedGroup(partPath, animatedGroup);
        }
        boolean canModify = animatedGroup.isEmpty();
        for (MPABodyPart animatedPart : animatedParts) {
            if (!animatedGroup.contains((Object)animatedPart)) continue;
            canModify = true;
            break;
        }
        return canModify;
    }

    public Map<MPAPartPath, Optional<ModelPart>> getAffectedParts(ModelPart root, Set<MPABodyPart> animatedParts) {
        return this.partModifiers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> MPAModelModifier.canApplyPartModifier((MPAPartPath)entry.getKey(), (MPAPartModifier)entry.getValue(), animatedParts) ? Optional.ofNullable(((MPAPartPath)entry.getKey()).findPart(root)) : Optional.empty()));
    }

    public static class Builder {
        private final Map<MPAPartPath, MPAPartModifier> partModifiers = new HashMap<MPAPartPath, MPAPartModifier>();

        public Builder withPartModifier(MPAPartPath partPath, MPAPartModifier partModifier) {
            this.partModifiers.put(partPath, partModifier);
            return this;
        }

        public MPAModelModifier build() {
            return new MPAModelModifier(this.partModifiers);
        }
    }
}

