/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.mobplayeranimator.api;

import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MobAnimationFactory {
    public static final FactoryHolder ANIMATION_DATA_FACTORY = new FactoryHolder();

    @Nullable
    public IAnimation invoke(@NotNull Mob var1);

    public static class FactoryHolder {
        private static final List<Function<Mob, DataHolder>> factories = new ArrayList<Function<Mob, DataHolder>>();

        private FactoryHolder() {
        }

        public void registerFactory(@Nullable ResourceLocation id, int priority, @NotNull MobAnimationFactory factory) {
            factories.add(player -> Optional.ofNullable(factory.invoke((Mob)player)).map(animation -> new DataHolder(id, priority, (IAnimation)animation)).orElse(null));
        }

        @ApiStatus.Internal
        public void prepareAnimations(Mob mob, AnimationStack playerStack, Map<ResourceLocation, IAnimation> animationMap) {
            for (Function<Mob, DataHolder> factory : factories) {
                DataHolder dataHolder = factory.apply(mob);
                if (dataHolder == null) continue;
                playerStack.addAnimLayer(dataHolder.priority(), dataHolder.animation());
                if (dataHolder.id() == null) continue;
                animationMap.put(dataHolder.id(), dataHolder.animation());
            }
        }

        @ApiStatus.Internal
        private record DataHolder(@Nullable ResourceLocation id, int priority, @NotNull IAnimation animation) {
        }
    }
}

