/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.mobplayeranimator;

import me.Thelnfamous1.mobplayeranimator.Constants;
import me.Thelnfamous1.mobplayeranimator.compat.EMFCompat;
import me.Thelnfamous1.mobplayeranimator.config.ClientConfigHelper;
import me.Thelnfamous1.mobplayeranimator.config.MPAClientConfig;
import me.Thelnfamous1.mobplayeranimator.config.MPAClientConfigWrapper;
import me.Thelnfamous1.mobplayeranimator.platform.Services;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.world.InteractionResult;

public class MobPlayerAnimatorClient {
    private static MPAClientConfig clientConfig;
    private static ClientConfigHelper clientConfigHelper;
    private static boolean emfLoaded;

    public static void init() {
        if (Services.PLATFORM.isModLoaded("entity_model_features")) {
            emfLoaded = true;
            EMFCompat.registerVariables();
        }
        ConfigHolder holder = AutoConfig.register(MPAClientConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        holder.registerSaveListener((ch, ccw) -> MobPlayerAnimatorClient.onConfigUpdated(ccw));
        holder.registerLoadListener((ch, ccw) -> MobPlayerAnimatorClient.onConfigUpdated(ccw));
        MobPlayerAnimatorClient.updateClientConfig(((MPAClientConfigWrapper)holder.getConfig()).client, false);
    }

    private static InteractionResult onConfigUpdated(MPAClientConfigWrapper ccw) {
        MobPlayerAnimatorClient.updateClientConfig(ccw.client, true);
        return InteractionResult.PASS;
    }

    private static void updateClientConfig(MPAClientConfig config, boolean log) {
        clientConfig = config;
        clientConfigHelper = new ClientConfigHelper(config, log);
        if (log) {
            Constants.LOG.info("Client config updated!");
        }
    }

    public static MPAClientConfig getClientConfig() {
        return clientConfig;
    }

    public static ClientConfigHelper getClientConfigHelper() {
        return clientConfigHelper;
    }

    public static boolean isEMFLoaded() {
        return emfLoaded;
    }
}

