/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs.laviathan;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.crimsoncrips.alexsmobsinteraction.datagen.loottables.AMILootTables;
import com.crimsoncrips.alexsmobsinteraction.misc.AMIUtils;
import com.crimsoncrips.alexsmobsinteraction.misc.interfaces.AMIBaseInterfaces;
import com.github.alexthe666.alexsmobs.entity.EntityLaviathan;
import com.github.alexthe666.alexsmobs.entity.IHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityLaviathan.class})
public abstract class AMILaviathan
extends Animal
implements ISemiAquatic,
IHerdPanic,
AMIBaseInterfaces {
    private static final EntityDataAccessor<Boolean> RELAVA = SynchedEntityData.m_135353_(EntityLaviathan.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Shadow
    protected abstract float getXForPart(float var1, float var2);

    @Shadow
    protected abstract float getZForPart(float var1, float var2);

    protected AMILaviathan(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean shouldEnterWater() {
        boolean relava = (Boolean)AlexsMobsInteraction.COMMON_CONFIG.OBSIDIAN_EXTRACT_ENABLED.get() == false || this.isRelava();
        return !this.m_20160_() && !relava;
    }

    public boolean shouldLeaveWater() {
        boolean relava = (Boolean)AlexsMobsInteraction.COMMON_CONFIG.OBSIDIAN_EXTRACT_ENABLED.get() == false || this.isRelava();
        return this.m_20160_() && relava;
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(RELAVA, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditional(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("Relava", this.isRelava());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditional(CompoundTag compound, CallbackInfo ci) {
        this.setRelava(compound.m_128471_("Relava"));
    }

    @Override
    public boolean isRelava() {
        return (Boolean)this.f_19804_.m_135370_(RELAVA);
    }

    public void setRelava(boolean relava) {
        this.f_19804_.m_135381_(RELAVA, (Object)relava);
    }

    public boolean m_6126_() {
        return super.m_6126_() || this.isRelava();
    }

    @Inject(method={"mobInteract"}, at={@At(value="TAIL")})
    private void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        EntityLaviathan laviathan = (EntityLaviathan)this;
        if (player.m_21205_().m_41720_() instanceof PickaxeItem && laviathan.isObsidian()) {
            this.setRelava(true);
            laviathan.setObsidian(false);
            this.m_5496_(SoundEvents.f_12555_, 2.0f, this.m_6100_());
            AMIUtils.spawnLoot(AMILootTables.OBSIDIAN_EXTRACT, (LivingEntity)laviathan, (Entity)player, 0);
            player.m_21205_().m_41622_(1, (LivingEntity)this, p_233654_0_ -> {});
            this.m_6469_(laviathan.m_269291_().m_269264_(), 10.0f);
            AMIUtils.awardAdvancement((Entity)player, "obsidian_extract", "extract");
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        EntityLaviathan laviathan = (EntityLaviathan)this;
        if (!laviathan.isObsidian() && !this.m_20072_() && this.isRelava() && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.OBSIDIAN_EXTRACT_ENABLED.get()).booleanValue()) {
            if (this.getPersistentData().m_128451_("RelavaTicks") < 6000) {
                this.getPersistentData().m_128405_("RelavaTicks", this.getPersistentData().m_128451_("RelavaTicks") + 1);
            } else {
                this.setRelava(false);
            }
        }
        if (this.m_9236_().f_46443_ && this.isRelava() && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.OBSIDIAN_EXTRACT_ENABLED.get()).booleanValue()) {
            float yaw = laviathan.m_146908_() * ((float)Math.PI / 180);
            if (!this.m_6162_() && this.f_19796_.m_188500_() < 0.1) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (double)(this.getXForPart(yaw, 158.0f) * 1.75f), this.m_20227_(1.0), this.m_20189_() + (double)(this.getZForPart(yaw, 158.0f) * 1.75f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (double)(this.getXForPart(yaw, -166.0f) * 1.48f), this.m_20227_(1.0), this.m_20189_() + (double)(this.getZForPart(yaw, -166.0f) * 1.48f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (double)(this.getXForPart(yaw, 14.0f) * 1.78f), this.m_20227_(0.9), this.m_20189_() + (double)(this.getZForPart(yaw, 14.0f) * 1.78f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (double)(this.getXForPart(yaw, -14.0f) * 1.6f), this.m_20227_(1.1), this.m_20189_() + (double)(this.getZForPart(yaw, -14.0f) * 1.6f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/github/alexthe666/alexsmobs/entity/EntityLaviathan;isObsidian()Z", ordinal=1)}, cancellable=true)
    private void alter1(CallbackInfo ci) {
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.OBSIDIAN_EXTRACT_ENABLED.get()).booleanValue() && this.isRelava()) {
            ci.cancel();
        }
    }
}

