/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs.kangaroo;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.github.alexthe666.alexsmobs.entity.EntityKangaroo;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityKangaroo.class})
public abstract class AMIKangaroo
extends TamableAnimal {
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> SWORD_INDEX;
    @Shadow
    public SimpleContainer kangarooInventory;
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> HELMET_INDEX;
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> CHEST_INDEX;
    private static final EntityDataAccessor<Integer> TOTEM_INDEX;

    @Shadow
    protected abstract void updateClientInventory();

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    protected AMIKangaroo(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @ModifyReturnValue(method={"getItemBySlot"}, at={@At(value="RETURN")})
    private ItemStack alexsMobsInteraction$getItemBySlot(ItemStack original, @Local EquipmentSlot slot) {
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.PROPER_ARMAMENTS_ENABLED.get()).booleanValue()) {
            if (slot == EquipmentSlot.MAINHAND) {
                return this.getItemInHand(slot);
            }
            if (slot == EquipmentSlot.OFFHAND) {
                return this.getItemInOffHand(slot);
            }
            return this.getArmorInSlot(slot);
        }
        return original;
    }

    @Inject(method={"resetKangarooSlots"}, at={@At(value="TAIL")}, remap=false)
    private void registerGoals(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_ && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.PROPER_ARMAMENTS_ENABLED.get()).booleanValue()) {
            int totemIndex = -1;
            for (int i = 0; i < this.kangarooInventory.m_6643_(); ++i) {
                ItemStack stack = this.kangarooInventory.m_8020_(i);
                if (stack.m_41619_() || !stack.m_150930_(Items.f_42747_)) continue;
                totemIndex = i;
            }
            this.f_19804_.m_135381_(TOTEM_INDEX, (Object)totemIndex);
            this.updateClientInventory();
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void define(CallbackInfo ci) {
        this.f_19804_.m_135372_(TOTEM_INDEX, (Object)-1);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void add(CompoundTag compound, CallbackInfo ci) {
        compound.m_128405_("TotemIndex", ((Integer)this.f_19804_.m_135370_(TOTEM_INDEX)).intValue());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void read(CompoundTag compound, CallbackInfo ci) {
        this.f_19804_.m_135381_(TOTEM_INDEX, (Object)compound.m_128451_("TotemInvIndex"));
    }

    private ItemStack getArmorInSlot(EquipmentSlot slot) {
        int helmIndex = (Integer)this.f_19804_.m_135370_(HELMET_INDEX);
        int chestIndex = (Integer)this.f_19804_.m_135370_(CHEST_INDEX);
        return slot == EquipmentSlot.HEAD && helmIndex >= 0 ? this.kangarooInventory.m_8020_(helmIndex) : (slot == EquipmentSlot.CHEST && chestIndex >= 0 ? this.kangarooInventory.m_8020_(chestIndex) : ItemStack.f_41583_);
    }

    private ItemStack getItemInHand(EquipmentSlot slot) {
        int index = (Integer)this.f_19804_.m_135370_(SWORD_INDEX);
        return slot == EquipmentSlot.MAINHAND && index >= 0 ? this.kangarooInventory.m_8020_(index) : ItemStack.f_41583_;
    }

    @Unique
    private ItemStack getItemInOffHand(EquipmentSlot slot) {
        int index = (Integer)this.f_19804_.m_135370_(TOTEM_INDEX);
        return slot == EquipmentSlot.OFFHAND && index >= 0 ? this.kangarooInventory.m_8020_(index) : ItemStack.f_41583_;
    }

    static {
        TOTEM_INDEX = SynchedEntityData.m_135353_(EntityKangaroo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }
}

