/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.crimsoncrips.alexsmobsinteraction.datagen.tags.AMIEntityTagGenerator;
import com.crimsoncrips.alexsmobsinteraction.misc.AMIUtils;
import com.crimsoncrips.alexsmobsinteraction.misc.interfaces.TransformingEntities;
import com.crimsoncrips.alexsmobsinteraction.server.effect.AMIEffects;
import com.crimsoncrips.alexsmobsinteraction.server.goal.AMIAvoidBlockGoal;
import com.crimsoncrips.alexsmobsinteraction.server.goal.AMIFollowNearestGoal;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCrimsonMosquito;
import com.github.alexthe666.alexsmobs.entity.EntityFly;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityFly.class})
public class AMIFly
extends Mob
implements TransformingEntities {
    private static final EntityDataAccessor<Boolean> TRANFORMING = SynchedEntityData.m_135353_(EntityFly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int flyConvert;

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(TRANFORMING, (Object)false);
    }

    protected AMIFly(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")})
    private void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemstack = player.m_21120_(hand);
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.FLY_TRANSFORM_ENABLED.get()).booleanValue() && itemstack.m_41720_() == AMItemRegistry.BLOOD_SAC.get() && this.m_21023_((MobEffect)AMIEffects.BLOODED.get())) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_146850_(GameEvent.f_223708_);
            this.m_146850_(GameEvent.f_157806_);
            this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
            this.setTransforming(true);
            AMIUtils.awardAdvancement((Entity)player, "fly_transform", "fly");
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void Test(CallbackInfo ci) {
        if (this.isTransforming()) {
            LivingEntity entityToSpawn;
            ++this.flyConvert;
            if (this.flyConvert > 160 && !this.m_9236_().f_46443_ && (entityToSpawn = (LivingEntity)((EntityType)AMEntityRegistry.CRIMSON_MOSQUITO.get()).m_262496_((ServerLevel)this.m_9236_(), BlockPos.m_274446_((Position)this.m_20318_(1.0f)), MobSpawnType.MOB_SUMMONED)) instanceof EntityCrimsonMosquito) {
                EntityCrimsonMosquito crimsonMosquito = (EntityCrimsonMosquito)entityToSpawn;
                crimsonMosquito.onSpawnFromFly();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void registerGoals(CallbackInfo ci) {
        EntityFly fly = (EntityFly)this;
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.CANDLE_REPEL_ENABLED.get()).booleanValue()) {
            fly.f_21345_.m_25352_(3, (Goal)new AMIAvoidBlockGoal((PathfinderMob)fly, 4.0f, 1.8, 2.3, pos -> {
                BlockState state = fly.m_9236_().m_8055_(pos);
                if (state.m_204336_(BlockTags.f_144265_)) {
                    return (Boolean)state.m_61143_((Property)CandleBlock.f_152791_);
                }
                return false;
            }));
        }
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.FLY_PESTER_ENABLED.get()).booleanValue()) {
            fly.f_21345_.m_25352_(8, new AMIFollowNearestGoal<LivingEntity>((PathfinderMob)fly, LivingEntity.class, 1.0f, 0.8, AMEntityRegistry.buildPredicateFromTag(AMIEntityTagGenerator.FLY_PESTER)));
        }
    }

    @Override
    public boolean isTransforming() {
        return (Boolean)this.f_19804_.m_135370_(TRANFORMING);
    }

    @Override
    public void setTransforming(boolean transformingBoolean) {
        this.f_19804_.m_135381_(TRANFORMING, (Object)transformingBoolean);
    }
}

