/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.item.loader;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import snownee.kiwi.util.codec.CustomizationCodecs;
import snownee.kiwi.util.codec.JavaOps;

public record ItemDefinitionProperties(Optional<ResourceLocation> colorProvider, PartialVanillaProperties vanillaProperties) {
    private static final ItemDefinitionProperties EMPTY;

    public static MapCodec<ItemDefinitionProperties> mapCodec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.strictOptionalField(ResourceLocation.f_135803_, "color_provider").forGetter(ItemDefinitionProperties::colorProvider), (App)PartialVanillaProperties.MAP_CODEC.forGetter(ItemDefinitionProperties::vanillaProperties)).apply((Applicative)instance, ItemDefinitionProperties::new));
    }

    public static MapCodec<Optional<ItemDefinitionProperties>> mapCodecField() {
        return ItemDefinitionProperties.mapCodec().codec().optionalFieldOf("properties");
    }

    public static ItemDefinitionProperties empty() {
        return EMPTY;
    }

    public ItemDefinitionProperties merge(ItemDefinitionProperties templateProps) {
        return new ItemDefinitionProperties(ItemDefinitionProperties.or(this.colorProvider, templateProps.colorProvider), this.vanillaProperties.merge(templateProps.vanillaProperties));
    }

    private static <T> Optional<T> or(Optional<T> a, Optional<T> b) {
        return a.isPresent() ? a : b;
    }

    static {
        PartialVanillaProperties vanillaProperties = (PartialVanillaProperties)PartialVanillaProperties.MAP_CODEC.codec().parse((DynamicOps)JavaOps.INSTANCE, Map.of()).getOrThrow(false, e -> {
            throw new IllegalStateException("Failed to parse empty ItemDefinitionProperties: " + e);
        });
        EMPTY = new ItemDefinitionProperties(Optional.empty(), vanillaProperties);
    }

    public record PartialVanillaProperties(Optional<Integer> maxStackSize, Optional<Integer> maxDamage, Optional<ResourceKey<Item>> craftingRemainingItem, Optional<FoodProperties> food, Optional<Rarity> rarity) {
        public static final MapCodec<PartialVanillaProperties> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)64).optionalFieldOf("stacks_to").forGetter(PartialVanillaProperties::maxStackSize), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("max_damage").forGetter(PartialVanillaProperties::maxDamage), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256913_).optionalFieldOf("crafting_remaining_item").forGetter(PartialVanillaProperties::craftingRemainingItem), (App)CustomizationCodecs.FOOD.optionalFieldOf("food").forGetter(PartialVanillaProperties::food), (App)CustomizationCodecs.RARITY_CODEC.optionalFieldOf("rarity").forGetter(PartialVanillaProperties::rarity)).apply((Applicative)instance, PartialVanillaProperties::new));

        public PartialVanillaProperties merge(PartialVanillaProperties templateProps) {
            return new PartialVanillaProperties(ItemDefinitionProperties.or(this.maxStackSize, templateProps.maxStackSize), ItemDefinitionProperties.or(this.maxDamage, templateProps.maxDamage), ItemDefinitionProperties.or(this.craftingRemainingItem, templateProps.craftingRemainingItem), ItemDefinitionProperties.or(this.food, templateProps.food), ItemDefinitionProperties.or(this.rarity, templateProps.rarity));
        }
    }
}

