/*
 * Decompiled with CFR 0.152.
 */
package smartin.armory;

import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.GeneratedMaterial;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.properties.ItemIdProperty;
import smartin.miapi.registries.RegistryInventory;

public class GenerateArmorModularConverter {
    public Map<Item, Converter> modularItem = new HashMap<Item, Converter>();
    public Map<ArmorMaterial, List<ArmorItem>> armorItems = new HashMap<ArmorMaterial, List<ArmorItem>>();

    public GenerateArmorModularConverter() {
        ReloadEvents.START.subscribe(isClient -> {
            this.modularItem.clear();
            this.armorItems.clear();
            BuiltInRegistries.f_257033_.m_123024_().filter(ArmorItem.class::isInstance).forEach(item -> {
                ArmorItem armorItem;
                if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40401_() != null && armorItem.m_266204_() != null && armorItem.m_40401_().m_6230_() != null) {
                    List armorItems1 = this.armorItems.getOrDefault(armorItem.m_40401_(), new ArrayList());
                    armorItems1.add(armorItem);
                    this.armorItems.put(armorItem.m_40401_(), armorItems1);
                }
            });
        });
        ModularItemStackConverter.converters.add(stack -> {
            if (this.modularItem.containsKey(stack.m_41720_())) {
                return ItemIdProperty.changeId((ItemStack)this.modularItem.get(stack.m_41720_()).convert(stack));
            }
            return stack;
        });
        MiapiEvents.GENERATED_MATERIAL.register((material, mainIngredient, tools, isClient) -> {
            this.setupArmor((Material)material);
            if (GeneratedMaterial.verboseLogging()) {
                Miapi.LOGGER.info("generating armor materials for " + material.getKey());
            }
            return EventResult.pass();
        });
        MiapiEvents.GENERATE_MATERIAL_CONVERTERS.register((material, tools, isClient) -> {
            if (GeneratedMaterial.verboseLogging()) {
                // empty if block
            }
            return EventResult.pass();
        });
    }

    private void setupArmor(Material material) {
        this.armorItems.keySet().stream().filter(armor -> armor.m_6230_().m_43908_() != null).filter(armor -> armor.m_6230_().m_43908_().length > 0).filter(armor -> armor.m_6230_().m_43908_()[0] != null).filter(armor -> material.getValueOfItem(armor.m_6230_().m_43908_()[0]) > 0.0).forEach(armorGroup -> {
            try {
                List<ArmorItem> materialArmorItems = this.armorItems.get(armorGroup);
                if (GeneratedMaterial.verboseLogging()) {
                    Miapi.LOGGER.info("valid armor material with " + materialArmorItems + " items");
                }
                Optional<ArmorItem> helmetItem = materialArmorItems.stream().filter(item -> item.m_266204_().equals((Object)ArmorItem.Type.HELMET)).findFirst();
                Optional<ArmorItem> chestPlateItem = materialArmorItems.stream().filter(item -> item.m_266204_().equals((Object)ArmorItem.Type.CHESTPLATE)).findFirst();
                Optional<ArmorItem> leggingsItem = materialArmorItems.stream().filter(item -> item.m_266204_().equals((Object)ArmorItem.Type.LEGGINGS)).findFirst();
                Optional<ArmorItem> shoeItem = materialArmorItems.stream().filter(item -> item.m_266204_().equals((Object)ArmorItem.Type.BOOTS)).findFirst();
                helmetItem.ifPresent(item -> this.addHelmetItem(material, (Item)item));
                chestPlateItem.ifPresent(item -> this.addChestPlateItem(material, (Item)item));
                leggingsItem.ifPresent(item -> this.addLeggingsItem(material, (Item)item));
                shoeItem.ifPresent(item -> this.addShoesItem(material, (Item)item));
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Exception during armor converter creation");
            }
        });
    }

    protected void addHelmetItem(Material material, Item item) {
        this.modularItem.put(item, stack -> {
            ItemStack modularItem = new ItemStack((ItemLike)RegistryInventory.modularItem);
            String swordData = "{\n        \"module\": \"helmet_base\",\n        \"subModules\": {\n            \"0\": {\n                \"module\": \"helmet_plate\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                }\n            }\n        }\n    }";
            swordData = swordData.replaceAll("gold", material.getKey());
            modularItem.m_41784_().m_128391_(stack.m_41784_());
            ItemModule.ModuleInstance moduleInstance = ItemModule.ModuleInstance.fromString((String)swordData);
            moduleInstance.getRoot().writeToItem(modularItem);
            return modularItem;
        });
    }

    protected void addChestPlateItem(Material material, Item item) {
        this.modularItem.put(item, stack -> {
            ItemStack modularItem = new ItemStack((ItemLike)RegistryInventory.modularItem);
            String swordData = "{\n        \"module\": \"chest_base\",\n        \"subModules\": {\n            \"0\": {\n                \"module\": \"front_chestplate\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {}\n            },\n            \"1\": {\n                \"module\": \"back_chestplate\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {}\n            },\n            \"2\": {\n                \"module\": \"arm_left\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {}\n            },\n            \"3\": {\n                \"module\": \"arm_right\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {}\n            }\n        }\n    }";
            swordData = swordData.replaceAll("gold", material.getKey());
            modularItem.m_41784_().m_128391_(stack.m_41784_());
            ItemModule.ModuleInstance moduleInstance = ItemModule.ModuleInstance.fromString((String)swordData);
            moduleInstance.getRoot().writeToItem(modularItem);
            return modularItem;
        });
    }

    protected void addLeggingsItem(Material material, Item item) {
        this.modularItem.put(item, stack -> {
            ItemStack modularItem = new ItemStack((ItemLike)RegistryInventory.modularItem);
            String swordData = "{\n        \"module\": \"pants_base\",\n        \"subModules\": {\n            \"0\": {\n                \"module\": \"belt_base\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {}\n            },\n            \"1\": {\n                \"module\": \"leg_left\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {}\n            },\n            \"2\": {\n                \"module\": \"leg_right\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {}\n            }\n        }\n    }";
            swordData = swordData.replaceAll("gold", material.getKey());
            modularItem.m_41784_().m_128391_(stack.m_41784_());
            ItemModule.ModuleInstance moduleInstance = ItemModule.ModuleInstance.fromString((String)swordData);
            moduleInstance.getRoot().writeToItem(modularItem);
            return modularItem;
        });
    }

    protected void addShoesItem(Material material, Item item) {
        this.modularItem.put(item, stack -> {
            ItemStack modularItem = new ItemStack((ItemLike)RegistryInventory.modularItem);
            String swordData = "{\n        \"module\": \"boot_base\",\n        \"subModules\": {\n            \"0\": {\n                \"module\": \"boot_left\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {}\n            },\n            \"1\": {\n                \"module\": \"boot_right\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {}\n            }\n        }\n    }";
            swordData = swordData.replaceAll("gold", material.getKey());
            modularItem.m_41784_().m_128391_(stack.m_41784_());
            ItemModule.ModuleInstance moduleInstance = ItemModule.ModuleInstance.fromString((String)swordData);
            moduleInstance.getRoot().writeToItem(modularItem);
            return modularItem;
        });
    }

    static interface Converter {
        public ItemStack convert(ItemStack var1);
    }
}

