/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.overlay.weapon_overlay;

import com.gametechbc.traveloptics.data_manager.PlasmaCoreManager;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.item.bossweapon.mechanized_wraithblade.MechanizedWraithbladeItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class MechanizedWraithbladeOverlay {
    private static final ResourceLocation WEAPON_SILHOUETTE = new ResourceLocation("traveloptics", "textures/gui/weapon/mechanized_wraithblade_silhouette.png");
    private static final int HUD_WIDTH = 200;
    private static final int HUD_HEIGHT = 70;
    private static final int MARGIN = 20;

    public static void render(GuiGraphics guiGraphics, Player player, int screenWidth, int screenHeight) {
        if (player == null) {
            return;
        }
        ItemStack mainHand = player.m_21205_();
        if (!MechanizedWraithbladeOverlay.isMechanizedWraithblade(mainHand)) {
            return;
        }
        int currentPlasma = PlasmaCoreManager.getPlasmaCore(mainHand);
        int maxPlasma = 250;
        float currentDamage = MechanizedWraithbladeItem.getLaserBaseDamage(mainHand);
        int startX = screenWidth - 200 - 20;
        int startY = screenHeight - 70 - 20;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        MechanizedWraithbladeOverlay.renderTacticalHUD(guiGraphics, startX, startY, currentPlasma, maxPlasma, currentDamage);
        poseStack.m_85849_();
    }

    private static boolean isMechanizedWraithblade(ItemStack stack) {
        return stack.m_150930_((Item)TravelopticsItems.MECHANIZED_WRAITHBLADE.get()) || stack.m_150930_((Item)TravelopticsItems.MECHANIZED_WRAITHBLADE_LEVEL_ONE.get()) || stack.m_150930_((Item)TravelopticsItems.MECHANIZED_WRAITHBLADE_LEVEL_TWO.get()) || stack.m_150930_((Item)TravelopticsItems.MECHANIZED_WRAITHBLADE_LEVEL_THREE.get());
    }

    private static void renderTacticalHUD(GuiGraphics guiGraphics, int x, int y, int plasma, int maxPlasma, float damage) {
        MechanizedWraithbladeOverlay.renderFrame(guiGraphics, x, y, 200, 70, plasma, maxPlasma);
        MechanizedWraithbladeOverlay.renderPlasmaBar(guiGraphics, x + 8, y + 25, 120, plasma, maxPlasma);
        MechanizedWraithbladeOverlay.renderChargingIndicator(guiGraphics, x + 8, y + 35, 120);
        MechanizedWraithbladeOverlay.renderLabels(guiGraphics, x, y, plasma, maxPlasma, damage);
        MechanizedWraithbladeOverlay.renderWeaponSilhouette(guiGraphics, x + 200 - 72, y + 42);
    }

    private static void renderFrame(GuiGraphics guiGraphics, int x, int y, int width, int height, int plasma, int maxPlasma) {
        float plasmaRatio = (float)plasma / (float)maxPlasma;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        int frameTop = MechanizedWraithbladeOverlay.lerpColor(-268435456, -14407630, plasmaRatio * 0.3f);
        int frameBottom = MechanizedWraithbladeOverlay.lerpColor(-535159260, -14011846, plasmaRatio * 0.3f);
        MechanizedWraithbladeOverlay.addVerticalGradientQuad(buffer, matrix, x, y, x + width, y + height, frameTop, frameBottom);
        MechanizedWraithbladeOverlay.addVerticalGradientQuad(buffer, matrix, x + 1, y + 1, x + width - 1, y + height - 1, -401599978, -802936784);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        int borderColor = MechanizedWraithbladeOverlay.getPlasmaBorderColor(plasmaRatio);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x, y, x + width, y + 1, borderColor);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x, y + height - 1, x + width, y + height, borderColor);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x, y, x + 1, y + height, borderColor);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x + width - 1, y, x + width, y + height, borderColor);
        int accentColor = MechanizedWraithbladeOverlay.lerpColor(-1557701, -300259, plasmaRatio);
        int cornerSize = 6;
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x, y, x + cornerSize, y + 1, accentColor);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x, y, x + 1, y + cornerSize, accentColor);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x + width - cornerSize, y, x + width, y + 1, accentColor);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x + width - 1, y, x + width, y + cornerSize, accentColor);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
    }

    private static void renderPlasmaBar(GuiGraphics guiGraphics, int x, int y, int width, int plasma, int maxPlasma) {
        int barHeight = 6;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x, y, x + width, y + barHeight, -15065564);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x + 1, y + 1, x + width - 1, y + barHeight - 1, -16777216);
        if (plasma > 0) {
            float fillRatio = (float)plasma / (float)maxPlasma;
            int fillWidth = (int)((float)(width - 2) * fillRatio);
            int fillColor = MechanizedWraithbladeOverlay.getPlasmaBarColor(fillRatio);
            MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x + 1, y + 1, x + 1 + fillWidth, y + barHeight - 1, fillColor);
            MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x + 1, y + 1, x + 1 + fillWidth, y + 2, MechanizedWraithbladeOverlay.addAlpha(fillColor, 0.8f));
            if (fillWidth > 3) {
                int edgeGlow = MechanizedWraithbladeOverlay.lerpColor(fillColor, -1, 0.6f);
                MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x + fillWidth - 1, y + 1, x + fillWidth + 1, y + barHeight - 1, edgeGlow);
            }
            if (plasma < 20 && plasma > 0 && System.currentTimeMillis() / 400L % 2L == 0L) {
                MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x, y, x + width, y + barHeight, 1085154100);
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
    }

    private static void renderChargingIndicator(GuiGraphics guiGraphics, int x, int y, int width) {
        int barHeight = 3;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x, y, x + width, y + barHeight, -15065564);
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x + 1, y + 1, x + width - 1, y + barHeight - 1, -16777216);
        int readyColor = -11919585;
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x + 1, y + 1, x + width - 1, y + barHeight - 1, readyColor);
        long time = System.currentTimeMillis();
        float pulse = 0.15f + 0.08f * (float)Math.sin((double)time * 0.006);
        int borderGlow = (int)(pulse * 255.0f) << 24 | 0xE83B3B;
        MechanizedWraithbladeOverlay.addColoredQuad(buffer, matrix, x - 1, y - 1, x + width + 1, y + barHeight + 1, borderGlow);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
    }

    private static void renderLabels(GuiGraphics guiGraphics, int x, int y, int plasma, int maxPlasma, float damage) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        guiGraphics.m_280056_(font, "\u26a1 PLASMA", x + 12, y + 8, -4473925, true);
        String count = String.format("%d/%d", plasma, maxPlasma);
        int countColor = MechanizedWraithbladeOverlay.getPlasmaColor((float)plasma / (float)maxPlasma);
        int countWidth = font.m_92895_(count);
        guiGraphics.m_280056_(font, count, x + 200 - 8 - countWidth, y + 8, countColor, true);
        String damageText = String.format("DMG: %.1f", Float.valueOf(damage));
        int damageColor = MechanizedWraithbladeOverlay.getDamageColor(damage);
        guiGraphics.m_280056_(font, damageText, x + 8, y + 48, damageColor, true);
    }

    private static void renderWeaponSilhouette(GuiGraphics guiGraphics, int x, int y) {
        try {
            guiGraphics.m_280163_(WEAPON_SILHOUETTE, x, y, 0.0f, 0.0f, 64, 23, 64, 23);
        }
        catch (Exception e) {
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, "\ud83d\udd2b", x, y, -1557701, true);
        }
    }

    private static void addColoredQuad(BufferBuilder buffer, Matrix4f matrix, int x1, int y1, int x2, int y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        buffer.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
    }

    private static void addVerticalGradientQuad(BufferBuilder buffer, Matrix4f matrix, int x1, int y1, int x2, int y2, int colorTop, int colorBottom) {
        float aTop = (float)(colorTop >> 24 & 0xFF) / 255.0f;
        float rTop = (float)(colorTop >> 16 & 0xFF) / 255.0f;
        float gTop = (float)(colorTop >> 8 & 0xFF) / 255.0f;
        float bTop = (float)(colorTop & 0xFF) / 255.0f;
        float aBottom = (float)(colorBottom >> 24 & 0xFF) / 255.0f;
        float rBottom = (float)(colorBottom >> 16 & 0xFF) / 255.0f;
        float gBottom = (float)(colorBottom >> 8 & 0xFF) / 255.0f;
        float bBottom = (float)(colorBottom & 0xFF) / 255.0f;
        buffer.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(rTop, gTop, bTop, aTop).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_85950_(rBottom, gBottom, bBottom, aBottom).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(rBottom, gBottom, bBottom, aBottom).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_85950_(rTop, gTop, bTop, aTop).m_5752_();
    }

    private static int lerpColor(int color1, int color2, float ratio) {
        ratio = Math.max(0.0f, Math.min(1.0f, ratio));
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * ratio);
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int addAlpha(int color, float alpha) {
        int a = (int)(alpha * 255.0f) << 24;
        return a | color & 0xFFFFFF;
    }

    private static int getPlasmaBorderColor(float ratio) {
        if (ratio >= 1.0f) {
            return -300259;
        }
        if (ratio > 0.7f) {
            return -1557701;
        }
        return -5364940;
    }

    private static int getPlasmaBarColor(float ratio) {
        if (ratio >= 1.0f) {
            return -300259;
        }
        if (ratio > 0.6f) {
            return -1557701;
        }
        if (ratio > 0.2f) {
            return -39373;
        }
        return -5364940;
    }

    private static int getPlasmaColor(float ratio) {
        if (ratio >= 1.0f) {
            return -300259;
        }
        if (ratio > 0.6f) {
            return -1557701;
        }
        if (ratio > 0.2f) {
            return -300259;
        }
        return -5364940;
    }

    private static int getDamageColor(float damage) {
        if (damage >= 14.0f) {
            return -300259;
        }
        if (damage >= 12.0f) {
            return -1557701;
        }
        if (damage >= 10.0f) {
            return -5364940;
        }
        return -3355444;
    }
}

