/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.overlay.armor_overlay;

import com.gametechbc.traveloptics.api.utils.TOArmorUtils;
import com.gametechbc.traveloptics.config.ClientConfig;
import com.gametechbc.traveloptics.data_manager.StormlineManager;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.item.armor.RiptideSovereignArmorItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RiptideSovereignOverlay {
    private static final ResourceLocation RIPTIDE_SOVEREIGN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"traveloptics", (String)"textures/gui/armor/riptide_sovereign_bar.png");
    private static final boolean USE_XP_BAR = (Boolean)ClientConfig.armorReplaceXPBars.get();
    private static long lastProgressTime = 0L;
    private static boolean shouldRenderBar = true;
    private static double lastRecordedProgress = -1.0;
    private static int lastRecordedRank = -1;
    private static final int BASE_WIDTH = 132;
    private static final int BASE_HEIGHT = 17;
    private static final float BAR_SCALE = 1.0f;
    private static final int BAR_X_OFFSET = 0;
    private static final int BAR_Y_OFFSET = 95;
    private static final float BAR_ROTATION = 0.0f;
    private static final int RANK_TEXT_Y_OFFSET = -12;
    private static final int RANK_TEXT_X_OFFSET = 0;
    private static final int RANK_TEXT_COLOR = 9678591;
    private static final int BASE_BAR_U = 53;
    private static final int BASE_BAR_V = 21;
    private static final int FILL_BAR_U = 53;
    private static final int FILL_BAR_V = 50;
    private static final int XP_BAR_WIDTH = 182;
    private static final int XP_BAR_HEIGHT = 5;
    private static final int XP_BAR_U = 29;
    private static final int XP_BAR_V = 89;
    private static final int XP_FILL_U = 29;
    private static final int XP_FILL_V = 99;
    private static final int XP_BAR_X_OFFSET = 0;
    private static final int XP_BAR_Y_OFFSET = 9;

    public static void render(GuiGraphics guiGraphics, Player player, int screenWidth, int screenHeight) {
        boolean rankChanged;
        double fillProgress;
        if (player == null) {
            return;
        }
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (!TOArmorUtils.isWearingFullSet(player, RiptideSovereignArmorItem.class)) {
            return;
        }
        int[] progress = StormlineManager.getRankProgress(chestplate);
        int currentProgress = progress[0];
        int requiredForNext = progress[1];
        int rank = StormlineManager.getCurrentRank(chestplate);
        String rankName = StormlineManager.getRankName(chestplate);
        double d = fillProgress = requiredForNext > 0 ? (double)currentProgress / (double)requiredForNext : 0.0;
        if (rank == 5) {
            fillProgress = 1.0;
        }
        boolean progressChanged = fillProgress != lastRecordedProgress;
        boolean bl = rankChanged = rank != lastRecordedRank;
        if (!progressChanged && !rankChanged) {
            if (lastProgressTime == 0L) {
                lastProgressTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - lastProgressTime >= 5000L) {
                shouldRenderBar = false;
            }
        } else {
            lastProgressTime = 0L;
            shouldRenderBar = true;
        }
        lastRecordedProgress = fillProgress;
        lastRecordedRank = rank;
        if (!shouldRenderBar) {
            return;
        }
        if (USE_XP_BAR) {
            int x = screenWidth / 2 - 91 + 0;
            int y = screenHeight - 32 + 3 - 8 + 9;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            guiGraphics.m_280163_(RIPTIDE_SOVEREIGN_TEXTURE, x, y, 29.0f, 89.0f, 182, 5, 241, 115);
            int fillWidth = (int)(182.0 * fillProgress);
            if (fillWidth > 0) {
                guiGraphics.m_280163_(RIPTIDE_SOVEREIGN_TEXTURE, x, y, 29.0f, 99.0f, fillWidth, 5, 241, 115);
            }
            poseStack.m_85849_();
            RiptideSovereignOverlay.renderRankText(guiGraphics, rankName, x + 91, y - 10);
        } else {
            int barWidth = 132;
            int barHeight = 17;
            int x = (screenWidth - barWidth) / 2 + 0;
            int y = screenHeight - 95;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)x + (double)barWidth / 2.0, (double)y + (double)barHeight / 2.0, 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(0.0f));
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            poseStack.m_252880_((float)(-barWidth) / 2.0f, (float)(-barHeight) / 2.0f, 0.0f);
            guiGraphics.m_280163_(RIPTIDE_SOVEREIGN_TEXTURE, 0, 0, 53.0f, 21.0f, 132, 17, 241, 115);
            int fillWidth = (int)(132.0 * fillProgress);
            if (fillWidth > 0) {
                guiGraphics.m_280163_(RIPTIDE_SOVEREIGN_TEXTURE, 0, 0, 53.0f, 50.0f, fillWidth, 17, 241, 115);
            }
            poseStack.m_85849_();
            int textX = x + barWidth / 2 + 0;
            int textY = y + -12;
            RiptideSovereignOverlay.renderRankText(guiGraphics, rankName, textX, textY);
        }
    }

    private static void renderRankText(GuiGraphics guiGraphics, String rankName, int centerX, int y) {
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent rankText = Component.m_237113_((String)rankName);
        int textWidth = font.m_92852_((FormattedText)rankText);
        int x = centerX - textWidth / 2;
        guiGraphics.m_280614_(font, (Component)rankText, x, y, 9678591, true);
    }

    public static boolean shouldCancelXpBar(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (chestplate.m_41619_() || chestplate.m_41720_() != TravelopticsItems.RIPTIDE_SOVEREIGN_ARMOR_FINCLOAK.get()) {
            return false;
        }
        return USE_XP_BAR && shouldRenderBar;
    }
}

