/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.network;

import com.gametechbc.traveloptics.api.boss_screen.IBossTriggerFromScreenEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class StartBossBattlePacket {
    private final int entityId;
    private final int difficulty;

    public StartBossBattlePacket(int entityId, int difficulty) {
        this.entityId = entityId;
        this.difficulty = difficulty;
    }

    public StartBossBattlePacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.difficulty = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.difficulty);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && player.m_9236_() != null && (entity = player.m_9236_().m_6815_(this.entityId)) instanceof IBossTriggerFromScreenEntity) {
                IBossTriggerFromScreenEntity bossTrigger = (IBossTriggerFromScreenEntity)entity;
                bossTrigger.onBattleTrigger(player, this.difficulty);
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

