/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.bossweapon.cursedwraithblade;

import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.config.WeaponConfig;
import com.gametechbc.traveloptics.data_manager.SoulApexManager;
import com.gametechbc.traveloptics.data_manager.SpiritPointsManager;
import com.gametechbc.traveloptics.data_manager.SwingCounterManager;
import com.gametechbc.traveloptics.entity.item.cursed_wraithblade.CursedWraithbladeItemRenderer;
import com.gametechbc.traveloptics.entity.misc.TOScreenShakeEntity;
import com.gametechbc.traveloptics.entity.misc.soul_apex.SoulApexEntity;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.item.UnbreakableGeoMagicSword;
import com.gametechbc.traveloptics.util.TravelopticsParticleHelper;
import com.github.L_Ender.cataclysm.client.particle.CircleLightningParticle;
import com.github.L_Ender.cataclysm.client.particle.LightningParticle;
import com.github.L_Ender.cataclysm.init.ModParticle;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.ISSDamageTypes;
import io.redspace.ironsspellbooks.item.UniqueItem;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CursedWraithbladeItem
extends UnbreakableGeoMagicSword
implements UniqueItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static ItemDisplayContext transformType;
    private static final RawAnimation CHARGE_ANIMATION;
    private static final RawAnimation CHARGE_LONG_ANIMATION;
    private static final RawAnimation SHOOT_ANIMATION;
    private DamageSource damageSource;
    protected static final int CHARGE_TIME = 30;
    protected static final float SOUL_CONVERSION_RATE = 0.75f;
    protected static final int MIN_SPIRIT_POINTS_FOR_SOUL_APEX = 50;
    protected static final int COOLDOWN_RELEASE_EARLY = 60;
    protected static final int COOLDOWN_TOTAL_SHOT = 80;
    protected static final int COOLDOWN_APEX_SHOT = 60;

    public CursedWraithbladeItem(SpellDataRegistryHolder[] imbuedSpells) {
        super(new Tier(){

            public int m_6609_() {
                return (Integer)WeaponConfig.cursedWraithbladeDurability.get();
            }

            public float m_6624_() {
                return 2.0f;
            }

            public float m_6631_() {
                return 0.0f;
            }

            public int m_6604_() {
                return 1;
            }

            public int m_6601_() {
                return 20;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TravelopticsItems.PYRO_SPELLWEAVE_INGOT.get())});
            }
        }, 17.0 * (Double)WeaponConfig.cursedWraithbladeDamageMultiplier.get(), -2.7 * (Double)WeaponConfig.cursedWraithbladeAttackSpeedMultiplier.get(), imbuedSpells, Map.of((Attribute)AttributeRegistry.ICE_SPELL_POWER.get(), new AttributeModifier(UUID.fromString("412b5a66-2b43-4c18-ab05-6de0bb4d64d3"), "Weapon Modifier", 0.15 * (Double)WeaponConfig.cursedWraithbladeIceSpellPowerMultiplier.get(), AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.ELDRITCH_SPELL_POWER.get(), new AttributeModifier(UUID.fromString("412b5a66-2b43-4c18-ab05-6de0bb4d64d3"), "Weapon Modifier", 0.05 * (Double)WeaponConfig.cursedWraithbladeEldritchSpellPowerMultiplier.get(), AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier(UUID.fromString("412b5a66-2b43-4c18-ab05-6de0bb4d64d3"), "Weapon Modifier", 0.15 * (Double)WeaponConfig.cursedWraithbladeMaxManaMultiplier.get(), AttributeModifier.Operation.MULTIPLY_BASE)), ItemPropertiesHelper.hidden((int)1).m_41497_(TravelopticsItems.RARITY_CURSED));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            int swingCounter = SwingCounterManager.getSwingCount(stack);
            int pointsToAdd = this.calculateSpiritPointsGain(swingCounter);
            SpiritPointsManager.addSpiritPoints(stack, player, pointsToAdd);
            SwingCounterManager.incrementSwingCount(stack, 3);
            MagicManager.spawnParticles((Level)target.m_9236_(), (ParticleOptions)ParticleTypes.f_235898_, (double)target.m_20185_(), (double)target.m_20186_(), (double)target.m_20189_(), (int)30, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            ItemStack stack = player.m_21120_(hand);
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        int chargeDuration;
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_7655_() == InteractionHand.MAIN_HAND && (chargeDuration = this.m_8105_(stack) - timeLeft) >= 5 && !world.f_46443_) {
            player.m_36335_().m_41524_((Item)this, 60);
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        int soulApexCount = SoulApexManager.getSoulApexCount(stack);
        if (soulApexCount > 0) {
            return 21;
        }
        return 31;
    }

    public void m_5929_(Level level, LivingEntity caster, ItemStack stack, int count) {
        Player player;
        if (caster instanceof Player && (player = (Player)caster).m_7655_() == InteractionHand.MAIN_HAND) {
            int maxChargeTime;
            int chargeTime = this.m_8105_(stack) - count;
            ItemStack mainHand = player.m_21205_();
            int soulApexCount = SoulApexManager.getSoulApexCount(stack);
            boolean usingSoulApex = soulApexCount > 0;
            int n = maxChargeTime = usingSoulApex ? 20 : 30;
            if (chargeTime == 2) {
                caster.m_5496_((SoundEvent)TravelopticsSounds.CURSED_BLAST_CHARGE.get(), 1.0f, 1.0f);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    String animName = usingSoulApex ? "charge" : "charge_long";
                    this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)mainHand, (ServerLevel)serverLevel), "wraithblade", animName);
                }
            }
            if (count % 3 == 0 && chargeTime >= 2 && chargeTime < maxChargeTime && !level.f_46443_) {
                Vec3 lookVec = player.m_20252_(1.0f).m_82541_();
                Vec3 upVec = new Vec3(0.0, 1.0, 0.0);
                Vec3 rightVec = lookVec.m_82537_(upVec).m_82541_().m_82490_(0.22);
                Vec3 particleSpawnPos = player.m_146892_().m_82549_(lookVec.m_82490_(0.6)).m_82549_(rightVec);
                MagicManager.spawnParticles((Level)level, (ParticleOptions)new LightningParticle.OrbData(32, 181, 149), (double)particleSpawnPos.f_82479_, (double)particleSpawnPos.f_82480_, (double)particleSpawnPos.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.2, (boolean)false);
            }
            if (chargeTime == maxChargeTime) {
                this.executeCursedBlast(level, player, mainHand);
            }
        }
    }

    protected void executeCursedBlast(Level level, Player player, ItemStack stack) {
        Entity target;
        HitResult hitResult;
        if (level.f_46443_) {
            return;
        }
        int soulApexCount = SoulApexManager.getSoulApexCount(stack);
        int spiritPoints = SpiritPointsManager.getSpiritPoints(stack);
        boolean usingSoulApex = soulApexCount > 0;
        float scaledDamage = usingSoulApex ? this.getSoulApexDamage(player) : CursedWraithbladeItem.getBaseDamage() + (float)spiritPoints * this.getSoulConversionRate(player);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "wraithblade", "shoot");
        }
        if ((hitResult = Utils.raycastForEntity((Level)level, (Entity)player, (float)CursedWraithbladeItem.getRange(), (boolean)true, (float)0.15f)).m_6662_() == HitResult.Type.ENTITY && (target = ((EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            boolean damaged;
            LivingEntity livingTarget = (LivingEntity)target;
            if (this.damageSource == null) {
                this.damageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)livingTarget, (ResourceKey)ISSDamageTypes.LIGHTNING_MAGIC), null, (Entity)player);
            }
            if ((damaged = livingTarget.m_6469_(this.damageSource, scaledDamage)) && usingSoulApex) {
                this.spawnSoulApexLightningExplosion(level, livingTarget, 16);
            }
            if (damaged && !usingSoulApex && spiritPoints >= 50) {
                int soulApexToSpawn = spiritPoints / 50;
                for (int i = 0; i < soulApexToSpawn; ++i) {
                    Object soulApex = new SoulApexEntity(level, livingTarget.m_20185_(), livingTarget.m_20186_() + (double)livingTarget.m_20206_() * 0.5, livingTarget.m_20189_(), player, 1.0f);
                    level.m_7967_(soulApex);
                }
            }
            AABB area = new AABB(livingTarget.m_20183_()).m_82400_(3.0);
            List nearbyEntities = level.m_6443_(LivingEntity.class, area, e -> e != player && e != livingTarget);
            for (LivingEntity nearby : nearbyEntities) {
                if (this.damageSource == null) {
                    this.damageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)nearby, (ResourceKey)ISSDamageTypes.LIGHTNING_MAGIC), null, (Entity)player);
                }
                float aoeDamage = usingSoulApex ? scaledDamage : scaledDamage * 0.5f;
                nearby.m_6469_(this.damageSource, aoeDamage);
                MagicManager.spawnParticles((Level)level, (ParticleOptions)((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get()), (double)nearby.m_20185_(), (double)(nearby.m_20186_() + 1.0), (double)nearby.m_20189_(), (int)35, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
            }
            MagicManager.spawnParticles((Level)level, (ParticleOptions)((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get()), (double)hitResult.m_82450_().f_82479_, (double)(hitResult.m_82450_().f_82480_ + 1.0), (double)hitResult.m_82450_().f_82481_, (int)50, (double)0.0, (double)0.0, (double)0.0, (double)0.2, (boolean)false);
        }
        float knockbackStrength = usingSoulApex ? 0.5f : (float)spiritPoints / 100.0f * 0.5f;
        Vec3 knockbackDirection = player.m_20154_().m_82548_().m_82490_((double)knockbackStrength);
        player.m_20334_(knockbackDirection.f_82479_, 0.15, knockbackDirection.f_82481_);
        player.f_19864_ = true;
        if (usingSoulApex) {
            this.doSoulApexPostEffects((LivingEntity)player, level);
            SoulApexManager.removeSoulApex(stack, player, 1);
        } else {
            this.doPostEffects((LivingEntity)player, spiritPoints, level);
            SpiritPointsManager.setSpiritPoints(stack, 0);
            player.m_5661_((Component)Component.m_237113_((String)"\u2620 Soul Fragments: 0").m_130940_(ChatFormatting.DARK_AQUA), true);
        }
        Vec3 lookVec = player.m_20252_(1.0f).m_82541_();
        Vec3 upVec = new Vec3(0.0, 1.0, 0.0);
        Vec3 rightVec = lookVec.m_82537_(upVec).m_82541_().m_82490_(0.22);
        Vec3 nozzlePos = player.m_146892_().m_82549_(lookVec.m_82490_(0.6)).m_82549_(rightVec);
        float distance = CursedWraithbladeItem.getRange();
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            distance = (float)hitResult.m_82448_((Entity)player);
        }
        int i = 0;
        while ((float)i < distance) {
            Vec3 particlePos = lookVec.m_82490_((double)i).m_82549_(nozzlePos);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)TravelopticsParticleHelper.CURSED_BLAST, (double)particlePos.f_82479_, (double)particlePos.f_82480_, (double)particlePos.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
            ++i;
        }
        if (usingSoulApex) {
            player.m_36335_().m_41524_((Item)this, 60);
        } else {
            player.m_36335_().m_41524_((Item)this, 80);
        }
    }

    private void doSoulApexPostEffects(LivingEntity entity, Level level) {
        level.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.BLAST_STAGE_THREE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        TOScreenShakeEntity.createScreenShake(level, entity.m_20182_(), 20.0f, 0.02f, 10, 0, 10, true);
    }

    private void doPostEffects(LivingEntity entity, int spiritPoints, Level level) {
        if (spiritPoints >= 200) {
            level.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.BLAST_STAGE_THREE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            TOScreenShakeEntity.createScreenShake(level, entity.m_20182_(), 30.0f, 0.035f, 10, 0, 10, true);
        } else if (spiritPoints >= 100) {
            level.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.BLAST_STAGE_TWO.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            TOScreenShakeEntity.createScreenShake(level, entity.m_20182_(), 20.0f, 0.02f, 10, 0, 10, true);
        } else if (spiritPoints >= 0) {
            level.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.BLAST_STAGE_ONE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            TOScreenShakeEntity.createScreenShake(level, entity.m_20182_(), 15.0f, 0.015f, 10, 0, 10, true);
        }
    }

    protected void spawnSoulApexLightningExplosion(Level level, LivingEntity target, int lightningCount) {
        AABB targetBB = target.m_20191_();
        double bbWidth = targetBB.m_82362_();
        double bbHeight = targetBB.m_82376_();
        double bbDepth = targetBB.m_82385_();
        double centerX = target.m_20185_();
        double centerY = target.m_20186_() + bbHeight * 0.5;
        double centerZ = target.m_20189_();
        double explosionRadius = Math.max(bbWidth, Math.max(bbHeight, bbDepth)) * 1.8;
        for (int i = 0; i < lightningCount; ++i) {
            double theta = Math.PI * 2 * (double)i / 1.618033988749895;
            double phi = Math.acos(1.0 - 2.0 * ((double)i + 0.5) / (double)lightningCount);
            double endX = centerX + explosionRadius * Math.sin(phi) * Math.cos(theta);
            double endY = centerY + explosionRadius * Math.cos(phi);
            double endZ = centerZ + explosionRadius * Math.sin(phi) * Math.sin(theta);
            double startX = targetBB.f_82288_ + target.m_217043_().m_188500_() * bbWidth;
            double startY = targetBB.f_82289_ + target.m_217043_().m_188500_() * bbHeight;
            double startZ = targetBB.f_82290_ + target.m_217043_().m_188500_() * bbDepth;
            MagicManager.spawnParticles((Level)level, (ParticleOptions)new CircleLightningParticle.CircleData(32, 181, 149), (double)startX, (double)startY, (double)startZ, (int)0, (double)endX, (double)endY, (double)endZ, (double)1.0, (boolean)true);
        }
    }

    protected static float getRange() {
        return 30.0f;
    }

    protected static float getBaseDamage() {
        return 2.0f;
    }

    protected float getSoulConversionRate(Player player) {
        return 0.75f;
    }

    protected float getSoulApexDamage(Player player) {
        float spellPowerScaling = TOGeneralUtils.getSpellPowerScaling((LivingEntity)player, (Attribute)AttributeRegistry.SPELL_POWER.get(), (Attribute)AttributeRegistry.ICE_SPELL_POWER.get());
        return 19.0f + spellPowerScaling * 6.0f;
    }

    protected int calculateSpiritPointsGain(int swingCounter) {
        switch (swingCounter) {
            case 1: {
                return 5;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 15;
            }
        }
        return 5;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        int soulApexCount = SoulApexManager.getSoulApexCount(stack);
        boolean hasSoulApex = soulApexCount > 0;
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.soul_collector").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.soul_collector1"));
        tooltip.add((Component)Component.m_237113_((String)""));
        if (hasSoulApex) {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast").m_7220_((Component)Component.m_237113_((String)" [").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.manifestation.apex_shot").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast_apex"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast1"));
        }
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution_benefits.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.evo_one.inactive.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.evo_two.inactive.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.evo_three.inactive.tooltip"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution.stars_zero.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.shift_hold.advanced_tooltips"));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        int spiritPoints = SpiritPointsManager.getSpiritPoints(stack);
        int maxSoulApex = 5;
        int maxSpiritPoints = 200;
        tooltip.add((Component)Component.m_237110_((String)"item.traveloptics.cursed_wraithblade.tooltip.soul_resources", (Object[])new Object[]{soulApexCount, maxSoulApex, spiritPoints, maxSpiritPoints}).m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237113_((String)""));
        super.m_7373_(stack, world, tooltip, flag);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void getTransformType(ItemDisplayContext type) {
        transformType = type;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BlockEntityWithoutLevelRenderer getRenderer() {
        return new CursedWraithbladeItemRenderer();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "wraithblade", 0, state -> PlayState.STOP).triggerableAnim("charge", CHARGE_ANIMATION).triggerableAnim("charge_long", CHARGE_LONG_ANIMATION).triggerableAnim("shoot", SHOOT_ANIMATION)});
    }

    static {
        CHARGE_ANIMATION = RawAnimation.begin().thenPlay("charge");
        CHARGE_LONG_ANIMATION = RawAnimation.begin().thenPlay("charge_long");
        SHOOT_ANIMATION = RawAnimation.begin().thenPlay("shoot");
    }
}

