/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.init;

import com.gametechbc.traveloptics.network.ArmorKeyPacket;
import com.gametechbc.traveloptics.network.BossMessagePacket;
import com.gametechbc.traveloptics.network.MessageSwingArm;
import com.gametechbc.traveloptics.network.MessageUpdateBossBar;
import com.gametechbc.traveloptics.network.OpenBossScreenPacket;
import com.gametechbc.traveloptics.network.OpenLoreScreenPacket;
import com.gametechbc.traveloptics.network.SpectralBlinkActivationPacket;
import com.gametechbc.traveloptics.network.SpectralBlinkTeleportPacket;
import com.gametechbc.traveloptics.network.StartBossBattlePacket;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class TravelopticsMessages {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("traveloptics", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(ArmorKeyPacket.class, TravelopticsMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ArmorKeyPacket::new).encoder(ArmorKeyPacket::toBytes).consumerMainThread(ArmorKeyPacket::handle).add();
        net.messageBuilder(MessageSwingArm.class, TravelopticsMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(MessageSwingArm::read).encoder(MessageSwingArm::write).consumerMainThread(MessageSwingArm.Handler::handle).add();
        net.messageBuilder(MessageUpdateBossBar.class, TravelopticsMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(MessageUpdateBossBar::read).encoder(MessageUpdateBossBar::write).consumerMainThread(MessageUpdateBossBar::handle).add();
        net.messageBuilder(BossMessagePacket.class, TravelopticsMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(BossMessagePacket::new).encoder(BossMessagePacket::toBytes).consumerMainThread(BossMessagePacket::handle).add();
        net.messageBuilder(SpectralBlinkTeleportPacket.class, TravelopticsMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(SpectralBlinkTeleportPacket::new).encoder(SpectralBlinkTeleportPacket::toBytes).consumerMainThread(SpectralBlinkTeleportPacket::handle).add();
        net.messageBuilder(SpectralBlinkActivationPacket.class, TravelopticsMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(SpectralBlinkActivationPacket::new).encoder(SpectralBlinkActivationPacket::toBytes).consumerMainThread(SpectralBlinkActivationPacket::handle).add();
        net.messageBuilder(OpenLoreScreenPacket.class, TravelopticsMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(OpenLoreScreenPacket::new).encoder(OpenLoreScreenPacket::toBytes).consumerMainThread(OpenLoreScreenPacket::handle).add();
        net.messageBuilder(OpenBossScreenPacket.class, TravelopticsMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(OpenBossScreenPacket::new).encoder(OpenBossScreenPacket::toBytes).consumerMainThread(OpenBossScreenPacket::handle).add();
        net.messageBuilder(StartBossBattlePacket.class, TravelopticsMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(StartBossBattlePacket::new).encoder(StartBossBattlePacket::toBytes).consumerMainThread(StartBossBattlePacket::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToAllPlayers(MSG message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <MSG> void sendMSGToAll(MSG message) {
        TravelopticsMessages.sendToAllPlayers(message);
    }

    public static <MSG> void sendNonLocal(MSG message, ServerPlayer player) {
        TravelopticsMessages.sendToPlayer(message, player);
    }

    public static <MSG> void sendMSGToServer(MSG message) {
        TravelopticsMessages.sendToServer(message);
    }

    public static void sendBossMessage(ServerPlayer player, Component message, int backgroundColor, int duration, boolean refresh, boolean forceIntroAnimation) {
        BossMessagePacket packet = new BossMessagePacket(message, backgroundColor, duration, refresh, forceIntroAnimation);
        TravelopticsMessages.sendToPlayer(packet, player);
    }

    public static void sendBossMessageToRange(Entity source, Component message, int backgroundColor, int duration, double radius, boolean refresh, boolean forceIntroAnimation) {
        if (source.m_9236_().f_46443_) {
            return;
        }
        source.m_9236_().m_45976_(ServerPlayer.class, source.m_20191_().m_82400_(radius)).forEach(player -> TravelopticsMessages.sendBossMessage(player, message, backgroundColor, duration, refresh, forceIntroAnimation));
    }

    public static void sendBossMessage(ServerPlayer player, Component message, int backgroundColor, int duration, boolean refresh) {
        TravelopticsMessages.sendBossMessage(player, message, backgroundColor, duration, refresh, false);
    }

    public static void sendBossMessageToRange(Entity source, Component message, int backgroundColor, int duration, double radius, boolean refresh) {
        TravelopticsMessages.sendBossMessageToRange(source, message, backgroundColor, duration, radius, refresh, false);
    }

    static {
        packetId = 0;
    }
}

