/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.render.screen;

import com.gametechbc.traveloptics.api.boss_screen.BossScreenData;
import com.gametechbc.traveloptics.api.utils.GUIColorThemeBuilder;
import com.gametechbc.traveloptics.config.ClientConfig;
import com.gametechbc.traveloptics.init.TravelopticsMessages;
import com.gametechbc.traveloptics.network.StartBossBattlePacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class BossInfoScreen
extends Screen {
    private static final boolean FORCE_GUI_SCALE_2 = (Boolean)ClientConfig.letBossScreenAutoAdjustUIScale.get();
    private final BossScreenData bossData;
    private final GUIColorThemeBuilder colors;
    private final int entityId;
    private static final int SCREEN_HEIGHT = 260;
    private static final int PADDING = 18;
    private static final int DEFAULT_BOSS_IMAGE_DISPLAY_WIDTH = 280;
    private static final int TEXT_LEFT_MARGIN = 90;
    private static final int LORE_MAX_DISPLAY_LINES = 3;
    private static final float ANIMATION_DURATION = 0.25f;
    private static final float DETAILS_OPEN_DURATION = 0.3f;
    private static final float DETAILS_CLOSE_DURATION = 0.3f;
    private float openAnimProgress = 0.0f;
    private long lastFrameTime = 0L;
    private float animationTime = 0.0f;
    private int previousGuiScale = -1;
    private static final int ITEM_POPUP_WIDTH = 220;
    private static final int ITEM_POPUP_HEIGHT = 300;
    private static final float ITEM_POPUP_ANIM_DURATION = 0.2f;
    private boolean showingDetails = false;
    private boolean detailsAnimating = false;
    private boolean detailsClosing = false;
    private float detailsAnimProgress = 0.0f;
    private boolean showingConfirmation = false;
    private boolean confirmationAnimating = false;
    private boolean confirmationClosing = false;
    private float confirmationAnimProgress = 0.0f;
    private boolean showingRewardsPanel = false;
    private boolean rewardsPanelAnimating = false;
    private boolean rewardsPanelClosing = false;
    private float rewardsPanelAnimProgress = 0.0f;
    private float scrollOffset = 0.0f;
    private float maxScroll = 0.0f;
    private int contentHeight = 0;
    private int viewportHeight = 0;
    private float loreScrollOffset = 0.0f;
    private float loreMaxScroll = 0.0f;
    private int loreContentHeight = 0;
    private int loreViewportHeight = 0;
    private float rewardsPanelScrollOffset = 0.0f;
    private float rewardsPanelMaxScroll = 0.0f;
    private int rewardsPanelContentHeight = 0;
    private int rewardsPanelViewportHeight = 0;
    private float difficultyBonusScrollOffset = 0.0f;
    private float difficultyBonusMaxScroll = 0.0f;
    private static final int MAX_VISIBLE_BONUSES = 5;
    private ItemStack selectedItem = null;
    private float itemPopupProgress = 0.0f;
    private float itemTooltipScroll = 0.0f;
    private float itemTooltipMaxScroll = 0.0f;
    private int selectedDifficulty = 0;
    private final List<ButtonArea> difficultyButtons = new ArrayList<ButtonArea>();
    private ButtonArea startBattleButton;
    private ButtonArea detailsButton;
    private ButtonArea backButton;
    private ButtonArea closeButton;
    private ButtonArea itemPopupCloseButton;
    private ButtonArea confirmButton;
    private ButtonArea cancelButton;
    private ButtonArea confirmCloseButton;
    private ButtonArea viewAllRewardsButton;
    private ButtonArea rewardsBackButton;
    private boolean spoilersRevealed = false;
    private SpoilerClickArea spoilerClickArea = null;
    private final List<ItemClickArea> rewardClickAreas = new ArrayList<ItemClickArea>();
    private final List<ItemClickArea> allRewardsClickAreas = new ArrayList<ItemClickArea>();

    public BossInfoScreen(BossScreenData data, int entityId) {
        super((Component)Component.m_237119_());
        this.bossData = data;
        this.colors = data.getColorTheme();
        this.entityId = entityId;
    }

    protected void m_7856_() {
        if (FORCE_GUI_SCALE_2 && this.previousGuiScale == -1 && this.f_96541_ != null) {
            this.previousGuiScale = (Integer)this.f_96541_.f_91066_.m_231928_().m_231551_();
            if (this.previousGuiScale != 2) {
                this.f_96541_.f_91066_.m_231928_().m_231514_((Object)2);
                this.f_96541_.m_5741_();
            }
        }
        super.m_7856_();
        this.lastFrameTime = System.currentTimeMillis();
        this.openAnimProgress = 0.0f;
        this.scrollOffset = 0.0f;
        this.loreScrollOffset = 0.0f;
        int screenY = (this.f_96544_ - 260) / 2;
        int buttonWidth = 100;
        int buttonHeight = 22;
        int buttonY = screenY + 260 - 18 - 23;
        this.startBattleButton = new ButtonArea(0, buttonY, buttonWidth, buttonHeight, "gui.traveloptics.boss_screen.button.start_battle");
        this.detailsButton = new ButtonArea(0, buttonY, buttonWidth, buttonHeight, "gui.traveloptics.boss_screen.button.attacks_info");
        this.backButton = new ButtonArea(0, buttonY, buttonWidth, buttonHeight, "gui.traveloptics.boss_screen.button.back");
        this.closeButton = new ButtonArea(0, screenY + 18, 20, 20, "\u00d7");
        this.itemPopupCloseButton = new ButtonArea(0, 0, 18, 18, "\u00d7");
        this.confirmButton = new ButtonArea(0, 0, 80, 22, "gui.traveloptics.boss_screen.button.confirm");
        this.cancelButton = new ButtonArea(0, 0, 80, 22, "gui.traveloptics.boss_screen.button.cancel");
        this.confirmCloseButton = new ButtonArea(0, 0, 20, 20, "\u00d7");
        this.viewAllRewardsButton = new ButtonArea(0, 0, 20, 20, "+");
        this.rewardsBackButton = new ButtonArea(0, buttonY, buttonWidth, buttonHeight, "gui.traveloptics.boss_screen.button.back");
        this.difficultyButtons.clear();
        if (this.bossData.hasDifficulties() && !this.bossData.getDifficultyOptions().isEmpty()) {
            this.selectedDifficulty = this.bossData.getDifficultyOptions().get(0).getDifficultyIndex();
        }
        this.viewportHeight = 164;
        Objects.requireNonNull(this.f_96547_);
        this.loreViewportHeight = 9 * 3;
        this.rewardsPanelViewportHeight = 164;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.updateAnimations();
        this.m_280273_(graphics);
        int screenY = (this.f_96544_ - 260) / 2;
        if (this.showingRewardsPanel || this.rewardsPanelClosing) {
            this.renderRewardsPanel(graphics, screenY, mouseX, mouseY);
        } else if (this.showingConfirmation || this.confirmationClosing) {
            this.renderConfirmationPage(graphics, screenY, mouseX, mouseY);
        } else if (this.showingDetails || this.detailsClosing) {
            this.renderDetailsPage(graphics, screenY, mouseX, mouseY);
        } else {
            this.renderMainPage(graphics, screenY, mouseX, mouseY);
        }
        if (this.selectedItem != null || this.itemPopupProgress > 0.0f) {
            this.renderItemPopup(graphics, mouseX, mouseY);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        if (FORCE_GUI_SCALE_2 && this.previousGuiScale != -1 && this.previousGuiScale != 2 && this.f_96541_ != null) {
            this.f_96541_.f_91066_.m_231928_().m_231514_((Object)this.previousGuiScale);
            this.f_96541_.m_5741_();
        }
        super.m_7379_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.selectedItem != null && this.itemTooltipMaxScroll > 0.0f) {
            this.itemTooltipScroll = Mth.m_14036_((float)(this.itemTooltipScroll - (float)delta * 10.0f), (float)0.0f, (float)this.itemTooltipMaxScroll);
            return true;
        }
        if (this.detailsAnimating || this.rewardsPanelAnimating) {
            return false;
        }
        if (this.showingConfirmation && this.difficultyBonusMaxScroll > 0.0f) {
            this.difficultyBonusScrollOffset = Mth.m_14036_((float)(this.difficultyBonusScrollOffset - (float)delta * 10.0f), (float)0.0f, (float)this.difficultyBonusMaxScroll);
            return true;
        }
        if (this.showingRewardsPanel && this.rewardsPanelMaxScroll > 0.0f) {
            this.rewardsPanelScrollOffset = Mth.m_14036_((float)(this.rewardsPanelScrollOffset - (float)delta * 20.0f), (float)0.0f, (float)this.rewardsPanelMaxScroll);
            return true;
        }
        if (this.showingDetails && this.maxScroll > 0.0f) {
            this.scrollOffset = Mth.m_14036_((float)(this.scrollOffset - (float)delta * 20.0f), (float)0.0f, (float)this.maxScroll);
            return true;
        }
        if (!this.showingDetails && !this.showingRewardsPanel && this.loreMaxScroll > 0.0f && this.isMouseOverLoreArea(mouseX, mouseY)) {
            this.loreScrollOffset = Mth.m_14036_((float)(this.loreScrollOffset - (float)delta * 10.0f), (float)0.0f, (float)this.loreMaxScroll);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.openAnimProgress >= 1.0f) {
            if (this.selectedItem != null) {
                if (this.itemPopupCloseButton.isHovered((int)mouseX, (int)mouseY)) {
                    this.playClickSound();
                    this.closeItemPopup();
                    return true;
                }
                if (this.isClickOutsidePopup(mouseX, mouseY)) {
                    this.playClickSound();
                    this.closeItemPopup();
                    return true;
                }
                return true;
            }
            if (this.closeButton.isHovered((int)mouseX, (int)mouseY)) {
                this.playClickSound();
                this.m_7379_();
                return true;
            }
            if (!(this.showingDetails || this.showingConfirmation || this.showingRewardsPanel)) {
                for (ItemClickArea area : this.rewardClickAreas) {
                    if (!area.isHovered((int)mouseX, (int)mouseY)) continue;
                    this.playClickSound();
                    this.selectedItem = area.item;
                    this.itemTooltipScroll = 0.0f;
                    return true;
                }
                if (this.viewAllRewardsButton.isHovered((int)mouseX, (int)mouseY) && this.bossData.getRewards().size() > 8) {
                    this.playClickSound();
                    this.openRewardsPanel();
                    return true;
                }
                if (this.startBattleButton.isHovered((int)mouseX, (int)mouseY)) {
                    this.playClickSound();
                    this.openConfirmationPage();
                    return true;
                }
                if (this.detailsButton.isHovered((int)mouseX, (int)mouseY)) {
                    this.playClickSound();
                    this.openDetailsPage();
                    return true;
                }
            } else if (this.showingRewardsPanel) {
                for (ItemClickArea area : this.allRewardsClickAreas) {
                    if (!area.isHovered((int)mouseX, (int)mouseY)) continue;
                    this.playClickSound();
                    this.selectedItem = area.item;
                    this.itemTooltipScroll = 0.0f;
                    return true;
                }
                if (this.rewardsBackButton.isHovered((int)mouseX, (int)mouseY) && !this.rewardsPanelAnimating) {
                    this.playClickSound();
                    this.closeRewardsPanel();
                    return true;
                }
            } else if (this.showingDetails) {
                if (this.backButton.isHovered((int)mouseX, (int)mouseY) && !this.detailsAnimating) {
                    this.playClickSound();
                    this.closeDetailsPage();
                    return true;
                }
                if (this.spoilerClickArea != null && this.spoilerClickArea.isHovered((int)mouseX, (int)mouseY)) {
                    this.playClickSound();
                    this.spoilersRevealed = true;
                    return true;
                }
            } else if (this.showingConfirmation) {
                for (int i = 0; i < this.difficultyButtons.size(); ++i) {
                    if (!this.difficultyButtons.get(i).isHovered((int)mouseX, (int)mouseY)) continue;
                    int oldDifficulty = this.selectedDifficulty;
                    this.selectedDifficulty = this.bossData.getDifficultyOptions().get(i).getDifficultyIndex();
                    if (oldDifficulty != this.selectedDifficulty) {
                        this.difficultyBonusScrollOffset = 0.0f;
                    }
                    this.playClickSound();
                    return true;
                }
                if (this.confirmButton.isHovered((int)mouseX, (int)mouseY) && !this.confirmationAnimating) {
                    this.playClickSound();
                    TravelopticsMessages.sendToServer(new StartBossBattlePacket(this.entityId, this.selectedDifficulty));
                    this.m_7379_();
                    return true;
                }
                if (this.cancelButton.isHovered((int)mouseX, (int)mouseY) && !this.confirmationAnimating) {
                    this.playClickSound();
                    this.closeConfirmationPage();
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.selectedItem != null) {
                this.closeItemPopup();
                return true;
            }
            if (!this.detailsAnimating && !this.confirmationAnimating) {
                this.m_7379_();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private void updateAnimations() {
        long currentTime = System.currentTimeMillis();
        float deltaTime = 0.0f;
        if (this.lastFrameTime != 0L) {
            deltaTime = (float)(currentTime - this.lastFrameTime) / 1000.0f;
            this.animationTime += deltaTime;
        }
        this.lastFrameTime = currentTime;
        if (this.openAnimProgress < 1.0f) {
            this.openAnimProgress = Math.min(1.0f, this.openAnimProgress + deltaTime / 0.25f);
        }
        if (this.detailsAnimating) {
            if (this.detailsClosing) {
                this.detailsAnimProgress += deltaTime / 0.3f;
                if (this.detailsAnimProgress >= 1.0f) {
                    this.detailsAnimProgress = 1.0f;
                    this.detailsAnimating = false;
                    this.detailsClosing = false;
                    this.showingDetails = false;
                }
            } else {
                this.detailsAnimProgress += deltaTime / 0.3f;
                if (this.detailsAnimProgress >= 1.0f) {
                    this.detailsAnimProgress = 1.0f;
                    this.detailsAnimating = false;
                }
            }
        }
        if (this.confirmationAnimating) {
            if (this.confirmationClosing) {
                this.confirmationAnimProgress += deltaTime / 0.3f;
                if (this.confirmationAnimProgress >= 1.0f) {
                    this.confirmationAnimProgress = 1.0f;
                    this.confirmationAnimating = false;
                    this.confirmationClosing = false;
                    this.showingConfirmation = false;
                }
            } else {
                this.confirmationAnimProgress += deltaTime / 0.3f;
                if (this.confirmationAnimProgress >= 1.0f) {
                    this.confirmationAnimProgress = 1.0f;
                    this.confirmationAnimating = false;
                }
            }
        }
        if (this.rewardsPanelAnimating) {
            if (this.rewardsPanelClosing) {
                this.rewardsPanelAnimProgress += deltaTime / 0.3f;
                if (this.rewardsPanelAnimProgress >= 1.0f) {
                    this.rewardsPanelAnimProgress = 1.0f;
                    this.rewardsPanelAnimating = false;
                    this.rewardsPanelClosing = false;
                    this.showingRewardsPanel = false;
                }
            } else {
                this.rewardsPanelAnimProgress += deltaTime / 0.3f;
                if (this.rewardsPanelAnimProgress >= 1.0f) {
                    this.rewardsPanelAnimProgress = 1.0f;
                    this.rewardsPanelAnimating = false;
                }
            }
        }
        if (this.selectedItem != null && this.itemPopupProgress < 1.0f) {
            this.itemPopupProgress = Math.min(1.0f, this.itemPopupProgress + deltaTime / 0.2f);
        } else if (this.selectedItem == null && this.itemPopupProgress > 0.0f) {
            this.itemPopupProgress = Math.max(0.0f, this.itemPopupProgress - deltaTime / 0.2f);
        }
    }

    private void openDetailsPage() {
        this.showingDetails = true;
        this.detailsAnimating = true;
        this.detailsClosing = false;
        this.detailsAnimProgress = 0.0f;
        this.scrollOffset = 0.0f;
    }

    private void closeDetailsPage() {
        this.detailsClosing = true;
        this.detailsAnimating = true;
        this.detailsAnimProgress = 0.0f;
    }

    private void openConfirmationPage() {
        this.showingConfirmation = true;
        this.confirmationAnimating = true;
        this.confirmationClosing = false;
        this.confirmationAnimProgress = 0.0f;
        this.difficultyBonusScrollOffset = 0.0f;
    }

    private void closeConfirmationPage() {
        this.confirmationClosing = true;
        this.confirmationAnimating = true;
        this.confirmationAnimProgress = 0.0f;
        this.difficultyBonusScrollOffset = 0.0f;
    }

    private void closeItemPopup() {
        this.selectedItem = null;
        this.itemTooltipScroll = 0.0f;
    }

    private void openRewardsPanel() {
        this.showingRewardsPanel = true;
        this.rewardsPanelAnimating = true;
        this.rewardsPanelClosing = false;
        this.rewardsPanelAnimProgress = 0.0f;
        this.rewardsPanelScrollOffset = 0.0f;
    }

    private void closeRewardsPanel() {
        this.rewardsPanelClosing = true;
        this.rewardsPanelAnimating = true;
        this.rewardsPanelAnimProgress = 0.0f;
    }

    private boolean isClickOutsidePopup(double mouseX, double mouseY) {
        int popupX = (this.f_96543_ - 220) / 2;
        int popupY = (this.f_96544_ - 300) / 2;
        return mouseX < (double)popupX || mouseX > (double)(popupX + 220) || mouseY < (double)popupY || mouseY > (double)(popupY + 300);
    }

    private void renderMainPage(GuiGraphics graphics, int screenY, int mouseX, int mouseY) {
        float easedProgress = this.easeOutCubic(this.openAnimProgress);
        int currentWidth = (int)((float)this.f_96543_ * easedProgress);
        int screenX = (this.f_96543_ - currentWidth) / 2;
        graphics.m_280168_().m_85836_();
        this.renderScreenBackground(graphics, screenX, screenY, currentWidth, 260);
        this.renderElegantBorders(graphics, screenX, screenY, currentWidth, 260, easedProgress);
        if (this.openAnimProgress > 0.3f) {
            float contentAlpha = Math.min(1.0f, (this.openAnimProgress - 0.3f) / 0.7f);
            if (this.bossData.getBossImageLocation() != null) {
                int scaledWidth = (int)((float)this.bossData.getBossImageWidth() * this.bossData.getBossImageScale());
                int scaledHeight = (int)((float)this.bossData.getBossImageHeight() * this.bossData.getBossImageScale());
                int imageX = screenX + 18 + this.bossData.getBossImageOffsetX();
                int imageY = screenY + (260 - scaledHeight) / 2 + this.bossData.getBossImageOffsetY();
                this.renderBossImage(graphics, imageX, imageY, scaledWidth, scaledHeight, contentAlpha);
            }
            int contentX = screenX + 18 + 280 + 90;
            int contentY = screenY + 18 + 10;
            int contentWidth = currentWidth - 370 - 36 - 20;
            if (contentWidth > 0) {
                this.renderBossInfo(graphics, contentX, contentY, contentWidth, contentAlpha);
            }
            this.updateMainPageButtons(screenX, screenY, currentWidth);
            this.renderCustomButton(graphics, this.startBattleButton, mouseX, mouseY, -12255420, contentAlpha);
            this.renderCustomButton(graphics, this.detailsButton, mouseX, mouseY, -12285697, contentAlpha);
            this.renderCustomButton(graphics, this.closeButton, mouseX, mouseY, -48060, contentAlpha);
        }
        graphics.m_280168_().m_85849_();
    }

    private void renderDetailsPage(GuiGraphics graphics, int screenY, int mouseX, int mouseY) {
        float animProgress = this.detailsClosing ? 1.0f - this.detailsAnimProgress : this.detailsAnimProgress;
        float easedProgress = this.easeOutCubic(animProgress);
        int currentHeight = (int)(260.0f * easedProgress);
        int animatedScreenY = screenY + (260 - currentHeight) / 2;
        float alpha = this.detailsClosing ? 1.0f - this.detailsAnimProgress : 1.0f;
        graphics.m_280168_().m_85836_();
        if (this.detailsClosing) {
            this.renderFadedDetailsBackground(graphics, 0, animatedScreenY, this.f_96543_, currentHeight, alpha);
        } else {
            this.renderScreenBackground(graphics, 0, animatedScreenY, this.f_96543_, currentHeight);
            this.renderElegantBorders(graphics, 0, animatedScreenY, this.f_96543_, currentHeight, easedProgress);
        }
        if (easedProgress > 0.3f) {
            float contentAlpha = this.detailsClosing ? alpha : Math.min(1.0f, (easedProgress - 0.3f) / 0.7f);
            int contentX = 48;
            int contentY = animatedScreenY + 18 + 10;
            int contentWidth = this.f_96543_ - 36 - 60;
            int scissorHeight = Math.max(0, currentHeight - 36 - 45);
            if (scissorHeight > 0) {
                this.enableScissor(contentX, contentY, contentWidth, scissorHeight);
                this.renderAdvancedInfo(graphics, contentX, contentY, contentWidth, contentAlpha);
                this.disableScissor();
                if (this.maxScroll > 0.0f && !this.detailsClosing) {
                    this.renderScrollbar(graphics, this.f_96543_ - 18 - 20, contentY, scissorHeight);
                }
            }
            this.updateDetailsPageButtons(0, animatedScreenY, this.f_96543_);
            if (!this.detailsClosing) {
                this.renderCustomButton(graphics, this.backButton, mouseX, mouseY, -21948, contentAlpha);
                this.renderCustomButton(graphics, this.closeButton, mouseX, mouseY, -48060, contentAlpha);
            }
        }
        graphics.m_280168_().m_85849_();
    }

    private void renderConfirmationPage(GuiGraphics graphics, int screenY, int mouseX, int mouseY) {
        float animProgress = this.confirmationClosing ? 1.0f - this.confirmationAnimProgress : this.confirmationAnimProgress;
        float easedProgress = this.easeOutCubic(animProgress);
        int currentHeight = (int)(260.0f * easedProgress);
        int animatedScreenY = screenY + (260 - currentHeight) / 2;
        float alpha = this.confirmationClosing ? 1.0f - this.confirmationAnimProgress : 1.0f;
        graphics.m_280168_().m_85836_();
        if (this.confirmationClosing) {
            this.renderFadedDetailsBackground(graphics, 0, animatedScreenY, this.f_96543_, currentHeight, alpha);
        } else {
            this.renderScreenBackground(graphics, 0, animatedScreenY, this.f_96543_, currentHeight);
            this.renderElegantBorders(graphics, 0, animatedScreenY, this.f_96543_, currentHeight, easedProgress);
        }
        if (easedProgress > 0.3f) {
            int buttonsX;
            float contentAlpha = this.confirmationClosing ? alpha : Math.min(1.0f, (easedProgress - 0.3f) / 0.7f);
            int alphaInt = (int)(contentAlpha * 255.0f);
            int contentX = 48;
            int contentY = animatedScreenY + 18 + 10;
            int contentWidth = this.f_96543_ - 36 - 60;
            MutableComponent confirmTitle = Component.m_237115_((String)"gui.traveloptics.boss_screen.confirm.title");
            this.drawCenteredScaledText(graphics, (Component)confirmTitle, 1.5f, contentY, this.applyAlpha(this.colors.titleColor, alphaInt), true);
            Objects.requireNonNull(this.f_96547_);
            contentY += (int)(9.0f * 1.5f) + 4;
            if (this.bossData.hasDifficulties() && this.bossData.getDifficultyOptions().size() <= 3 && !this.bossData.getRequiredItems().isEmpty()) {
                contentY = this.renderRequiredItemsSmall(graphics, contentY, contentWidth, alphaInt);
                contentY += 6;
            }
            this.renderCenteredDecorativeDivider(graphics, contentX, contentY, contentWidth, alphaInt);
            contentY += 12;
            MutableComponent confirmMessage = Component.m_237115_((String)"gui.traveloptics.boss_screen.confirm.message");
            for (String line : this.wrapText(confirmMessage.getString(), this.f_96547_, contentWidth)) {
                this.drawCenteredString(graphics, (Component)Component.m_237113_((String)line), contentY, this.applyAlpha(this.colors.textColor, alphaInt));
                Objects.requireNonNull(this.f_96547_);
                contentY += 9;
            }
            contentY += 12;
            if (this.bossData.hasDifficulties() && this.bossData.getDifficultyOptions().size() <= 3) {
                contentY = this.renderDifficultySelectionCompact(graphics, contentX, contentY, contentWidth, alphaInt, mouseX, mouseY);
            } else if (!this.bossData.hasDifficulties() && !this.bossData.getRequiredItems().isEmpty()) {
                contentY = this.renderRequiredItemsDisplay(graphics, contentY, contentWidth, alphaInt);
            }
            int buttonY = animatedScreenY + currentHeight - 18 - 28;
            int buttonSpacing = 10;
            int totalButtonWidth = this.confirmButton.width + this.cancelButton.width + buttonSpacing;
            this.confirmButton.x = buttonsX = (this.f_96543_ - totalButtonWidth) / 2;
            this.confirmButton.y = buttonY;
            this.cancelButton.x = buttonsX + this.confirmButton.width + buttonSpacing;
            this.cancelButton.y = buttonY;
            this.confirmCloseButton.x = this.f_96543_ - 18 - 20;
            this.confirmCloseButton.y = animatedScreenY + 18;
            if (!this.confirmationClosing) {
                this.renderCustomButton(graphics, this.confirmButton, mouseX, mouseY, -12255420, contentAlpha);
                this.renderCustomButton(graphics, this.cancelButton, mouseX, mouseY, -48060, contentAlpha);
                this.renderCustomButton(graphics, this.confirmCloseButton, mouseX, mouseY, -48060, contentAlpha);
            }
        }
        graphics.m_280168_().m_85849_();
    }

    private void renderRewardsPanel(GuiGraphics graphics, int screenY, int mouseX, int mouseY) {
        float animProgress = this.rewardsPanelClosing ? 1.0f - this.rewardsPanelAnimProgress : this.rewardsPanelAnimProgress;
        float easedProgress = this.easeOutCubic(animProgress);
        int currentHeight = (int)(260.0f * easedProgress);
        int animatedScreenY = screenY + (260 - currentHeight) / 2;
        float alpha = this.rewardsPanelClosing ? 1.0f - this.rewardsPanelAnimProgress : 1.0f;
        graphics.m_280168_().m_85836_();
        if (this.rewardsPanelClosing) {
            this.renderFadedDetailsBackground(graphics, 0, animatedScreenY, this.f_96543_, currentHeight, alpha);
        } else {
            this.renderScreenBackground(graphics, 0, animatedScreenY, this.f_96543_, currentHeight);
            this.renderElegantBorders(graphics, 0, animatedScreenY, this.f_96543_, currentHeight, easedProgress);
        }
        if (easedProgress > 0.3f) {
            float contentAlpha = this.rewardsPanelClosing ? alpha : Math.min(1.0f, (easedProgress - 0.3f) / 0.7f);
            int contentX = 48;
            int contentY = animatedScreenY + 18 + 10;
            int contentWidth = this.f_96543_ - 36 - 60;
            int scissorHeight = Math.max(0, currentHeight - 36 - 45);
            if (scissorHeight > 0) {
                this.enableScissor(contentX, contentY, contentWidth, scissorHeight);
                this.renderAllRewards(graphics, contentX, contentY, contentWidth, contentAlpha);
                this.disableScissor();
                if (this.rewardsPanelMaxScroll > 0.0f && !this.rewardsPanelClosing) {
                    this.renderScrollbar(graphics, this.f_96543_ - 18 - 20, contentY, scissorHeight);
                }
            }
            this.updateRewardsPanelButtons(0, animatedScreenY, this.f_96543_);
            if (!this.rewardsPanelClosing) {
                this.renderCustomButton(graphics, this.rewardsBackButton, mouseX, mouseY, -21948, contentAlpha);
                this.renderCustomButton(graphics, this.closeButton, mouseX, mouseY, -48060, contentAlpha);
            }
        }
        graphics.m_280168_().m_85849_();
    }

    private int renderRequiredItemsDisplay(GuiGraphics graphics, int y, int contentWidth, int alphaInt) {
        List<BossScreenData.RequiredItem> requiredItems = this.bossData.getRequiredItems();
        MutableComponent requirementLabel = Component.m_237115_((String)"gui.traveloptics.boss_screen.confirm.requires").m_130940_(ChatFormatting.UNDERLINE);
        this.drawCenteredString(graphics, (Component)requirementLabel, y, this.applyAlpha(this.colors.borderHighlight, alphaInt));
        Objects.requireNonNull(this.f_96547_);
        y += 9 + 10;
        int itemSize = 32;
        float pulse = Mth.m_14031_((float)(this.animationTime * 2.0f)) * 0.3f + 0.7f;
        if (requiredItems.size() == 1) {
            BossScreenData.RequiredItem reqItem = requiredItems.get(0);
            ItemStack item = reqItem.getItem();
            int quantity = reqItem.getQuantity();
            int itemX = (this.f_96543_ - itemSize) / 2;
            this.renderItemGlowAndCorners(graphics, itemX, y, itemSize, pulse, alphaInt);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alphaInt / 255.0f));
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)itemX, (float)y, 0.0f);
            graphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
            graphics.m_280480_(item, 0, 0);
            graphics.m_280168_().m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            if (quantity > 1) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                this.renderQuantityText(graphics, String.valueOf(quantity), itemX, y, itemSize, alphaInt);
                graphics.m_280168_().m_85849_();
            }
            Component itemName = item.m_41786_();
            int nameX = (this.f_96543_ - this.f_96547_.m_92852_((FormattedText)itemName)) / 2;
            int nameY = y + itemSize + 8;
            graphics.m_280614_(this.f_96547_, itemName, nameX, nameY, this.applyAlpha(this.colors.textColor, alphaInt), false);
            Objects.requireNonNull(this.f_96547_);
            y += itemSize + 9 + 15;
        } else {
            int itemX;
            int i;
            int itemSpacing = 48;
            int totalWidth = requiredItems.size() * itemSize + (requiredItems.size() - 1) * (itemSpacing - itemSize);
            int startX = (this.f_96543_ - totalWidth) / 2;
            for (i = 0; i < requiredItems.size(); ++i) {
                ItemStack item = requiredItems.get(i).getItem();
                itemX = startX + i * itemSpacing;
                this.renderItemGlowAndCorners(graphics, itemX, y, itemSize, pulse, alphaInt);
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alphaInt / 255.0f));
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)itemX, (float)y, 0.0f);
                graphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
                graphics.m_280480_(item, 0, 0);
                graphics.m_280168_().m_85849_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
            }
            for (i = 0; i < requiredItems.size(); ++i) {
                int quantity = requiredItems.get(i).getQuantity();
                if (quantity <= 1) continue;
                itemX = startX + i * itemSpacing;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                this.renderQuantityText(graphics, String.valueOf(quantity), itemX, y, itemSize, alphaInt);
                graphics.m_280168_().m_85849_();
            }
            y += itemSize + 10;
        }
        return y;
    }

    private int renderRequiredItemsSmall(GuiGraphics graphics, int y, int contentWidth, int alphaInt) {
        List<BossScreenData.RequiredItem> requiredItems = this.bossData.getRequiredItems();
        if (requiredItems.isEmpty()) {
            return y;
        }
        int itemSize = 18;
        int itemSpacing = 24;
        float pulse = Mth.m_14031_((float)(this.animationTime * 2.0f)) * 0.3f + 0.7f;
        int totalWidth = requiredItems.size() * itemSize + (requiredItems.size() - 1) * (itemSpacing - itemSize);
        MutableComponent requiredText = Component.m_237115_((String)"gui.traveloptics.boss_screen.confirm.requires");
        int textWidth = this.f_96547_.m_92852_((FormattedText)requiredText);
        int fullWidth = totalWidth + 6 + textWidth;
        int itemsX = (this.f_96543_ - fullWidth) / 2;
        for (int i = 0; i < requiredItems.size(); ++i) {
            ItemStack item = requiredItems.get(i).getItem();
            int itemX = itemsX + i * itemSpacing;
            this.renderItemGlowAndCorners(graphics, itemX, y, itemSize, pulse, alphaInt);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alphaInt / 255.0f));
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)itemX, (float)y, 0.0f);
            float scale = (float)itemSize / 16.0f;
            graphics.m_280168_().m_85841_(scale, scale, 1.0f);
            graphics.m_280480_(item, 0, 0);
            graphics.m_280168_().m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        int textX = itemsX + totalWidth + 6;
        Objects.requireNonNull(this.f_96547_);
        int textY = y + (itemSize - 9) / 2;
        graphics.m_280614_(this.f_96547_, (Component)requiredText, textX, textY, this.applyAlpha(this.colors.textColor, alphaInt), false);
        return y + itemSize + 4;
    }

    private int renderDifficultySelectionCompact(GuiGraphics graphics, int x, int y, int width, int alphaInt, int mouseX, int mouseY) {
        List<BossScreenData.DifficultyOption> difficulties = this.bossData.getDifficultyOptions();
        if (difficulties.isEmpty()) {
            return y;
        }
        int startY = y;
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonSpacing = 6;
        int gapBetweenColumns = 45;
        int leftColumnWidth = buttonWidth;
        int rightColumnWidth = 220;
        int screenCenterX = this.f_96543_ / 2;
        int leftButtonX = screenCenterX - buttonWidth - gapBetweenColumns / 2;
        int rightColumnX = screenCenterX + gapBetweenColumns / 2;
        int totalHeight = difficulties.size() * buttonHeight + (difficulties.size() - 1) * buttonSpacing;
        int centeredStartY = y + 10;
        this.difficultyButtons.clear();
        int buttonY = centeredStartY;
        for (int i = 0; i < difficulties.size(); ++i) {
            int borderColor;
            int bgColor;
            BossScreenData.DifficultyOption option = difficulties.get(i);
            ButtonArea diffButton = new ButtonArea(leftButtonX, buttonY, buttonWidth, buttonHeight, "");
            this.difficultyButtons.add(diffButton);
            boolean isSelected = this.selectedDifficulty == option.getDifficultyIndex();
            boolean isHovered = diffButton.isHovered(mouseX, mouseY);
            if (isSelected) {
                bgColor = this.applyAlpha(this.colors.borderHighlight, (int)((float)alphaInt * 0.3f));
                borderColor = this.applyAlpha(this.colors.borderHighlight, alphaInt);
            } else if (isHovered) {
                bgColor = this.applyAlpha(this.colors.bgDark, (int)((float)alphaInt * 0.8f));
                borderColor = this.applyAlpha(this.colors.borderAccent, alphaInt);
            } else {
                bgColor = this.applyAlpha(this.colors.bgDark, (int)((float)alphaInt * 0.6f));
                borderColor = this.applyAlpha(this.colors.borderAccent, (int)((float)alphaInt * 0.5f));
            }
            graphics.m_280509_(leftButtonX, buttonY, leftButtonX + buttonWidth, buttonY + buttonHeight, bgColor);
            this.renderBoxBorder(graphics, leftButtonX, buttonY, buttonWidth, buttonHeight, borderColor);
            int textColor = isSelected ? this.applyAlpha(-1, alphaInt) : this.applyAlpha(this.colors.textColor, alphaInt);
            int n = this.f_96547_.m_92852_((FormattedText)option.getName());
            int textX = leftButtonX + (buttonWidth - n) / 2;
            Objects.requireNonNull(this.f_96547_);
            int textY = buttonY + (buttonHeight - 9) / 2;
            graphics.m_280614_(this.f_96547_, option.getName(), textX, textY, textColor, false);
            buttonY += buttonHeight + buttonSpacing;
        }
        BossScreenData.DifficultyOption selectedOption = null;
        for (BossScreenData.DifficultyOption option : difficulties) {
            if (option.getDifficultyIndex() != this.selectedDifficulty) continue;
            selectedOption = option;
            break;
        }
        if (selectedOption != null && !selectedOption.getBonuses().isEmpty()) {
            int bonusesY = centeredStartY;
            MutableComponent bonusLabel = Component.m_237115_((String)"gui.traveloptics.boss_screen.difficulty.bonuses").m_130940_(ChatFormatting.UNDERLINE);
            graphics.m_280614_(this.f_96547_, (Component)bonusLabel, rightColumnX, bonusesY, this.applyAlpha(this.colors.borderHighlight, alphaInt), false);
            Objects.requireNonNull(this.f_96547_);
            bonusesY += 9 + 6;
            int totalBonusHeight = 0;
            ArrayList<List<String>> wrappedBonuses = new ArrayList<List<String>>();
            for (Component bonus : selectedOption.getBonuses()) {
                String bonusText = "\u2022 " + bonus.getString();
                List<String> list = this.wrapText(bonusText, this.f_96547_, rightColumnWidth - 4);
                wrappedBonuses.add(list);
                int n = list.size();
                Objects.requireNonNull(this.f_96547_);
                totalBonusHeight += n * (9 + 2);
            }
            Objects.requireNonNull(this.f_96547_);
            int viewportHeight = 5 * (9 + 2);
            this.difficultyBonusMaxScroll = Math.max(0, totalBonusHeight - viewportHeight);
            this.enableScissor(rightColumnX, bonusesY, rightColumnWidth, viewportHeight);
            int currentY = bonusesY - (int)this.difficultyBonusScrollOffset;
            for (List list : wrappedBonuses) {
                for (int i = 0; i < list.size(); ++i) {
                    String line = (String)list.get(i);
                    int lineX = rightColumnX;
                    if (i > 0) {
                        lineX += 8;
                    }
                    graphics.m_280056_(this.f_96547_, line, lineX, currentY, this.applyAlpha(this.colors.textColor, alphaInt), false);
                    Objects.requireNonNull(this.f_96547_);
                    currentY += 9 + 2;
                }
            }
            this.disableScissor();
            if (this.difficultyBonusMaxScroll > 0.0f) {
                this.renderDifficultyBonusScrollbar(graphics, rightColumnX + rightColumnWidth - 8, bonusesY, viewportHeight, alphaInt);
            }
            y = bonusesY + viewportHeight + 10;
        } else {
            y = buttonY;
        }
        return Math.max(y, buttonY);
    }

    private void renderBossInfo(GuiGraphics graphics, int x, int y, int width, float alpha) {
        int alphaInt = (int)(alpha * 255.0f);
        this.rewardClickAreas.clear();
        graphics.m_280168_().m_85836_();
        float nameScale = 1.8f;
        graphics.m_280168_().m_85841_(nameScale, nameScale, 1.0f);
        this.renderStaticGlowText(graphics, this.f_96547_, this.bossData.getBossName(), (int)((float)x / nameScale), (int)((float)y / nameScale), this.applyAlpha(this.colors.titleColor, 255), 0.5f);
        graphics.m_280168_().m_85849_();
        Objects.requireNonNull(this.f_96547_);
        MutableComponent titleComp = this.bossData.getBossTitle().m_6881_().m_130940_(ChatFormatting.ITALIC);
        graphics.m_280614_(this.f_96547_, (Component)titleComp, x, y += (int)(9.0f * nameScale) + 6, this.applyAlpha(this.colors.subtitleColor, alphaInt), false);
        Objects.requireNonNull(this.f_96547_);
        this.renderDecorativeDivider(graphics, x, y += 9 + 8, width, alphaInt);
        y += 14;
        y = this.renderLoreSection(graphics, x, y, width, alphaInt);
        y += 6;
        y = this.renderBattleSuggestions(graphics, x, y, alphaInt);
        y += 8;
        if (!this.bossData.getRewards().isEmpty()) {
            this.renderFancyRewardsSection(graphics, x, y, width, alpha);
        }
    }

    private int renderLoreSection(GuiGraphics graphics, int x, int y, int width, int alphaInt) {
        MutableComponent loreLabel = Component.m_237115_((String)"gui.traveloptics.boss_screen.label.lore").m_130940_(ChatFormatting.UNDERLINE);
        graphics.m_280614_(this.f_96547_, (Component)loreLabel, x, y, this.applyAlpha(this.colors.borderHighlight, alphaInt), false);
        Objects.requireNonNull(this.f_96547_);
        int loreStartY = y += 9 + 4;
        List<String> loreLines = this.wrapText(this.bossData.getLoreText().getString(), this.f_96547_, width);
        int n = loreLines.size();
        Objects.requireNonNull(this.f_96547_);
        this.loreContentHeight = n * 9;
        this.loreMaxScroll = Math.max(0, this.loreContentHeight - this.loreViewportHeight);
        this.enableScissor(x, loreStartY, width, this.loreViewportHeight);
        int loreY = loreStartY - (int)this.loreScrollOffset;
        for (String line : loreLines) {
            graphics.m_280056_(this.f_96547_, line, x, loreY, this.applyAlpha(this.colors.textColor, alphaInt), false);
            Objects.requireNonNull(this.f_96547_);
            loreY += 9;
        }
        this.disableScissor();
        if (this.loreMaxScroll > 0.0f) {
            this.renderLoreScrollbar(graphics, x + width + 2, loreStartY, this.loreViewportHeight, alphaInt);
        }
        return loreStartY + this.loreViewportHeight;
    }

    private int renderBattleSuggestions(GuiGraphics graphics, int x, int y, int alphaInt) {
        MutableComponent suggestLabel = Component.m_237115_((String)"gui.traveloptics.boss_screen.label.suggestions").m_130940_(ChatFormatting.UNDERLINE);
        graphics.m_280614_(this.f_96547_, (Component)suggestLabel, x, y, this.applyAlpha(this.colors.borderHighlight, alphaInt), false);
        Objects.requireNonNull(this.f_96547_);
        y += 9 + 3;
        for (int i = 0; i < Math.min(this.bossData.getBattleSuggestions().size(), 3); ++i) {
            Component suggestion = this.bossData.getBattleSuggestions().get(i);
            MutableComponent bullet = Component.m_237113_((String)"\u2022 ").m_7220_(suggestion);
            graphics.m_280614_(this.f_96547_, (Component)bullet, x, y, this.applyAlpha(this.colors.textColor, alphaInt), false);
            Objects.requireNonNull(this.f_96547_);
            y += 9;
        }
        return y;
    }

    private void renderFancyRewardsSection(GuiGraphics graphics, int x, int y, int width, float alpha) {
        int alphaInt = (int)(alpha * 255.0f);
        MutableComponent rewardLabel = Component.m_237115_((String)"gui.traveloptics.boss_screen.label.rewards").m_130940_(ChatFormatting.UNDERLINE);
        graphics.m_280614_(this.f_96547_, (Component)rewardLabel, x, y, this.applyAlpha(this.colors.borderHighlight, alphaInt), false);
        Objects.requireNonNull(this.f_96547_);
        y += 9 + 8;
        float pulse = Mth.m_14031_((float)(this.animationTime * 2.0f)) * 0.3f + 0.7f;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        int itemSize = 24;
        int itemSpacing = 32;
        int startX = x + 4;
        int maxDisplay = 8;
        int displayCount = Math.min(this.bossData.getRewards().size(), maxDisplay);
        for (int i = 0; i < displayCount; ++i) {
            BossScreenData.RewardItem rewardItem = this.bossData.getRewards().get(i);
            ItemStack reward = rewardItem.getItem();
            int itemX = startX + i * itemSpacing;
            int itemY = y;
            boolean isHovered = this.isItemHovered(itemX, itemY, itemSize);
            float hoverScale = isHovered ? 1.15f : 1.0f;
            this.renderRewardItem(graphics, rewardItem, itemX, itemY, itemSize, hoverScale, alphaInt, isHovered);
            this.rewardClickAreas.add(new ItemClickArea(itemX, itemY, itemSize, itemSize, reward));
        }
        if (this.bossData.getRewards().size() > maxDisplay) {
            int dividerX = startX + displayCount * itemSpacing + 6;
            int dividerY = y;
            int dividerWidth = 4;
            int dividerHeight = itemSize;
            this.viewAllRewardsButton.x = dividerX - 2;
            this.viewAllRewardsButton.y = dividerY;
            this.viewAllRewardsButton.width = dividerWidth + 4;
            this.viewAllRewardsButton.height = dividerHeight;
            boolean isHovered = this.viewAllRewardsButton.isHovered((int)(this.f_96541_.f_91067_.m_91589_() * (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_()), (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_()));
            int barColor = isHovered ? this.applyAlpha(this.colors.borderHighlight, (int)((float)alphaInt * pulse)) : this.applyAlpha(this.colors.borderAccent, (int)((float)alphaInt * 0.7f));
            graphics.m_280509_(dividerX, dividerY, dividerX + dividerWidth, dividerY + dividerHeight, barColor);
            if (isHovered) {
                int glowAlpha = (int)((float)alphaInt * pulse * 0.15f);
                int glowColor = glowAlpha << 24 | this.colors.borderHighlight & 0xFFFFFF;
                graphics.m_280509_(dividerX - 2, dividerY, dividerX, dividerY + dividerHeight, glowColor);
                graphics.m_280509_(dividerX + dividerWidth, dividerY, dividerX + dividerWidth + 2, dividerY + dividerHeight, glowColor);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private boolean isItemHovered(int itemX, int itemY, int itemSize) {
        if (this.selectedItem == null && this.f_96541_ != null && this.f_96541_.f_91067_ != null) {
            int mouseX = (int)(this.f_96541_.f_91067_.m_91589_() * (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_());
            int mouseY = (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_());
            return mouseX >= itemX && mouseX < itemX + itemSize && mouseY >= itemY && mouseY < itemY + itemSize;
        }
        return false;
    }

    private void renderRewardItem(GuiGraphics graphics, BossScreenData.RewardItem rewardItem, int itemX, int itemY, int itemSize, float hoverScale, int alphaInt, boolean isHovered) {
        ItemStack reward = rewardItem.getItem();
        BossScreenData.RewardRarity rarity = rewardItem.getRarity();
        int centerX = itemX + itemSize / 2;
        int centerY = itemY + itemSize / 2;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)centerX, (float)centerY, 0.0f);
        graphics.m_280168_().m_85841_(hoverScale, hoverScale, 1.0f);
        graphics.m_280168_().m_252880_((float)(-centerX), (float)(-centerY), 0.0f);
        float pulse = Mth.m_14031_((float)(this.animationTime * 2.0f)) * 0.3f + 0.7f;
        this.renderRarityGlow(graphics, itemX, itemY, itemSize, pulse, rarity, alphaInt);
        this.renderRarityCorners(graphics, itemX, itemY, itemSize, pulse, rarity, alphaInt);
        graphics.m_280168_().m_252880_((float)itemX, (float)itemY, 0.0f);
        graphics.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
        graphics.m_280480_(reward, 0, 0);
        graphics.m_280370_(this.f_96547_, reward, 0, 0);
        graphics.m_280168_().m_85849_();
    }

    private void renderAllRewards(GuiGraphics graphics, int x, int y, int width, float alpha) {
        int startY;
        int alphaInt = (int)(alpha * 255.0f);
        this.allRewardsClickAreas.clear();
        int currentY = startY = y - (int)this.rewardsPanelScrollOffset;
        MutableComponent title = Component.m_237115_((String)"gui.traveloptics.boss_screen.label.all_rewards");
        this.drawCenteredScaledText(graphics, (Component)title, 1.5f, currentY, this.applyAlpha(this.colors.titleColor, alphaInt), true);
        Objects.requireNonNull(this.f_96547_);
        int dividerWidth = (int)((float)width * 0.6f);
        int dividerX = x + (width - dividerWidth) / 2;
        this.renderCenteredDecorativeDivider(graphics, dividerX, currentY += (int)(9.0f * 1.5f) + 10, dividerWidth, alphaInt);
        currentY += 20;
        int itemSize = 32;
        int itemSpacing = 40;
        int itemsPerRow = 12;
        int totalItems = this.bossData.getRewards().size();
        float pulse = Mth.m_14031_((float)(this.animationTime * 2.0f)) * 0.3f + 0.7f;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        int totalRows = (totalItems + itemsPerRow - 1) / itemsPerRow;
        for (int row = 0; row < totalRows; ++row) {
            int itemsInThisRow = Math.min(itemsPerRow, totalItems - row * itemsPerRow);
            int rowWidth = itemsInThisRow * itemSpacing - (itemSpacing - itemSize);
            int rowStartX = x + (width - rowWidth) / 2;
            for (int col = 0; col < itemsInThisRow; ++col) {
                int i = row * itemsPerRow + col;
                int itemX = rowStartX + col * itemSpacing;
                int itemY = currentY + row * itemSpacing;
                BossScreenData.RewardItem rewardItem = this.bossData.getRewards().get(i);
                ItemStack reward = rewardItem.getItem();
                boolean isHovered = this.isItemHovered(itemX, itemY, itemSize);
                float hoverScale = isHovered ? 1.15f : 1.0f;
                graphics.m_280168_().m_85836_();
                int centerX = itemX + itemSize / 2;
                int centerY = itemY + itemSize / 2;
                graphics.m_280168_().m_252880_((float)centerX, (float)centerY, 0.0f);
                graphics.m_280168_().m_85841_(hoverScale, hoverScale, 1.0f);
                graphics.m_280168_().m_252880_((float)(-centerX), (float)(-centerY), 0.0f);
                this.renderRarityGlow(graphics, itemX, itemY, itemSize, pulse, rewardItem.getRarity(), alphaInt);
                this.renderRarityCorners(graphics, itemX, itemY, itemSize, pulse, rewardItem.getRarity(), alphaInt);
                graphics.m_280168_().m_252880_((float)itemX, (float)itemY, 0.0f);
                graphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
                graphics.m_280480_(reward, 0, 0);
                graphics.m_280370_(this.f_96547_, reward, 0, 0);
                graphics.m_280168_().m_85849_();
                this.allRewardsClickAreas.add(new ItemClickArea(itemX, itemY, itemSize, itemSize, reward));
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        Objects.requireNonNull(this.f_96547_);
        this.rewardsPanelContentHeight = (int)(9.0f * 1.5f) + 10 + 20 + totalRows * itemSpacing + 20;
        this.rewardsPanelMaxScroll = Math.max(0, this.rewardsPanelContentHeight - this.rewardsPanelViewportHeight);
    }

    private void renderAdvancedInfo(GuiGraphics graphics, int x, int y, int width, float alpha) {
        int startY;
        int alphaInt = (int)(alpha * 255.0f);
        this.spoilerClickArea = null;
        int currentY = startY = y - (int)this.scrollOffset;
        MutableComponent title = Component.m_237115_((String)"gui.traveloptics.boss_screen.advanced_info.title");
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
        this.renderAnimatedGlowText(graphics, this.f_96547_, (Component)title, (int)((float)x / 1.5f), (int)((float)currentY / 1.5f), this.applyAlpha(this.colors.titleColor, alphaInt), 0.6f);
        graphics.m_280168_().m_85849_();
        Objects.requireNonNull(this.f_96547_);
        MutableComponent bossName = this.bossData.getBossName().m_6881_().m_130940_(ChatFormatting.ITALIC);
        graphics.m_280614_(this.f_96547_, (Component)bossName, x, currentY += (int)(9.0f * 1.5f) + 8, this.applyAlpha(this.colors.subtitleColor, alphaInt), false);
        Objects.requireNonNull(this.f_96547_);
        currentY += 9 + 10;
        for (BossScreenData.AdvancedInfo info : this.bossData.getAdvancedInfoSections()) {
            currentY = this.renderAdvancedInfoSection(graphics, x, currentY, width - 20, info, alphaInt);
            currentY += 10;
        }
        List<BossScreenData.AdvancedInfo> spoilerSections = this.bossData.getSpoilerInfoSections();
        if (!spoilerSections.isEmpty()) {
            currentY += 6;
            currentY = this.renderSpoilerSection(graphics, x, currentY, width, spoilerSections, alphaInt);
        }
        this.contentHeight = currentY - startY;
        this.maxScroll = Math.max(0, this.contentHeight - this.viewportHeight);
    }

    private int renderAdvancedInfoSection(GuiGraphics graphics, int x, int y, int width, BossScreenData.AdvancedInfo info, int alphaInt) {
        MutableComponent sectionTitle = info.getTitle().m_6881_();
        graphics.m_280614_(this.f_96547_, (Component)sectionTitle, x, y, this.applyAlpha(this.colors.borderHighlight, alphaInt), false);
        Objects.requireNonNull(this.f_96547_);
        y += 9 + 4;
        for (String line : this.wrapText(info.getDescription().getString(), this.f_96547_, width)) {
            graphics.m_280056_(this.f_96547_, line, x + 8, y, this.applyAlpha(this.colors.textColor, alphaInt), false);
            Objects.requireNonNull(this.f_96547_);
            y += 9;
        }
        return y;
    }

    private int renderSpoilerSection(GuiGraphics graphics, int x, int y, int width, List<BossScreenData.AdvancedInfo> spoilerSections, int alphaInt) {
        if (!this.spoilersRevealed) {
            return this.renderUnrevealedSpoiler(graphics, x, y, width, alphaInt);
        }
        return this.renderRevealedSpoiler(graphics, x, y, width, spoilerSections, alphaInt);
    }

    private int renderUnrevealedSpoiler(GuiGraphics graphics, int x, int y, int width, int alphaInt) {
        Objects.requireNonNull(this.f_96547_);
        int boxHeight = 9 * 2 + 22;
        boolean isHovered = this.isSpoilerHovered(x, y, width, boxHeight);
        int bgColor = isHovered ? this.applyAlpha(this.colors.bgDark, (int)((float)alphaInt * 0.8f)) : this.applyAlpha(this.colors.bgDark, (int)((float)alphaInt * 0.6f));
        graphics.m_280509_(x, y, x + width, y + boxHeight, bgColor);
        int borderColor = isHovered ? this.applyAlpha(this.colors.borderHighlight, alphaInt) : this.applyAlpha(this.colors.borderAccent, (int)((float)alphaInt * 0.7f));
        this.renderBoxBorder(graphics, x, y, width, boxHeight, borderColor);
        Objects.requireNonNull(this.f_96547_);
        int textBlockHeight = 9 * 2 + 6;
        int textStartY = y + (boxHeight - textBlockHeight) / 2;
        MutableComponent revealText = Component.m_237115_((String)"gui.traveloptics.boss_screen.spoiler.click_reveal");
        int textColor = isHovered ? this.applyAlpha(-1, alphaInt) : this.applyAlpha(this.colors.subtitleColor, alphaInt);
        this.drawCenteredString(graphics, (Component)revealText, textStartY, textColor);
        MutableComponent hintText = Component.m_237115_((String)"gui.traveloptics.boss_screen.spoiler.challenge_hint").m_130940_(ChatFormatting.ITALIC);
        int hintColor = isHovered ? this.applyAlpha(-3355444, alphaInt) : this.applyAlpha(this.colors.subtitleColor, (int)((float)alphaInt * 0.7f));
        Objects.requireNonNull(this.f_96547_);
        this.drawCenteredString(graphics, (Component)hintText, textStartY + 9 + 4, hintColor);
        this.spoilerClickArea = new SpoilerClickArea(x, y, width, boxHeight);
        return y + boxHeight;
    }

    private int renderRevealedSpoiler(GuiGraphics graphics, int x, int y, int width, List<BossScreenData.AdvancedInfo> spoilerSections, int alphaInt) {
        MutableComponent spoilerLabel = Component.m_237115_((String)"gui.traveloptics.boss_screen.label.spoilers");
        this.renderSpoilerDividerWithLabel(graphics, x, y, width, (Component)spoilerLabel, alphaInt);
        y += 18;
        for (BossScreenData.AdvancedInfo spoilerInfo : spoilerSections) {
            y = this.renderAdvancedInfoSection(graphics, x, y, width, spoilerInfo, alphaInt);
            y += 12;
        }
        return y;
    }

    private boolean isSpoilerHovered(int x, int y, int width, int height) {
        if (this.f_96541_ != null && this.f_96541_.f_91067_ != null) {
            int mouseX = (int)(this.f_96541_.f_91067_.m_91589_() * (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_());
            int mouseY = (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_());
            return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
        }
        return false;
    }

    private void renderItemPopup(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.selectedItem == null && this.itemPopupProgress <= 0.0f) {
            return;
        }
        if (this.selectedItem != null) {
            graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1946157056);
        }
        float easedProgress = this.easeOutCubic(this.itemPopupProgress);
        int popupX = (this.f_96543_ - 220) / 2;
        int popupY = (this.f_96544_ - 300) / 2;
        this.itemPopupCloseButton.x = popupX + 220 - 22;
        this.itemPopupCloseButton.y = popupY + 4;
        graphics.m_280168_().m_85836_();
        float scale = 0.8f + easedProgress * 0.2f;
        int centerX = popupX + 110;
        int centerY = popupY + 150;
        graphics.m_280168_().m_252880_((float)centerX, (float)centerY, 300.0f);
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        graphics.m_280168_().m_252880_((float)(-centerX), (float)(-centerY), 0.0f);
        int alpha = (int)(easedProgress * 255.0f);
        int bgAlpha = (int)(easedProgress * 240.0f);
        int bgColor = bgAlpha << 24 | this.colors.bgBase & 0xFFFFFF;
        graphics.m_280509_(popupX, popupY, popupX + 220, popupY + 300, bgColor);
        int borderColor = this.applyAlpha(this.colors.borderAccent, alpha);
        this.renderBoxBorder(graphics, popupX, popupY, 220, 300, borderColor);
        if (this.selectedItem != null) {
            this.renderItemPopupContent(graphics, popupX, popupY, easedProgress);
        }
        this.renderCustomButton(graphics, this.itemPopupCloseButton, mouseX, mouseY, -48060, easedProgress);
        graphics.m_280168_().m_85849_();
    }

    private void renderItemPopupContent(GuiGraphics graphics, int popupX, int popupY, float alpha) {
        int alphaInt = (int)(alpha * 255.0f);
        int contentX = popupX + 15;
        int contentY = popupY + 15;
        int contentWidth = 190;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        int iconSize = 48;
        int iconX = popupX + (220 - iconSize) / 2;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)iconX, (float)contentY, 0.0f);
        graphics.m_280168_().m_85841_(3.0f, 3.0f, 1.0f);
        graphics.m_280480_(this.selectedItem, 0, 0);
        graphics.m_280168_().m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        Component itemName = this.selectedItem.m_41786_();
        this.drawCenteredString(graphics, itemName, contentY += iconSize + 10, this.applyAlpha(this.colors.titleColor, alphaInt));
        Objects.requireNonNull(this.f_96547_);
        Rarity rarity = this.selectedItem.m_41791_();
        String rarityFormatted = this.formatRarityName(rarity.name());
        MutableComponent rarityText = Component.m_237115_((String)"gui.traveloptics.boss_screen.item_popup.rarity").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)rarityFormatted));
        this.drawCenteredString(graphics, (Component)rarityText, contentY += 9 + 4, this.applyAlpha(this.colors.subtitleColor, alphaInt));
        Objects.requireNonNull(this.f_96547_);
        this.renderCenteredDecorativeDivider(graphics, contentX, contentY += 9 + 10, contentWidth, alphaInt);
        MutableComponent tooltipLabel = Component.m_237115_((String)"gui.traveloptics.boss_screen.item_popup.description").m_130940_(ChatFormatting.UNDERLINE);
        this.drawCenteredString(graphics, (Component)tooltipLabel, contentY += 14, this.applyAlpha(this.colors.borderHighlight, alphaInt));
        Objects.requireNonNull(this.f_96547_);
        int tooltipStartY = contentY += 9 + 6;
        int tooltipViewportHeight = 110;
        List tooltip = this.selectedItem.m_41651_((Player)this.f_96541_.f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_);
        ArrayList<Object> processedTooltip = new ArrayList<Object>();
        for (int i = 1; i < tooltip.size(); ++i) {
            Component line = (Component)tooltip.get(i);
            String plainText = line.getString();
            if (this.f_96547_.m_92895_(plainText) <= contentWidth) {
                processedTooltip.add(line);
                continue;
            }
            for (String wrappedLine : this.wrapText(plainText, this.f_96547_, contentWidth)) {
                processedTooltip.add(Component.m_237113_((String)wrappedLine).m_130948_(line.m_7383_()));
            }
        }
        int n = processedTooltip.size();
        Objects.requireNonNull(this.f_96547_);
        int tooltipContentHeight = n * 9;
        this.itemTooltipMaxScroll = Math.max(0, tooltipContentHeight - tooltipViewportHeight);
        this.enableScissor(contentX, tooltipStartY, contentWidth, tooltipViewportHeight);
        int tooltipY = tooltipStartY - (int)this.itemTooltipScroll;
        for (Component component : processedTooltip) {
            graphics.m_280614_(this.f_96547_, component, contentX, tooltipY, this.applyAlpha(-1, alphaInt), false);
            Objects.requireNonNull(this.f_96547_);
            tooltipY += 9;
        }
        this.disableScissor();
        if (this.itemTooltipMaxScroll > 0.0f) {
            this.renderItemTooltipScrollbar(graphics, popupX + 220 - 22, tooltipStartY, tooltipViewportHeight, alphaInt);
        }
        contentY = tooltipStartY + tooltipViewportHeight + 10;
        MutableComponent note = Component.m_237115_((String)"gui.traveloptics.boss_screen.item_popup.modpack_note").m_130940_(ChatFormatting.ITALIC);
        for (String line : this.wrapText(note.getString(), this.f_96547_, contentWidth)) {
            graphics.m_280056_(this.f_96547_, line, contentX, contentY, this.applyAlpha(this.colors.subtitleColor, (int)((float)alphaInt * 0.7f)), false);
            Objects.requireNonNull(this.f_96547_);
            contentY += 9;
        }
    }

    private void renderItemTooltipScrollbar(GuiGraphics graphics, int x, int y, int height, int alphaInt) {
        if (this.itemTooltipMaxScroll <= 0.0f) {
            return;
        }
        int scrollbarWidth = 4;
        int scrollbarX = x + 4;
        graphics.m_280509_(scrollbarX, y, scrollbarX + scrollbarWidth, y + height, this.applyAlpha(0x60000000, alphaInt));
        float visibleRatio = 110.0f / (110.0f + this.itemTooltipMaxScroll);
        int thumbHeight = Math.max(10, (int)((float)height * visibleRatio));
        float scrollRatio = this.itemTooltipScroll / this.itemTooltipMaxScroll;
        int thumbY = y + (int)((float)(height - thumbHeight) * scrollRatio);
        graphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, this.applyAlpha(this.colors.borderAccent, alphaInt));
    }

    private String formatRarityName(String rarityName) {
        if (rarityName.contains(":")) {
            rarityName = rarityName.substring(rarityName.lastIndexOf(":") + 1);
        }
        StringBuilder formatted = new StringBuilder();
        String[] words = rarityName.toLowerCase().split("_");
        for (int i = 0; i < words.length; ++i) {
            String word;
            if (i > 0) {
                formatted.append(" ");
            }
            if ((word = words[i]).isEmpty()) continue;
            formatted.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() <= 1) continue;
            formatted.append(word.substring(1));
        }
        return formatted.toString();
    }

    private void renderStaticGlowText(GuiGraphics graphics, Font font, Component text, int x, int y, int baseColor, float intensity) {
        int rgb = baseColor & 0xFFFFFF;
        int glowAlpha = (int)(intensity * 80.0f);
        for (int i = 2; i >= 1; --i) {
            int layerAlpha = glowAlpha / i;
            int layerColor = layerAlpha << 24 | rgb;
            graphics.m_280614_(font, text, x - i, y - i, layerColor, false);
            graphics.m_280614_(font, text, x + i, y - i, layerColor, false);
            graphics.m_280614_(font, text, x - i, y + i, layerColor, false);
            graphics.m_280614_(font, text, x + i, y + i, layerColor, false);
        }
        graphics.m_280614_(font, text, x, y, baseColor, false);
    }

    private void renderAnimatedGlowText(GuiGraphics graphics, Font font, Component text, int x, int y, int baseColor, float intensity) {
        int rgb = baseColor & 0xFFFFFF;
        float pulse = Mth.m_14031_((float)(this.animationTime * 2.0f)) * 0.5f + 0.5f;
        int glowAlpha = (int)(intensity * pulse * 70.0f) + 30;
        int glowColor = glowAlpha << 24 | rgb;
        graphics.m_280614_(font, text, x - 1, y - 1, glowColor, false);
        graphics.m_280614_(font, text, x + 1, y - 1, glowColor, false);
        graphics.m_280614_(font, text, x - 1, y + 1, glowColor, false);
        graphics.m_280614_(font, text, x + 1, y + 1, glowColor, false);
        graphics.m_280614_(font, text, x, y, baseColor, false);
    }

    private void renderDecorativeDivider(GuiGraphics graphics, int x, int y, int width, int alphaInt) {
        int lineY = y + 3;
        this.renderDiamond(graphics, x, lineY, 2, this.applyAlpha(this.colors.borderHighlight, alphaInt));
        int markerX = x + 6;
        graphics.m_280509_(markerX, lineY - 1, markerX + 3, lineY + 2, this.applyAlpha(this.colors.borderAccent, alphaInt));
        int lineStart = markerX + 6;
        int lineLength = (int)((float)width * 0.5f);
        for (int i = 0; i < lineLength; ++i) {
            float progress = (float)i / (float)lineLength;
            int alpha = (int)((float)alphaInt * (1.0f - progress * 0.6f));
            graphics.m_280509_(lineStart + i, lineY, lineStart + i + 1, lineY + 1, this.applyAlpha(this.colors.borderAccent, alpha));
        }
        int endX = lineStart + lineLength + 3;
        this.renderDiamond(graphics, endX, lineY, 2, this.applyAlpha(this.colors.borderAccent, alphaInt / 2));
        int dashX = endX + 5;
        graphics.m_280509_(dashX, lineY, dashX + 3, lineY + 1, this.applyAlpha(this.colors.borderAccent, alphaInt / 3));
    }

    private void renderCenteredDecorativeDivider(GuiGraphics graphics, int x, int y, int width, int alphaInt) {
        int centerX = x + width / 2;
        int lineY = y + 3;
        int lineLength = (int)((float)width * 0.35f);
        this.renderDiamond(graphics, centerX, lineY, 2, this.applyAlpha(this.colors.borderHighlight, alphaInt));
        int smallDiamondOffset = 6;
        this.renderDiamond(graphics, centerX - smallDiamondOffset, lineY, 1, this.applyAlpha(this.colors.borderAccent, (int)((float)alphaInt * 0.8f)));
        this.renderDiamond(graphics, centerX + smallDiamondOffset, lineY, 1, this.applyAlpha(this.colors.borderAccent, (int)((float)alphaInt * 0.8f)));
        int leftLineStart = centerX - smallDiamondOffset - 4;
        int leftLineEnd = centerX - lineLength;
        for (int i = 0; i < leftLineStart - leftLineEnd; ++i) {
            float progress = (float)i / (float)(leftLineStart - leftLineEnd);
            int alpha = (int)((float)alphaInt * (1.0f - progress * 0.5f));
            graphics.m_280509_(leftLineStart - i, lineY, leftLineStart - i + 1, lineY + 1, this.applyAlpha(this.colors.borderAccent, alpha));
        }
        int rightLineStart = centerX + smallDiamondOffset + 4;
        int rightLineEnd = centerX + lineLength;
        for (int i = 0; i < rightLineEnd - rightLineStart; ++i) {
            float progress = (float)i / (float)(rightLineEnd - rightLineStart);
            int alpha = (int)((float)alphaInt * (1.0f - progress * 0.5f));
            graphics.m_280509_(rightLineStart + i, lineY, rightLineStart + i + 1, lineY + 1, this.applyAlpha(this.colors.borderAccent, alpha));
        }
        this.renderDiamond(graphics, leftLineEnd, lineY, 2, this.applyAlpha(this.colors.borderHighlight, (int)((float)alphaInt * 0.6f)));
        this.renderDiamond(graphics, rightLineEnd, lineY, 2, this.applyAlpha(this.colors.borderHighlight, (int)((float)alphaInt * 0.6f)));
        graphics.m_280509_(leftLineEnd - 6, lineY, leftLineEnd - 3, lineY + 1, this.applyAlpha(this.colors.borderAccent, alphaInt / 3));
        graphics.m_280509_(rightLineEnd + 3, lineY, rightLineEnd + 6, lineY + 1, this.applyAlpha(this.colors.borderAccent, alphaInt / 3));
    }

    private void renderSpoilerDividerWithLabel(GuiGraphics graphics, int x, int y, int width, Component label, int alphaInt) {
        int lineY = y + 3;
        int diamondX = x + 3;
        this.renderDiamond(graphics, diamondX, lineY, 2, this.applyAlpha(this.colors.borderHighlight, alphaInt));
        int markerX = diamondX + 6;
        graphics.m_280509_(markerX, lineY - 1, markerX + 3, lineY + 2, this.applyAlpha(this.colors.borderAccent, alphaInt));
        int lineStart = markerX + 6;
        int shortLineLength = 8;
        for (int i = 0; i < shortLineLength; ++i) {
            graphics.m_280509_(lineStart + i, lineY, lineStart + i + 1, lineY + 1, this.applyAlpha(this.colors.borderAccent, alphaInt));
        }
        int textX = lineStart + shortLineLength + 6;
        Objects.requireNonNull(this.f_96547_);
        int textY = lineY - 9 / 2 + 1;
        graphics.m_280614_(this.f_96547_, label, textX, textY, this.applyAlpha(this.colors.subtitleColor, alphaInt), false);
        int textWidth = this.f_96547_.m_92852_((FormattedText)label);
        int lineAfterTextStart = textX + textWidth + 6;
        int remainingWidth = x + width - lineAfterTextStart - 15;
        for (int i = 0; i < remainingWidth; ++i) {
            float progress = (float)i / (float)remainingWidth;
            int alpha = (int)((float)alphaInt * (1.0f - progress * 0.6f));
            graphics.m_280509_(lineAfterTextStart + i, lineY, lineAfterTextStart + i + 1, lineY + 1, this.applyAlpha(this.colors.borderAccent, alpha));
        }
        int endX = lineAfterTextStart + remainingWidth + 3;
        this.renderDiamond(graphics, endX, lineY, 2, this.applyAlpha(this.colors.borderAccent, alphaInt / 2));
        int dashX = endX + 5;
        graphics.m_280509_(dashX, lineY, dashX + 3, lineY + 1, this.applyAlpha(this.colors.borderAccent, alphaInt / 3));
    }

    private void renderDiamond(GuiGraphics graphics, int centerX, int centerY, int size, int color) {
        int width;
        int row;
        for (row = 0; row <= size; ++row) {
            width = row;
            graphics.m_280509_(centerX - width, centerY - size + row, centerX + width + 1, centerY - size + row + 1, color);
        }
        for (row = 1; row <= size; ++row) {
            width = size - row;
            graphics.m_280509_(centerX - width, centerY + row, centerX + width + 1, centerY + row + 1, color);
        }
    }

    private void renderItemGlowAndCorners(GuiGraphics graphics, int itemX, int itemY, int itemSize, float pulse, int alphaInt) {
        int glowRadius = 20;
        int glowAlpha = (int)((float)alphaInt * pulse * 0.12f);
        for (int r = glowRadius; r > 0; r -= 2) {
            float radiusAlpha = (float)(glowRadius - r) / (float)glowRadius;
            int circleAlpha = (int)((float)glowAlpha * radiusAlpha);
            int circleColor = circleAlpha << 24 | this.colors.borderHighlight & 0xFFFFFF;
            int centerOffset = itemSize / 2;
            graphics.m_280509_(itemX + centerOffset - r, itemY + centerOffset - r, itemX + centerOffset + r, itemY + centerOffset + r, circleColor);
        }
        this.renderItemCorners(graphics, itemX, itemY, itemSize, pulse, alphaInt);
    }

    private void renderItemCorners(GuiGraphics graphics, int itemX, int itemY, int itemSize, float pulse, int alphaInt) {
        int cornerSize = 3;
        int cornerOffset = 2;
        int cornerAlpha = (int)((float)alphaInt * pulse * 0.5f);
        int cornerColor = this.applyAlpha(this.colors.borderHighlight, cornerAlpha);
        graphics.m_280509_(itemX - cornerOffset, itemY - cornerOffset, itemX - cornerOffset + cornerSize, itemY - cornerOffset + 1, cornerColor);
        graphics.m_280509_(itemX - cornerOffset, itemY - cornerOffset, itemX - cornerOffset + 1, itemY - cornerOffset + cornerSize, cornerColor);
        graphics.m_280509_(itemX + itemSize + cornerOffset - cornerSize, itemY - cornerOffset, itemX + itemSize + cornerOffset, itemY - cornerOffset + 1, cornerColor);
        graphics.m_280509_(itemX + itemSize + cornerOffset - 1, itemY - cornerOffset, itemX + itemSize + cornerOffset, itemY - cornerOffset + cornerSize, cornerColor);
        graphics.m_280509_(itemX - cornerOffset, itemY + itemSize + cornerOffset - 1, itemX - cornerOffset + cornerSize, itemY + itemSize + cornerOffset, cornerColor);
        graphics.m_280509_(itemX - cornerOffset, itemY + itemSize + cornerOffset - cornerSize, itemX - cornerOffset + 1, itemY + itemSize + cornerOffset, cornerColor);
        graphics.m_280509_(itemX + itemSize + cornerOffset - cornerSize, itemY + itemSize + cornerOffset - 1, itemX + itemSize + cornerOffset, itemY + itemSize + cornerOffset, cornerColor);
        graphics.m_280509_(itemX + itemSize + cornerOffset - 1, itemY + itemSize + cornerOffset - cornerSize, itemX + itemSize + cornerOffset, itemY + itemSize + cornerOffset, cornerColor);
    }

    private void renderRarityGlow(GuiGraphics graphics, int itemX, int itemY, int itemSize, float pulse, BossScreenData.RewardRarity rarity, int alphaInt) {
        int glowRadius = 20;
        int glowColor = rarity.getGlowColor();
        int glowAlpha = (int)((float)alphaInt * pulse * 0.15f);
        for (int r = glowRadius; r > 0; r -= 2) {
            float radiusAlpha = (float)(glowRadius - r) / (float)glowRadius;
            int circleAlpha = (int)((float)glowAlpha * radiusAlpha);
            int finalColor = circleAlpha << 24 | glowColor & 0xFFFFFF;
            int centerOffset = itemSize / 2;
            graphics.m_280509_(itemX + centerOffset - r, itemY + centerOffset - r, itemX + centerOffset + r, itemY + centerOffset + r, finalColor);
        }
    }

    private void renderRarityCorners(GuiGraphics graphics, int itemX, int itemY, int itemSize, float pulse, BossScreenData.RewardRarity rarity, int alphaInt) {
        int frameColor = rarity.getFrameColor();
        int cornerSize = 3;
        int cornerOffset = 2;
        int cornerAlpha = (int)((float)alphaInt * pulse * 0.5f);
        int finalColor = this.applyAlpha(frameColor, cornerAlpha);
        graphics.m_280509_(itemX - cornerOffset, itemY - cornerOffset, itemX - cornerOffset + cornerSize, itemY - cornerOffset + 1, finalColor);
        graphics.m_280509_(itemX - cornerOffset, itemY - cornerOffset, itemX - cornerOffset + 1, itemY - cornerOffset + cornerSize, finalColor);
        graphics.m_280509_(itemX + itemSize + cornerOffset - cornerSize, itemY - cornerOffset, itemX + itemSize + cornerOffset, itemY - cornerOffset + 1, finalColor);
        graphics.m_280509_(itemX + itemSize + cornerOffset - 1, itemY - cornerOffset, itemX + itemSize + cornerOffset, itemY - cornerOffset + cornerSize, finalColor);
        graphics.m_280509_(itemX - cornerOffset, itemY + itemSize + cornerOffset - 1, itemX - cornerOffset + cornerSize, itemY + itemSize + cornerOffset, finalColor);
        graphics.m_280509_(itemX - cornerOffset, itemY + itemSize + cornerOffset - cornerSize, itemX - cornerOffset + 1, itemY + itemSize + cornerOffset, finalColor);
        graphics.m_280509_(itemX + itemSize + cornerOffset - cornerSize, itemY + itemSize + cornerOffset - 1, itemX + itemSize + cornerOffset, itemY + itemSize + cornerOffset, finalColor);
        graphics.m_280509_(itemX + itemSize + cornerOffset - 1, itemY + itemSize + cornerOffset - cornerSize, itemX + itemSize + cornerOffset, itemY + itemSize + cornerOffset, finalColor);
    }

    private void renderScreenBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280509_(x, y, x + width, y + height, this.colors.bgDark);
        this.fillGradient(graphics, x, y, x + width, y + height / 2, this.colors.bgBase, this.colors.bgDark);
    }

    private void renderFadedDetailsBackground(GuiGraphics graphics, int x, int y, int width, int height, float alpha) {
        int alphaInt = (int)(alpha * 255.0f);
        graphics.m_280509_(x, y, x + width, y + height, this.applyAlpha(this.colors.bgDark, alphaInt));
        this.fillGradient(graphics, x, y, x + width, y + height / 2, this.applyAlpha(this.colors.bgBase, alphaInt), this.applyAlpha(this.colors.bgDark, alphaInt));
        int accentColor = this.applyAlpha(this.colors.borderHighlight, alphaInt);
        graphics.m_280509_(x, y, x + width, y + 1, accentColor);
        graphics.m_280509_(x, y + height - 1, x + width, y + height, accentColor);
    }

    private void renderElegantBorders(GuiGraphics graphics, int x, int y, int width, int height, float animProgress) {
        int accentColor = this.colors.borderHighlight;
        graphics.m_280509_(x, y, x + width, y + 1, accentColor);
        graphics.m_280509_(x, y + height - 1, x + width, y + height, accentColor);
    }

    private void renderBossImage(GuiGraphics graphics, int x, int y, int displayWidth, int displayHeight, float alpha) {
        if (this.bossData.getBossImageLocation() == null) {
            return;
        }
        graphics.m_280168_().m_85836_();
        float scaleX = (float)displayWidth / (float)this.bossData.getBossImageWidth();
        float scaleY = (float)displayHeight / (float)this.bossData.getBossImageHeight();
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        graphics.m_280168_().m_85841_(scaleX, scaleY, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.bossData.getBossImageLocation());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        graphics.m_280163_(this.bossData.getBossImageLocation(), 0, 0, 0.0f, 0.0f, this.bossData.getBossImageWidth(), this.bossData.getBossImageHeight(), this.bossData.getBossImageWidth(), this.bossData.getBossImageHeight());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        graphics.m_280168_().m_85849_();
    }

    private void renderScrollbar(GuiGraphics graphics, int x, int y, int height) {
        if (this.maxScroll <= 0.0f) {
            return;
        }
        int scrollbarWidth = 6;
        graphics.m_280509_(x, y, x + scrollbarWidth, y + height, 0x60000000);
        float visibleRatio = (float)this.viewportHeight / (float)this.contentHeight;
        int thumbHeight = Math.max(20, (int)((float)height * visibleRatio));
        float scrollRatio = this.scrollOffset / this.maxScroll;
        int thumbY = y + (int)((float)(height - thumbHeight) * scrollRatio);
        graphics.m_280509_(x, thumbY, x + scrollbarWidth, thumbY + thumbHeight, this.colors.borderAccent);
        graphics.m_280509_(x + 1, thumbY + 1, x + scrollbarWidth - 1, thumbY + thumbHeight - 1, this.colors.borderHighlight);
    }

    private void renderLoreScrollbar(GuiGraphics graphics, int x, int y, int height, int alphaInt) {
        if (this.loreMaxScroll <= 0.0f) {
            return;
        }
        int scrollbarWidth = 4;
        graphics.m_280509_(x, y, x + scrollbarWidth, y + height, this.applyAlpha(0x60000000, alphaInt));
        float visibleRatio = (float)this.loreViewportHeight / (float)this.loreContentHeight;
        int thumbHeight = Math.max(10, (int)((float)height * visibleRatio));
        float scrollRatio = this.loreScrollOffset / this.loreMaxScroll;
        int thumbY = y + (int)((float)(height - thumbHeight) * scrollRatio);
        graphics.m_280509_(x, thumbY, x + scrollbarWidth, thumbY + thumbHeight, this.applyAlpha(this.colors.borderAccent, alphaInt));
    }

    private void renderDifficultyBonusScrollbar(GuiGraphics graphics, int x, int y, int height, int alphaInt) {
        if (this.difficultyBonusMaxScroll <= 0.0f) {
            return;
        }
        int scrollbarWidth = 4;
        graphics.m_280509_(x, y, x + scrollbarWidth, y + height, this.applyAlpha(0x60000000, alphaInt));
        int contentHeight = (int)((float)height / ((float)height + this.difficultyBonusMaxScroll) * ((float)height + this.difficultyBonusMaxScroll));
        float visibleRatio = (float)height / (float)contentHeight;
        int thumbHeight = Math.max(20, (int)((float)height * visibleRatio));
        float scrollRatio = this.difficultyBonusScrollOffset / this.difficultyBonusMaxScroll;
        int thumbY = y + (int)((float)(height - thumbHeight) * scrollRatio);
        graphics.m_280509_(x, thumbY, x + scrollbarWidth, thumbY + thumbHeight, this.applyAlpha(this.colors.borderAccent, alphaInt));
        graphics.m_280509_(x + 1, thumbY + 1, x + scrollbarWidth - 1, thumbY + thumbHeight - 1, this.applyAlpha(this.colors.borderHighlight, alphaInt));
    }

    private void renderCustomButton(GuiGraphics graphics, ButtonArea button, int mouseX, int mouseY, int accentColor, float alpha) {
        boolean hovered = button.isHovered(mouseX, mouseY) && this.openAnimProgress >= 1.0f;
        float pulse = (Mth.m_14031_((float)(this.animationTime * 3.0f)) + 1.0f) / 2.0f;
        int alphaInt = (int)(alpha * 255.0f);
        int bgAlpha = hovered ? (int)(170.0f * alpha) : (int)((float)this.getAlpha(this.colors.bgDark) * alpha);
        int bgColor = bgAlpha << 24 | accentColor & 0xFFFFFF;
        if (!hovered) {
            bgColor = this.applyAlpha(this.colors.bgDark, alphaInt);
        }
        int borderColor = this.applyAlpha(hovered ? accentColor : this.colors.borderAccent, alphaInt);
        graphics.m_280509_(button.x, button.y, button.x + button.width, button.y + button.height, bgColor);
        this.renderBoxBorder(graphics, button.x, button.y, button.width, button.height, borderColor);
        MutableComponent text = button.label.equals("\u00d7") ? Component.m_237113_((String)button.label) : Component.m_237115_((String)button.label);
        int textWidth = this.f_96547_.m_92852_((FormattedText)text);
        int textX = button.x + (button.width - textWidth) / 2;
        int n = button.y;
        int n2 = button.height;
        Objects.requireNonNull(this.f_96547_);
        int textY = n + (n2 - 9) / 2;
        int textColor = this.applyAlpha(hovered ? -1 : this.colors.textColor, alphaInt);
        graphics.m_280614_(this.f_96547_, (Component)text, textX, textY, textColor, false);
        if (hovered) {
            int glowAlpha = (int)((50.0f + pulse * 50.0f) * alpha);
            int glowColor = glowAlpha << 24 | accentColor & 0xFFFFFF;
            graphics.m_280509_(button.x, button.y, button.x + button.width, button.y + button.height, glowColor);
        }
    }

    private void updateMainPageButtons(int screenX, int screenY, int currentWidth) {
        int buttonY = screenY + 260 - 18 - 23;
        this.startBattleButton.x = screenX + currentWidth - 18 - this.startBattleButton.width;
        this.startBattleButton.y = buttonY;
        this.detailsButton.x = this.startBattleButton.x - this.detailsButton.width - 10;
        this.detailsButton.y = buttonY;
        this.closeButton.x = screenX + currentWidth - 18 - 20;
        this.closeButton.y = screenY + 18;
    }

    private void updateDetailsPageButtons(int screenX, int screenY, int fullWidth) {
        int buttonY = screenY + 260 - 18 - 26;
        this.backButton.x = screenX + 18;
        this.backButton.y = buttonY;
        this.closeButton.x = screenX + fullWidth - 18 - 20;
        this.closeButton.y = screenY + 18;
    }

    private void updateRewardsPanelButtons(int screenX, int screenY, int fullWidth) {
        int buttonY = screenY + 260 - 18 - 26;
        this.rewardsBackButton.x = screenX + 18;
        this.rewardsBackButton.y = buttonY;
        this.closeButton.x = screenX + fullWidth - 18 - 20;
        this.closeButton.y = screenY + 18;
    }

    private void renderBoxBorder(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.m_280509_(x - 1, y - 1, x + width + 1, y, color);
        graphics.m_280509_(x - 1, y + height, x + width + 1, y + height + 1, color);
        graphics.m_280509_(x - 1, y, x, y + height, color);
        graphics.m_280509_(x + width, y, x + width + 1, y + height, color);
    }

    private float easeOutCubic(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 3.0);
    }

    private int applyAlpha(int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    private int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    private List<String> wrapText(String text, Font font, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.isEmpty() ? word : String.valueOf(currentLine) + " " + word;
            if (font.m_92895_(testLine) <= maxWidth) {
                if (!currentLine.isEmpty()) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (!currentLine.isEmpty()) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    protected void fillGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_193479_(colorFrom).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_193479_(colorFrom).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_193479_(colorTo).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_193479_(colorTo).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    private void enableScissor(int x, int y, int width, int height) {
        double scale = this.f_96541_.m_91268_().m_85449_();
        int scissorX = (int)((double)x * scale);
        int scissorY = (int)((double)this.f_96541_.m_91268_().m_85442_() - (double)(y + height) * scale);
        int scissorWidth = (int)((double)width * scale);
        int scissorHeight = (int)((double)height * scale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
    }

    private void disableScissor() {
        RenderSystem.disableScissor();
    }

    private void drawCenteredString(GuiGraphics graphics, Component text, int y, int color) {
        int textWidth = this.f_96547_.m_92852_((FormattedText)text);
        int x = (this.f_96543_ - textWidth) / 2;
        graphics.m_280614_(this.f_96547_, text, x, y, color, false);
    }

    private void drawCenteredScaledText(GuiGraphics graphics, Component text, float scale, int y, int color, boolean animated) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        int scaledWidth = this.f_96547_.m_92852_((FormattedText)text);
        int x = (int)(((float)this.f_96543_ - (float)scaledWidth * scale) / 2.0f / scale);
        if (animated) {
            this.renderAnimatedGlowText(graphics, this.f_96547_, text, x, (int)((float)y / scale), color, 0.6f);
        } else {
            graphics.m_280614_(this.f_96547_, text, x, (int)((float)y / scale), color, false);
        }
        graphics.m_280168_().m_85849_();
    }

    private void renderQuantityText(GuiGraphics graphics, String text, int itemX, int itemY, int itemSize, int alphaInt) {
        int textWidth = this.f_96547_.m_92895_(text);
        int x = itemX + itemSize - textWidth - 2;
        Objects.requireNonNull(this.f_96547_);
        int y = itemY + itemSize - 9 + 2;
        graphics.m_280056_(this.f_96547_, text, x + 1, y + 1, this.applyAlpha(-16777216, alphaInt), false);
        graphics.m_280056_(this.f_96547_, text, x, y, this.applyAlpha(-1, alphaInt), false);
    }

    private boolean isMouseOverLoreArea(double mouseX, double mouseY) {
        int screenY = (this.f_96544_ - 260) / 2;
        int currentWidth = (int)((float)this.f_96543_ * this.easeOutCubic(this.openAnimProgress));
        int screenX = (this.f_96543_ - currentWidth) / 2;
        int contentX = screenX + 18 + 280 + 90;
        int loreStartY = screenY + 18 + 10;
        Objects.requireNonNull(this.f_96547_);
        loreStartY += (int)(9.0f * 1.8f) + 6;
        Objects.requireNonNull(this.f_96547_);
        loreStartY += 9 + 8;
        loreStartY += 14;
        Objects.requireNonNull(this.f_96547_);
        int contentWidth = currentWidth - 280 - 90 - 36 - 20;
        int graceArea = 10;
        return mouseX >= (double)(contentX - graceArea) && mouseX <= (double)(contentX + contentWidth + graceArea) && mouseY >= (double)((loreStartY += 9 + 4) - graceArea) && mouseY <= (double)(loreStartY + this.loreViewportHeight + graceArea);
    }

    private void playClickSound() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_6330_((SoundEvent)SoundEvents.f_12490_.get(), SoundSource.MASTER, 0.3f, 1.0f);
        }
    }

    private static class SpoilerClickArea {
        int x;
        int y;
        int width;
        int height;

        SpoilerClickArea(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }
    }

    private static class ButtonArea {
        int x;
        int y;
        int width;
        int height;
        String label;

        ButtonArea(int x, int y, int width, int height, String label) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.label = label;
        }

        boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }
    }

    private static class ItemClickArea {
        int x;
        int y;
        int width;
        int height;
        ItemStack item;

        ItemClickArea(int x, int y, int width, int height, ItemStack item) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.item = item;
        }

        boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }
    }
}

