/*
 * Decompiled with CFR 0.152.
 */
package smartin.arsenal;

import dev.architectury.event.EventResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.properties.ItemIdProperty;
import smartin.miapi.registries.RegistryInventory;

public class GenerateModularConverters {
    public Map<Item, Converter> modularItem = new HashMap<Item, Converter>();

    public GenerateModularConverters() {
        ReloadEvents.START.subscribe(isClient -> this.modularItem.clear());
        ModularItemStackConverter.converters.add(stack -> {
            if (this.modularItem.containsKey(stack.m_41720_())) {
                return ItemIdProperty.changeId((ItemStack)this.modularItem.get(stack.m_41720_()).convert(stack));
            }
            return stack;
        });
        MiapiEvents.GENERATE_MATERIAL_CONVERTERS.register((material, tools, isClient) -> {
            Optional<Item> swordItem = tools.stream().filter(SwordItem.class::isInstance).findFirst();
            Optional<Item> axeItem = tools.stream().filter(AxeItem.class::isInstance).findFirst();
            Optional<Item> pickAxeItem = tools.stream().filter(PickaxeItem.class::isInstance).findFirst();
            Optional<Item> shovelItem = tools.stream().filter(ShovelItem.class::isInstance).findFirst();
            Optional<Item> hoeItem = tools.stream().filter(HoeItem.class::isInstance).findFirst();
            swordItem.ifPresent(item -> this.addSwordItem(material, (Item)item));
            axeItem.ifPresent(item -> this.addAxeItem(material, (Item)item));
            pickAxeItem.ifPresent(item -> this.addPickAxeItem(material, (Item)item));
            shovelItem.ifPresent(item -> this.addShovelItem(material, (Item)item));
            hoeItem.ifPresent(item -> this.addHoeItem(material, (Item)item));
            return EventResult.pass();
        });
    }

    protected void addSwordItem(Material material, Item item) {
        this.modularItem.put(item, stack -> {
            ItemStack modularItem = new ItemStack((ItemLike)RegistryInventory.modularItem);
            String swordData = "{\n" + "        \"module\": \"handle_normal\",\n" + "        \"moduleData\": {\n" + "            \"properties\": \"{\\\"material\\\":\\\"wood\\\"}\"\n" + "        },\n" + "        \"subModules\": {\n" + "            \"0\": {\n" + "                \"module\": \"guard_normal\",\n" + "                \"moduleData\": {\n" + "                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n" + "                },\n" + "                \"subModules\": {\n" + "                    \"0\": {\n" + "                        \"module\": \"blade_sword\",\n" + "                        \"moduleData\": {\n" + "                            \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n" + "                        },\n" + "                        \"subModules\": {}\n" + "                    }\n" + "                }\n" + "            },\n" + "            \"1\": {\n" + "                \"module\": \"pommel_round\",\n" + "                \"moduleData\": {\n" + "                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n" + "                },\n" + "                \"subModules\": {}\n" + "            }\n" + "        }\n" + "    }";
            swordData = swordData.replaceAll("gold", material.getKey());
            modularItem.m_41784_().m_128391_(stack.m_41784_());
            ItemModule.ModuleInstance moduleInstance = ItemModule.ModuleInstance.fromString((String)swordData);
            moduleInstance.getRoot().writeToItem(modularItem);
            return modularItem;
        });
    }

    protected void addAxeItem(Material material, Item item) {
        this.modularItem.put(item, stack -> {
            ItemStack modularItem = new ItemStack((ItemLike)RegistryInventory.modularItem);
            String swordData = "{\n        \"module\": \"handle_tool\",\n        \"moduleData\": {\n            \"properties\": \"{\\\"material\\\":\\\"wood\\\"}\"\n        },\n        \"subModules\": {\n            \"0\": {\n                \"module\": \"axe_front\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {\n                    \"0\": {\n                        \"module\": \"tool_back\",\n                        \"moduleData\": {\n                            \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                        },\n                        \"subModules\": {}\n                    }\n                }\n            }\n        }\n    }";
            swordData = swordData.replaceAll("gold", material.getKey());
            modularItem.m_41784_().m_128391_(stack.m_41784_());
            ItemModule.ModuleInstance moduleInstance = ItemModule.ModuleInstance.fromString((String)swordData);
            moduleInstance.getRoot().writeToItem(modularItem);
            return modularItem;
        });
    }

    protected void addPickAxeItem(Material material, Item item) {
        this.modularItem.put(item, stack -> {
            ItemStack modularItem = new ItemStack((ItemLike)RegistryInventory.modularItem);
            String swordData = "{\n        \"module\": \"handle_tool\",\n        \"moduleData\": {\n            \"properties\": \"{\\\"material\\\":\\\"wood\\\"}\"\n        },\n        \"subModules\": {\n            \"0\": {\n                \"module\": \"pickaxe_front\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {\n                    \"0\": {\n                        \"module\": \"pickaxe_back\",\n                        \"moduleData\": {\n                            \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                        },\n                        \"subModules\": {}\n                    }\n                }\n            }\n        }\n    }";
            swordData = swordData.replaceAll("gold", material.getKey());
            modularItem.m_41784_().m_128391_(stack.m_41784_());
            ItemModule.ModuleInstance moduleInstance = ItemModule.ModuleInstance.fromString((String)swordData);
            moduleInstance.getRoot().writeToItem(modularItem);
            return modularItem;
        });
    }

    protected void addShovelItem(Material material, Item item) {
        this.modularItem.put(item, stack -> {
            ItemStack modularItem = new ItemStack((ItemLike)RegistryInventory.modularItem);
            String swordData = "{\n        \"module\": \"handle_tool\",\n        \"moduleData\": {\n            \"properties\": \"{\\\"material\\\":\\\"wood\\\"}\"\n        },\n        \"subModules\": {\n            \"0\": {\n                \"module\": \"shovel\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {}\n            }\n        }\n    }";
            swordData = swordData.replaceAll("gold", material.getKey());
            modularItem.m_41784_().m_128391_(stack.m_41784_());
            ItemModule.ModuleInstance moduleInstance = ItemModule.ModuleInstance.fromString((String)swordData);
            moduleInstance.getRoot().writeToItem(modularItem);
            return modularItem;
        });
    }

    protected void addHoeItem(Material material, Item item) {
        this.modularItem.put(item, stack -> {
            ItemStack modularItem = new ItemStack((ItemLike)RegistryInventory.modularItem);
            String swordData = "{\n        \"module\": \"handle_tool\",\n        \"moduleData\": {\n            \"properties\": \"{\\\"material\\\":\\\"wood\\\"}\"\n        },\n        \"subModules\": {\n            \"0\": {\n                \"module\": \"hoe_front\",\n                \"moduleData\": {\n                    \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                },\n                \"subModules\": {\n                    \"0\": {\n                        \"module\": \"tool_back\",\n                        \"moduleData\": {\n                            \"properties\": \"{\\\"material\\\":\\\"gold\\\"}\"\n                        },\n                        \"subModules\": {}\n                    }\n                }\n            }\n        }\n    }";
            swordData = swordData.replaceAll("gold", material.getKey());
            modularItem.m_41784_().m_128391_(stack.m_41784_());
            ItemModule.ModuleInstance moduleInstance = ItemModule.ModuleInstance.fromString((String)swordData);
            moduleInstance.getRoot().writeToItem(modularItem);
            return modularItem;
        });
    }

    static interface Converter {
        public ItemStack convert(ItemStack var1);
    }
}

