/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers.forge.data;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import pro.mikey.justhammers.HammerItems;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void onDataGen(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGen(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new LangGen(output));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGen(output));
    }

    public static class ItemModelGen
    extends ItemModelProvider {
        public ItemModelGen(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "justhammers", existingFileHelper);
        }

        protected void registerModels() {
            HammerItems.HAMMERS.forEach(this::handHeldItem);
            this.handHeldItem(HammerItems.IMPACT_CORE);
            this.handHeldItem(HammerItems.REINFORCED_CORE);
            this.handHeldItem(HammerItems.REINFORCED_IMPACT_CORE);
            this.handHeldItem(HammerItems.DESTRUCTOR_CORE);
        }

        private void handHeldItem(RegistrySupplier<Item> item) {
            String path = item.getId().m_135815_();
            this.singleTexture(path, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path));
        }
    }

    public static class LangGen
    extends LanguageProvider {
        public LangGen(PackOutput output) {
            super(output, "justhammers", "en_us");
        }

        protected void addTranslations() {
            this.addItem((Supplier)HammerItems.STONE_HAMMER, "Stone Hammer");
            this.addItem((Supplier)HammerItems.IRON_HAMMER, "Iron Hammer");
            this.addItem((Supplier)HammerItems.GOLD_HAMMER, "Gold Hammer");
            this.addItem((Supplier)HammerItems.DIAMOND_HAMMER, "Diamond Hammer");
            this.addItem((Supplier)HammerItems.NETHERITE_HAMMER, "Netherite Hammer");
            this.addItem((Supplier)HammerItems.STONE_IMPACT_HAMMER, "Stone Impact Hammer");
            this.addItem((Supplier)HammerItems.IRON_IMPACT_HAMMER, "Iron Impact Hammer");
            this.addItem((Supplier)HammerItems.GOLD_IMPACT_HAMMER, "Gold Impact Hammer");
            this.addItem((Supplier)HammerItems.DIAMOND_IMPACT_HAMMER, "Diamond Impact Hammer");
            this.addItem((Supplier)HammerItems.NETHERITE_IMPACT_HAMMER, "Netherite Impact Hammer");
            this.addItem((Supplier)HammerItems.STONE_FIVE_HAMMER, "Stone Reinforced Hammer");
            this.addItem((Supplier)HammerItems.IRON_FIVE_HAMMER, "Iron Reinforced Hammer");
            this.addItem((Supplier)HammerItems.GOLD_FIVE_HAMMER, "Gold Reinforced Hammer");
            this.addItem((Supplier)HammerItems.DIAMOND_FIVE_HAMMER, "Diamond Reinforced Hammer");
            this.addItem((Supplier)HammerItems.NETHERITE_FIVE_HAMMER, "Netherite Reinforced Hammer");
            this.addItem((Supplier)HammerItems.STONE_FIVE_IMPACT_HAMMER, "Stone Reinforced Impact Hammer");
            this.addItem((Supplier)HammerItems.IRON_FIVE_IMPACT_HAMMER, "Iron Reinforced Impact Hammer");
            this.addItem((Supplier)HammerItems.GOLD_FIVE_IMPACT_HAMMER, "Gold Reinforced Impact Hammer");
            this.addItem((Supplier)HammerItems.DIAMOND_FIVE_IMPACT_HAMMER, "Diamond Reinforced Impact Hammer");
            this.addItem((Supplier)HammerItems.NETHERITE_FIVE_IMPACT_HAMMER, "Netherite Reinforced Impact Hammer");
            this.addItem((Supplier)HammerItems.STONE_FIVE_DESTROY_HAMMER, "Stone Destructor Hammer");
            this.addItem((Supplier)HammerItems.IRON_FIVE_DESTROY_HAMMER, "Iron Destructor Hammer");
            this.addItem((Supplier)HammerItems.GOLD_FIVE_DESTROY_HAMMER, "Gold Destructor Hammer");
            this.addItem((Supplier)HammerItems.DIAMOND_FIVE_DESTROY_HAMMER, "Diamond Destructor Hammer");
            this.addItem((Supplier)HammerItems.NETHERITE_FIVE_DESTROY_HAMMER, "Netherite Destructor Hammer");
            this.addItem((Supplier)HammerItems.IMPACT_CORE, "Impact Core");
            this.addItem((Supplier)HammerItems.REINFORCED_CORE, "Reinforced Core");
            this.addItem((Supplier)HammerItems.REINFORCED_IMPACT_CORE, "Reinforced Impact Core");
            this.addItem((Supplier)HammerItems.DESTRUCTOR_CORE, "Destruction Core");
            this.add("justhammers.tooltip.durability_warning", "Hammer durability nearing 0%!");
            this.add("justhammers.tooltip.size", "Mines a %sx%sx%s area");
            this.add("itemGroup.justhammers.justhammers_tab", "Just Hammers");
        }
    }

    public static class RecipeGen
    extends RecipeProvider {
        public RecipeGen(PackOutput output) {
            super(output);
        }

        protected void m_245200_(Consumer<FinishedRecipe> consumer) {
            this.standardHammer((Supplier<Item>)HammerItems.STONE_HAMMER, (ItemLike)Items.f_41905_).m_176498_(consumer);
            this.standardHammer((Supplier<Item>)HammerItems.IRON_HAMMER, (ItemLike)Items.f_42416_).m_176498_(consumer);
            this.standardHammer((Supplier<Item>)HammerItems.GOLD_HAMMER, (ItemLike)Items.f_42417_).m_176498_(consumer);
            this.standardHammer((Supplier<Item>)HammerItems.DIAMOND_HAMMER, (ItemLike)Items.f_42415_).m_176498_(consumer);
            this.standardHammer((Supplier<Item>)HammerItems.NETHERITE_HAMMER, (ItemLike)Items.f_42418_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.STONE_IMPACT_HAMMER, (Supplier<Item>)HammerItems.IMPACT_CORE, (ItemLike)Items.f_41905_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.IRON_IMPACT_HAMMER, (Supplier<Item>)HammerItems.IMPACT_CORE, (ItemLike)Items.f_41913_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.GOLD_IMPACT_HAMMER, (Supplier<Item>)HammerItems.IMPACT_CORE, (ItemLike)Items.f_41912_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.DIAMOND_IMPACT_HAMMER, (Supplier<Item>)HammerItems.IMPACT_CORE, (ItemLike)Items.f_41959_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.NETHERITE_IMPACT_HAMMER, (Supplier<Item>)HammerItems.IMPACT_CORE, (ItemLike)Items.f_42791_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.STONE_FIVE_HAMMER, (Supplier<Item>)HammerItems.REINFORCED_CORE, (ItemLike)Items.f_41905_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.IRON_FIVE_HAMMER, (Supplier<Item>)HammerItems.REINFORCED_CORE, (ItemLike)Items.f_41913_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.GOLD_FIVE_HAMMER, (Supplier<Item>)HammerItems.REINFORCED_CORE, (ItemLike)Items.f_41912_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.DIAMOND_FIVE_HAMMER, (Supplier<Item>)HammerItems.REINFORCED_CORE, (ItemLike)Items.f_41959_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.NETHERITE_FIVE_HAMMER, (Supplier<Item>)HammerItems.REINFORCED_CORE, (ItemLike)Items.f_42791_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.STONE_FIVE_IMPACT_HAMMER, (Supplier<Item>)HammerItems.REINFORCED_IMPACT_CORE, (ItemLike)Items.f_41905_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.IRON_FIVE_IMPACT_HAMMER, (Supplier<Item>)HammerItems.REINFORCED_IMPACT_CORE, (ItemLike)Items.f_41913_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.GOLD_FIVE_IMPACT_HAMMER, (Supplier<Item>)HammerItems.REINFORCED_IMPACT_CORE, (ItemLike)Items.f_41912_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.DIAMOND_FIVE_IMPACT_HAMMER, (Supplier<Item>)HammerItems.REINFORCED_IMPACT_CORE, (ItemLike)Items.f_41959_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.NETHERITE_FIVE_IMPACT_HAMMER, (Supplier<Item>)HammerItems.REINFORCED_IMPACT_CORE, (ItemLike)Items.f_42791_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.STONE_FIVE_DESTROY_HAMMER, (Supplier<Item>)HammerItems.DESTRUCTOR_CORE, (ItemLike)Items.f_41905_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.IRON_FIVE_DESTROY_HAMMER, (Supplier<Item>)HammerItems.DESTRUCTOR_CORE, (ItemLike)Items.f_41913_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.GOLD_FIVE_DESTROY_HAMMER, (Supplier<Item>)HammerItems.DESTRUCTOR_CORE, (ItemLike)Items.f_41912_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.DIAMOND_FIVE_DESTROY_HAMMER, (Supplier<Item>)HammerItems.DESTRUCTOR_CORE, (ItemLike)Items.f_41959_).m_176498_(consumer);
            this.coreHammer((Supplier<Item>)HammerItems.NETHERITE_FIVE_DESTROY_HAMMER, (Supplier<Item>)HammerItems.DESTRUCTOR_CORE, (ItemLike)Items.f_42791_).m_176498_(consumer);
            this.core((Supplier<Item>)HammerItems.IMPACT_CORE, Items.f_42451_, (Item)HammerItems.NETHERITE_HAMMER.get(), Items.f_41913_, Items.f_41912_).m_176498_(consumer);
            this.core((Supplier<Item>)HammerItems.REINFORCED_CORE, Items.f_42153_, (Item)HammerItems.IMPACT_CORE.get(), Items.f_41912_, Items.f_41912_).m_176498_(consumer);
            this.core((Supplier<Item>)HammerItems.REINFORCED_IMPACT_CORE, Items.f_42153_, (Item)HammerItems.REINFORCED_CORE.get(), Items.f_41959_, Items.f_41912_).m_176498_(consumer);
            this.core((Supplier<Item>)HammerItems.DESTRUCTOR_CORE, Items.f_42153_, (Item)HammerItems.REINFORCED_IMPACT_CORE.get(), Items.f_41959_, Items.f_41959_).m_176498_(consumer);
        }

        private RecipeBuilder standardHammer(Supplier<Item> hammer, ItemLike material) {
            return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)hammer.get())).m_126127_(Character.valueOf('a'), material).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42398_).m_126130_("aba").m_126130_(" ba").m_126130_(" b ").m_126132_("has_material", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)material));
        }

        private RecipeBuilder coreHammer(Supplier<Item> hammer, Supplier<Item> core, ItemLike material) {
            return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)hammer.get())).m_126127_(Character.valueOf('a'), material).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('c'), (ItemLike)core.get()).m_126130_("aca").m_126130_(" ba").m_126130_(" b ").m_126132_("has_material", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)material));
        }

        private RecipeBuilder core(Supplier<Item> result, Item outside, Item inside, Item left, Item right) {
            return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)result.get())).m_126127_(Character.valueOf('a'), (ItemLike)outside).m_126127_(Character.valueOf('b'), (ItemLike)inside).m_126127_(Character.valueOf('c'), (ItemLike)left).m_126127_(Character.valueOf('d'), (ItemLike)right).m_126130_("aaa").m_126130_("cbd").m_126130_("aaa").m_126132_("has_material", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)((ItemLike)HammerItems.STONE_HAMMER.get())));
        }
    }
}

