/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.client.gui.CheeseStaffScreen;
import com.github.alexthe666.rats.client.gui.PatrolStaffScreen;
import com.github.alexthe666.rats.client.gui.RadiusStaffScreen;
import com.github.alexthe666.rats.registry.RatsCapabilityRegistry;
import com.github.alexthe666.rats.server.capability.SelectedRatCapability;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record ManageRatStaffPacket(int entityId, BlockPos pos, int dirOrd, boolean clear, boolean openGUI, int staffToOpen) {
    public ManageRatStaffPacket(int entityId, BlockPos pos, int dirOrd, boolean clear, boolean openGUI) {
        this(entityId, pos, dirOrd, clear, openGUI, 0);
    }

    public static ManageRatStaffPacket decode(FriendlyByteBuf buf) {
        return new ManageRatStaffPacket(buf.readInt(), buf.m_130135_(), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readInt());
    }

    public static void encode(ManageRatStaffPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityId());
        buf.m_130064_(packet.pos());
        buf.writeInt(packet.dirOrd());
        buf.writeBoolean(packet.clear());
        buf.writeBoolean(packet.openGUI());
        buf.writeInt(packet.staffToOpen());
    }

    public static class Handler {
        public static void handle(final ManageRatStaffPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    if (packet.clear()) {
                        Minecraft.m_91087_().f_91074_.getCapability(RatsCapabilityRegistry.SELECTED_RAT).ifPresent(SelectedRatCapability::clearSelectedRat);
                    } else {
                        Entity e = Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(packet.entityId());
                        if (e instanceof TamedRat) {
                            TamedRat rat = (TamedRat)e;
                            if (packet.openGUI()) {
                                switch (packet.staffToOpen()) {
                                    case 1: {
                                        Minecraft.m_91087_().m_91152_((Screen)new RadiusStaffScreen(rat, packet.pos()));
                                        break;
                                    }
                                    case 2: {
                                        Minecraft.m_91087_().m_91152_((Screen)new PatrolStaffScreen(rat, packet.pos()));
                                        break;
                                    }
                                    default: {
                                        Minecraft.m_91087_().m_91152_((Screen)new CheeseStaffScreen(rat, packet.pos(), Direction.values()[packet.dirOrd()]));
                                    }
                                }
                            }
                        }
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

