/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.projectile.ArrowlikeProjectile;
import com.github.alexthe666.rats.server.entity.projectile.LaserBeam;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.StatBoostingRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesOverlayUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.GlowingEyesUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RatinatorRatUpgradeItem
extends StatBoostingRatUpgradeItem
implements ChangesOverlayUpgrade,
TickRatUpgrade,
GlowingEyesUpgrade {
    public RatinatorRatUpgradeItem(Item.Properties properties) {
        super(properties, 2, 2, () -> Map.of(Attributes.f_22284_, RatConfig.ratinatorArmorUpgrade), false);
    }

    @Override
    public RenderType getOverlayTexture(ItemStack stack, TamedRat rat, float partialTicks) {
        return RenderType.m_110476_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/upgrades/ratinator.png"));
    }

    @Override
    public void tick(TamedRat rat) {
        if (rat.rangedAttackCooldown == 0 && rat.m_5448_() != null) {
            rat.rangedAttackCooldown = 10;
            float radius = 0.3f;
            for (int i = 0; i < 2; ++i) {
                float angle = (float)Math.PI / 180 * (rat.f_20883_ + (float)(i == 0 ? 90 : -90));
                double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + rat.m_20185_();
                double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + rat.m_20189_();
                double extraY = 0.2 + rat.m_20186_();
                double targetRelativeX = rat.m_5448_().m_20185_() - extraX;
                double targetRelativeY = rat.m_5448_().m_20186_() + (double)(rat.m_5448_().m_20206_() / 2.0f) - extraY;
                double targetRelativeZ = rat.m_5448_().m_20189_() - extraZ;
                rat.m_5496_((SoundEvent)RatsSoundRegistry.LASER.get(), 1.0f, 0.75f + rat.m_217043_().m_188501_() * 0.5f);
                LaserBeam beam = new LaserBeam((EntityType<? extends ArrowlikeProjectile>)((EntityType)RatlantisEntityRegistry.LASER_BEAM.get()), rat.m_9236_(), (LivingEntity)rat);
                beam.setRGB(1.0f, 0.0f, 0.0f);
                beam.setBaseDamage(2.0);
                beam.m_6034_(extraX, extraY, extraZ);
                beam.m_6686_(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.4f);
                if (rat.m_9236_().m_5776_()) continue;
                rat.m_9236_().m_7967_((Entity)beam);
            }
        }
    }

    @Override
    public RenderType getEyeTexture(ItemStack stack) {
        return RenderType.m_110488_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/eyes/ratinator.png"));
    }
}

