/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.projectile.RatDragonFire;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseFlightRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesTextureUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.GlowingEyesUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.StatBoostingUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DragonRatUpgradeItem
extends BaseFlightRatUpgradeItem
implements StatBoostingUpgrade,
ChangesTextureUpgrade,
TickRatUpgrade,
GlowingEyesUpgrade {
    public DragonRatUpgradeItem(Item.Properties properties) {
        super(properties, 1, 2);
    }

    @Override
    public ItemStack getWing() {
        return new ItemStack((ItemLike)RatsItemRegistry.DRAGON_WING.get());
    }

    @Override
    public Map<Attribute, Double> getAttributeBoosts() {
        return Map.of(Attributes.f_22276_, RatConfig.dragonHealthUpgrade, Attributes.f_22284_, RatConfig.dragonArmorUpgrade, Attributes.f_22281_, RatConfig.dragonDamageUpgrade);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        this.getAttributeBoosts().forEach((attribute, aDouble) -> tooltip.add((Component)Component.m_237110_((String)"item.rats.rat_upgrade.stat_boost", (Object[])new Object[]{aDouble.toString(), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.AQUA)));
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("rats", "textures/entity/rat/upgrades/dragon.png");
    }

    @Override
    public boolean makesEyesGlowByDefault() {
        return true;
    }

    @Override
    public void tick(TamedRat rat) {
        if (rat.getVisualFlag() && rat.visualCooldown == 0) {
            rat.setVisualFlag(false);
        }
        if (rat.rangedAttackCooldown == 0 && rat.m_5448_() != null) {
            rat.rangedAttackCooldown = 5;
            float radius = 0.3f;
            float angle = (float)Math.PI / 180 * rat.f_20883_;
            double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + rat.m_20185_();
            double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + rat.m_20189_();
            double extraY = 0.2 + rat.m_20186_();
            double targetRelativeX = rat.m_5448_().m_20185_() - extraX;
            double targetRelativeY = rat.m_5448_().m_20186_() + (double)(rat.m_5448_().m_20206_() / 2.0f) - extraY;
            double targetRelativeZ = rat.m_5448_().m_20189_() - extraZ;
            rat.m_5496_((SoundEvent)RatsSoundRegistry.RAT_SHOOT.get(), 1.0f, 1.25f + rat.m_217043_().m_188501_() * 0.5f);
            RatDragonFire beam = new RatDragonFire((EntityType<? extends Fireball>)((EntityType)RatsEntityRegistry.RAT_DRAGON_FIRE.get()), (LivingEntity)rat, rat.m_9236_(), targetRelativeX, targetRelativeY, targetRelativeZ);
            beam.m_6034_(extraX, extraY, extraZ);
            if (!rat.m_9236_().m_5776_()) {
                rat.m_9236_().m_7967_((Entity)beam);
            }
        }
        rat.m_20095_();
    }

    @Override
    public boolean isImmuneToDamageSource(TamedRat rat, DamageSource source) {
        return super.isImmuneToDamageSource(rat, source) || source.m_269533_(DamageTypeTags.f_268745_);
    }

    @Override
    public RenderType getEyeTexture(ItemStack stack) {
        return RenderType.m_110488_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/eyes/dragon.png"));
    }
}

