/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsUpgradeConflictRegistry;
import com.github.alexthe666.rats.server.inventory.RatUpgradeMenu;
import com.github.alexthe666.rats.server.inventory.container.RatUpgradeContainer;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.CombinedUpgrade;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CombinedRatUpgradeItem
extends BaseRatUpgradeItem
implements CombinedUpgrade {
    public CombinedRatUpgradeItem(Item.Properties properties) {
        super(properties, 1, 1);
    }

    public static boolean canCombineWithUpgrade(ItemStack combiner, ItemStack stack) {
        if (stack.m_41720_() instanceof CombinedUpgrade) {
            return false;
        }
        CompoundTag tag = combiner.m_41783_();
        if (tag != null && tag.m_128425_("Items", 9)) {
            NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)nonnulllist);
            for (ItemStack contained : nonnulllist) {
                if (stack.m_41720_() instanceof BaseRatUpgradeItem && stack.m_41720_() != contained.m_41720_() && !RatsUpgradeConflictRegistry.doesConflict(contained, stack)) continue;
                return false;
            }
        }
        return combiner.m_150930_((Item)RatsItemRegistry.RAT_UPGRADE_JURY_RIGGED.get()) || combiner.m_150930_((Item)RatsItemRegistry.RAT_UPGRADE_COMBINED.get()) || combiner.m_150930_((Item)RatsItemRegistry.RAT_UPGRADE_COMBINED_CREATIVE.get());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (stack.m_150930_((Item)RatsItemRegistry.RAT_UPGRADE_COMBINED_CREATIVE.get())) {
            tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_upgrade_combined.desc").m_130940_(ChatFormatting.GRAY));
        }
        this.addTooltip(stack, tooltip);
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        if (stack.m_150930_((Item)RatsItemRegistry.RAT_UPGRADE_COMBINED_CREATIVE.get())) {
            return true;
        }
        CompoundTag tag = stack.m_41783_();
        boolean flag = false;
        if (tag != null && tag.m_128425_("Items", 9)) {
            NonNullList nonnulllist = NonNullList.m_122780_((int)this.getUpgradeSlots(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)nonnulllist);
            flag = !nonnulllist.isEmpty();
        }
        return flag;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, final Player player, InteractionHand hand) {
        if (this == RatsItemRegistry.RAT_UPGRADE_COMBINED_CREATIVE.get()) {
            final ItemStack stack = player.m_21120_(hand);
            if (!player.m_6144_()) {
                if (!level.m_5776_()) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player1) {
                            return new RatUpgradeMenu(id, (Container)new RatUpgradeContainer(stack), player.m_150109_(), stack);
                        }

                        public Component m_5446_() {
                            return CombinedRatUpgradeItem.this.m_7626_(stack);
                        }
                    });
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    @Override
    public int getUpgradeSlots() {
        return 27;
    }
}

