/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster.boss;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.AdjustsRatTail;
import com.github.alexthe666.rats.server.entity.Plane;
import com.github.alexthe666.rats.server.entity.ai.navigation.control.PlaneMoveControl;
import com.github.alexthe666.rats.server.entity.monster.boss.RatBaron;
import com.github.alexthe666.rats.server.entity.projectile.ArrowlikeProjectile;
import com.github.alexthe666.rats.server.entity.projectile.RattlingGunBullet;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.misc.PlaneRotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RatBaronPlane
extends Mob
implements Plane,
AdjustsRatTail {
    private static final EntityDataAccessor<Boolean> FIRING = SynchedEntityData.m_135353_(RatBaronPlane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> PLANE_PITCH = SynchedEntityData.m_135353_(RatBaronPlane.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public PlaneRotationUtil roll_buffer;
    public PlaneRotationUtil pitch_buffer;
    @Nullable
    private Vec3 flightTarget;
    private Vec3 startAttackVec;
    private Vec3 startPreyVec;
    private LivingEntity prevAttackTarget = null;
    private BlockPos escortPosition = null;
    private int soundLoopCounter = 0;
    public float prevPlanePitch;

    public RatBaronPlane(EntityType<? extends Mob> type, Level level) {
        super(type, level);
        this.f_21342_ = new PlaneMoveControl<RatBaronPlane>(this);
        this.f_21364_ = 55;
        this.f_19794_ = true;
        if (level.m_5776_()) {
            this.roll_buffer = new PlaneRotationUtil();
            this.pitch_buffer = new PlaneRotationUtil();
        }
    }

    public float getPlanePitch() {
        return ((Float)this.m_20088_().m_135370_(PLANE_PITCH)).floatValue();
    }

    public void setPlanePitch(float pitch) {
        this.m_20088_().m_135381_(PLANE_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementPlanePitch(float pitch) {
        this.m_20088_().m_135381_(PLANE_PITCH, (Object)Float.valueOf(this.getPlanePitch() + pitch));
    }

    public void decrementPlanePitch(float pitch) {
        this.m_20088_().m_135381_(PLANE_PITCH, (Object)Float.valueOf(this.getPlanePitch() - pitch));
    }

    public boolean m_7307_(Entity entity) {
        return super.m_7307_(entity) || entity instanceof RatBaron;
    }

    public void m_6710_(@Nullable LivingEntity living) {
        super.m_6710_(living);
        if (living != null) {
            if (this.prevAttackTarget != living) {
                this.startPreyVec = new Vec3(living.m_20185_(), living.m_20186_(), living.m_20189_());
                this.startAttackVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            }
            this.prevAttackTarget = living;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.soundLoopCounter == 0) {
            this.m_5496_((SoundEvent)RatsSoundRegistry.BIPLANE_LOOP.get(), 10.0f, 1.0f);
        }
        ++this.soundLoopCounter;
        if (this.soundLoopCounter > 90) {
            this.soundLoopCounter = 0;
        }
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof AbstractRat)) continue;
            AbstractRat rat = (AbstractRat)passenger;
            this.m_6710_(rat.m_5448_());
        }
        this.prevPlanePitch = this.getPlanePitch();
        if (!(this.m_21525_() || this.m_20160_() || this.m_9236_().m_5776_())) {
            this.m_6469_(this.m_269291_().m_269425_(), Float.MAX_VALUE);
        }
        if (!this.m_20096_() && this.m_20184_().m_7098_() < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() + 0.08, this.m_20184_().m_7094_());
        if (this.m_5448_() != null && this.startPreyVec != null && this.startAttackVec != null) {
            float distX = (float)(this.startPreyVec.m_7096_() - this.startAttackVec.m_7096_());
            float distY = 1.5f;
            float distZ = (float)(this.startPreyVec.m_7094_() - this.startAttackVec.m_7094_());
            this.setFlightTarget(new Vec3(this.m_5448_().m_20185_() + (double)distX, (double)((float)(this.m_9236_().m_5452_(Heightmap.Types.WORLD_SURFACE, this.m_21534_()).m_123342_() + 5 + this.m_217043_().m_188503_(16)) + distY), this.m_5448_().m_20189_() + (double)distZ));
            if (this.m_20275_(this.getFlightTarget().m_7096_(), this.getFlightTarget().m_7098_(), this.getFlightTarget().m_7094_()) < 100.0) {
                this.setFlightTarget(new Vec3(this.m_5448_().m_20185_() - (double)distX, (double)((float)(this.m_9236_().m_5452_(Heightmap.Types.WORLD_SURFACE, this.m_21534_()).m_123342_() + 5 + this.m_217043_().m_188503_(16)) + distY), this.m_5448_().m_20189_() - (double)distZ));
            }
        }
        if (this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_())) {
            LivingEntity target = this.m_5448_();
            if (this.f_19797_ % RatConfig.ratBaronShootFrequency == 0) {
                for (int i = 0; i < 2; ++i) {
                    boolean left = i == 0;
                    float radius = 1.15f;
                    float angle = (float)Math.PI / 180 * this.f_20883_ + (float)(left ? 75 : -75);
                    double extraX = this.m_20185_() + (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle))));
                    double extraZ = this.m_20189_() + (double)(radius * Mth.m_14089_((float)angle));
                    double extraY = this.m_20186_() + (double)1.35f;
                    RattlingGunBullet bullet = new RattlingGunBullet((EntityType<? extends ArrowlikeProjectile>)((EntityType)RatlantisEntityRegistry.RATTLING_GUN_BULLET.get()), this.m_9236_(), (LivingEntity)this);
                    bullet.m_6034_(extraX, extraY, extraZ);
                    bullet.setBaseDamage(RatConfig.ratBaronBulletDamage);
                    double d0 = target.m_20185_() - this.m_20185_();
                    double d1 = target.m_20227_(0.3333333333333333) - bullet.m_20186_();
                    double d2 = target.m_20189_() - this.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    bullet.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 3.2f, 1.4f);
                    this.m_5496_((SoundEvent)RatsSoundRegistry.BIPLANE_SHOOT.get(), 3.0f, 2.3f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                    if (this.m_9236_().m_5776_()) continue;
                    this.m_9236_().m_7967_((Entity)bullet);
                }
            }
            this.setFiring(true);
        }
        if (this.m_5448_() == null || this.getFlightTarget() == null || this.m_20275_(this.getFlightTarget().m_7096_(), this.getFlightTarget().m_7098_(), this.getFlightTarget().m_7094_()) < 9.0 || !this.m_9236_().m_46859_(BlockPos.m_274446_((Position)this.getFlightTarget()))) {
            if (this.escortPosition == null) {
                this.escortPosition = this.m_9236_().m_5452_(Heightmap.Types.WORLD_SURFACE, this.m_21534_()).m_6630_(RatConfig.ratBaronYFlight + this.m_217043_().m_188503_(10));
            }
            this.setFlightTarget(this.getBlockInViewEscort());
        }
        if (this.m_9236_().m_5776_() && !this.m_20096_()) {
            this.roll_buffer.calculateChainFlapBuffer(40.0f, 20, 0.5f, 0.5f, (LivingEntity)this);
            this.pitch_buffer.calculateChainWaveBuffer(40.0f, 10, 0.5f, 0.5f, (LivingEntity)this);
        }
        if (!this.m_20096_()) {
            double ydist = this.f_19855_ - this.m_20186_();
            float planeDist = (float)((Math.abs(this.m_20184_().m_7096_()) + Math.abs(this.m_20184_().m_7094_())) * 6.0);
            this.incrementPlanePitch((float)ydist * 10.0f);
            this.setPlanePitch(Mth.m_14036_((float)this.getPlanePitch(), (float)-60.0f, (float)40.0f));
            float plateau = 2.0f;
            if (this.getPlanePitch() > plateau) {
                this.decrementPlanePitch(planeDist * Math.abs(this.getPlanePitch()) / 90.0f);
            }
            if (this.getPlanePitch() < -plateau) {
                this.incrementPlanePitch(planeDist * Math.abs(this.getPlanePitch()) / 90.0f);
            }
            if (this.getPlanePitch() > 2.0f) {
                this.decrementPlanePitch(1.0f);
            } else if (this.getPlanePitch() < -2.0f) {
                this.incrementPlanePitch(1.0f);
            }
        } else {
            this.setPlanePitch(0.0f);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.m_21534_() != BlockPos.f_121853_) {
            BlockPos home = this.m_21534_();
            tag.m_128365_("Home", (Tag)this.makeDoubleList(home.m_123341_(), home.m_123342_(), home.m_123343_()));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Home", 9)) {
            ListTag nbttaglist = tag.m_128437_("Home", 6);
            int hx = (int)nbttaglist.m_128772_(0);
            int hy = (int)nbttaglist.m_128772_(1);
            int hz = (int)nbttaglist.m_128772_(2);
            this.m_21446_(new BlockPos(hx, hy, hz), 16);
        }
    }

    private ListTag makeDoubleList(double ... pNumbers) {
        ListTag listtag = new ListTag();
        for (double d0 : pNumbers) {
            listtag.add((Object)DoubleTag.m_128500_((double)d0));
        }
        return listtag;
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6688_() != null) {
            return this.m_6688_().m_6469_(source, amount);
        }
        return super.m_6469_(source, amount);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 128.0);
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        float radius = 0.35f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double extraY = 1.35f;
        callback.m_20372_(passenger, this.m_20185_() + extraX, this.m_20186_() + extraY, this.m_20189_() + extraZ);
        if (passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            living.f_20883_ = this.f_20883_;
            passenger.m_146922_(this.f_20883_);
            living.f_20885_ = this.f_20883_;
        }
    }

    @Nullable
    public Vec3 getBlockInViewEscort() {
        BlockPos escortPos = this.getEscortPosition();
        BlockPos ground = this.m_9236_().m_5452_(Heightmap.Types.WORLD_SURFACE, escortPos);
        int distFromGround = escortPos.m_123342_() - ground.m_123342_();
        int fromHome = 32;
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = new BlockPos(escortPos.m_123341_() + this.m_217043_().m_188503_(fromHome) - fromHome / 2, distFromGround > 16 ? ground.m_123342_() + 16 : escortPos.m_123342_() + 10 + this.m_217043_().m_188503_(16), escortPos.m_123343_() + this.m_217043_().m_188503_(fromHome) - fromHome / 2);
            if (!this.canBlockPosBeSeen(pos) || !(this.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > 6.0)) continue;
            return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        }
        return null;
    }

    public boolean canBlockPosBeSeen(BlockPos pos) {
        Vec3 vec3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec3d1 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        return this.m_9236_().m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    private BlockPos getEscortPosition() {
        return this.escortPosition;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FIRING, (Object)false);
        this.m_20088_().m_135372_(PLANE_PITCH, (Object)Float.valueOf(0.0f));
    }

    public boolean isFiring() {
        return (Boolean)this.m_20088_().m_135370_(FIRING);
    }

    public void setFiring(boolean male) {
        this.m_20088_().m_135381_(FIRING, (Object)male);
    }

    @Override
    @Nullable
    public Vec3 getFlightTarget() {
        return this.flightTarget;
    }

    @Override
    public void setFlightTarget(@Nullable Vec3 target) {
        this.flightTarget = target;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)RatsSoundRegistry.BIPLANE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.BIPLANE_DEATH.get();
    }

    public boolean m_6072_() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    @Override
    public void adjustRatTailRotation(AbstractRat rat, AdvancedModelBox upperTail, AdvancedModelBox lowerTail) {
        this.progressRotation(upperTail, rat.sitProgress, 1.3f, 0.0f, 0.0f, 20.0f);
        this.progressRotation(lowerTail, rat.sitProgress, -0.2f, 0.0f, 0.0f, 20.0f);
    }
}

