/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.misc;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.data.tags.RatsEntityTags;
import com.github.alexthe666.rats.registry.RatsAdvancementsRegistry;
import com.github.alexthe666.rats.registry.RatsEffectRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.ai.goal.PlagueDoctorFollowGolemGoal;
import com.github.alexthe666.rats.server.entity.monster.boss.BlackDeath;
import com.github.alexthe666.rats.server.entity.projectile.PurifyingLiquid;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import com.github.alexthe666.rats.server.misc.PlagueDoctorTrades;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.UseItemGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PlagueDoctor
extends AbstractVillager
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> WILL_DESPAWN = SynchedEntityData.m_135353_(PlagueDoctor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Predicate<LivingEntity> PLAGUE_PREDICATE = entity -> {
        Rat rat;
        return entity != null && (entity.m_21023_((MobEffect)RatsEffectRegistry.PLAGUE.get()) || entity.m_6095_().m_204039_(RatsEntityTags.PLAGUE_LEGION) || entity instanceof Rat && (rat = (Rat)((Object)entity)).hasPlague());
    };
    private BlockPos wanderTarget;
    private int despawnDelay;
    private boolean eating = false;
    private int munchCounter;
    private boolean restockedToday;

    public PlagueDoctor(EntityType<? extends AbstractVillager> type, Level level) {
        super(type, level);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21553_(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new UseItemGoal((Mob)this, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43605_), (SoundEvent)RatsSoundRegistry.PLAGUE_DOCTOR_DISAPPEAR.get(), doctor -> !this.m_9236_().m_46461_() && !doctor.m_20145_()));
        this.f_21345_.m_25352_(0, (Goal)new UseItemGoal((Mob)this, new ItemStack((ItemLike)Items.f_42455_), (SoundEvent)RatsSoundRegistry.PLAGUE_DOCTOR_REAPPEAR.get(), doctor -> this.m_9236_().m_46461_() && doctor.m_20145_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 1.1, 1.35));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Evoker.class, 12.0f, 1.1, 1.35));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vindicator.class, 8.0f, 1.1, 1.35));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vex.class, 8.0f, 1.1, 1.35));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Pillager.class, 15.0f, 1.1, 1.35));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Illusioner.class, 12.0f, 1.1, 1.35));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zoglin.class, 10.0f, 1.1, 1.35));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new MoveToGoal(this, 2.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new PlagueDoctorFollowGolemGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.f_50112_)}), false));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombieVillager.class, 0, true, false, entity -> entity != null && entity.m_6084_() && !((ZombieVillager)entity).m_34408_()));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, false, false, PLAGUE_PREDICATE));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(WILL_DESPAWN, (Object)false);
    }

    public boolean willDespawn() {
        return (Boolean)this.m_20088_().m_135370_(WILL_DESPAWN) != false && !this.m_21532_();
    }

    public void setWillDespawn(boolean despawn) {
        this.m_20088_().m_135381_(WILL_DESPAWN, (Object)despawn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && this.willDespawn()) {
            this.handleDespawn();
        }
        if (!this.m_9236_().m_5776_() && this.m_21223_() < this.m_21233_() && this.m_21120_(InteractionHand.MAIN_HAND).getFoodProperties((LivingEntity)this) != null && this.m_217043_().m_188503_(25) == 0) {
            this.eating = true;
        }
        if (!(this.m_5448_() == null || this.m_5448_().m_6084_() && PLAGUE_PREDICATE.test(this.m_5448_()))) {
            this.m_6710_(null);
        }
        if (this.eating) {
            ItemStack stack = this.m_21120_(InteractionHand.MAIN_HAND);
            if (this.f_19797_ % 4 == 0) {
                ++this.munchCounter;
                this.m_5496_(this.m_7866_(stack), 0.75f, 1.0f + (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.4f);
                this.m_146850_(GameEvent.f_157806_);
                this.m_9236_().m_7605_((Entity)this, (byte)77);
            }
            if (this.munchCounter == 10 && stack.getFoodProperties((LivingEntity)this) != null) {
                this.m_5634_(Objects.requireNonNull(stack.getFoodProperties((LivingEntity)this)).m_38744_());
                this.m_21063_(stack, this.m_9236_(), (LivingEntity)this);
                stack.m_41774_(1);
                this.munchCounter = 0;
                this.eating = false;
            }
        }
        if (!this.willDespawn()) {
            if (this.m_9236_().m_46462_() && this.restockedToday) {
                this.restockedToday = false;
            }
            if (!this.restockedToday && this.exhaustedAnyTrades() && this.m_9236_().m_46461_()) {
                for (MerchantOffer merchantoffer : this.m_6616_()) {
                    merchantoffer.m_45372_();
                }
                this.restockedToday = true;
            }
        }
    }

    private boolean exhaustedAnyTrades() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            if (!merchantoffer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    protected void m_7581_(ItemEntity item) {
        ItemStack itemstack = item.m_32055_();
        if (this.m_7252_(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemstack.m_41620_(i - 1));
            }
            this.dropItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(item);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.m_21508_(EquipmentSlot.MAINHAND);
            this.m_7938_((Entity)item, itemstack.m_41613_());
            item.m_146870_();
        }
    }

    private void dropItemStack(ItemStack stack) {
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)itementity);
    }

    private void dropItem(ItemStack stack) {
        if (!stack.m_41619_() && !this.m_9236_().m_5776_()) {
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().m_7096_(), this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().m_7094_(), stack);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_9236_().m_7967_((Entity)itementity);
        }
    }

    public boolean m_7252_(ItemStack stack) {
        Item item = stack.m_41720_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() || item.m_41472_() && !itemstack.m_41720_().m_41472_();
    }

    public void m_7822_(byte id) {
        if (id == 77) {
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!stack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3 = new Vec3(((double)this.m_217043_().m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                    vec3 = vec3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                    vec3 = vec3.m_82524_(-this.m_6080_() * ((float)Math.PI / 180));
                    double d0 = (double)(-this.m_217043_().m_188501_()) * 0.6 - 0.3;
                    Vec3 vec31 = new Vec3(((double)this.m_217043_().m_188501_() - 0.5) * 0.2, d0, 0.6);
                    vec31 = vec31.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                    vec31 = vec31.m_82524_(-this.m_6080_() * ((float)Math.PI / 180));
                    vec31 = vec31.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)level;
                        server.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec31.m_7096_(), vec31.m_7098_(), vec31.m_7094_(), 1, vec3.m_7096_(), vec3.m_7098_() + 0.05, vec3.m_7094_(), 0.0);
                        continue;
                    }
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec31.m_7096_(), vec31.m_7098_(), vec31.m_7094_(), vec3.m_7096_(), vec3.m_7098_() + 0.05, vec3.m_7094_());
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("DespawnDelay", this.despawnDelay);
        compound.m_128379_("WillDespawn", this.willDespawn());
        compound.m_128379_("RestockedToday", this.restockedToday);
        if (this.wanderTarget != null) {
            compound.m_128365_("WanderTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.wanderTarget));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("DespawnDelay", 99)) {
            this.despawnDelay = compound.m_128451_("DespawnDelay");
        }
        this.setWillDespawn(compound.m_128471_("WillDespawn"));
        this.restockedToday = compound.m_128471_("RestockedToday");
        if (compound.m_128441_("WanderTarget")) {
            this.wanderTarget = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("WanderTarget"));
        }
        this.m_146762_(Math.max(0, this.m_146764_()));
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void setDespawnDelay(int delay) {
        this.despawnDelay = delay;
    }

    private void handleDespawn() {
        if (this.willDespawn() && !this.m_35306_() && --this.despawnDelay <= 0) {
            this.m_216990_((SoundEvent)RatsSoundRegistry.PLAGUE_DOCTOR_DISAPPEAR.get());
            this.m_146870_();
        }
    }

    public int m_8100_() {
        return 400;
    }

    protected SoundEvent m_7515_() {
        return this.m_35306_() ? SoundEvents.f_12508_ : SoundEvents.f_12503_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12506_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    protected SoundEvent m_7838_(ItemStack stack) {
        return stack.m_150930_(Items.f_42589_) ? (SoundEvent)RatsSoundRegistry.PLAGUE_DOCTOR_DRINK_POTION.get() : (SoundEvent)RatsSoundRegistry.PLAGUE_DOCTOR_DRINK.get();
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        double d0 = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double d1 = target.m_20185_() + target.m_20184_().m_7096_() - this.m_20185_();
        double d2 = d0 - this.m_20186_();
        double d3 = target.m_20189_() + target.m_20184_().m_7094_() - this.m_20189_();
        float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3)));
        PurifyingLiquid entitypotion = new PurifyingLiquid(this.m_9236_(), (LivingEntity)this, false);
        entitypotion.m_146926_(entitypotion.m_146909_() + 20.0f);
        entitypotion.m_6686_(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)RatsSoundRegistry.PLAGUE_DOCTOR_THROW.get(), this.m_5720_(), 1.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
        this.m_9236_().m_7967_((Entity)entitypotion);
    }

    public void m_8038_(ServerLevel level, LightningBolt lightning) {
        if (RatConfig.blackDeathLightning && this.m_6084_() && level.m_6436_(this.m_20183_()).m_19048_() != Difficulty.PEACEFUL) {
            BlackDeath death = new BlackDeath((EntityType<? extends Monster>)((EntityType)RatsEntityRegistry.BLACK_DEATH.get()), (Level)level);
            death.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            ForgeEventFactory.onFinalizeSpawn((Mob)death, (ServerLevelAccessor)level, (DifficultyInstance)level.m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.CONVERSION, null, null);
            death.m_21557_(this.m_21525_());
            if (!this.m_21205_().m_41619_()) {
                this.m_19983_(this.m_21205_());
            }
            if (this.m_8077_()) {
                death.m_6593_(this.m_7770_());
            }
            level.m_7967_((Entity)death);
            for (ServerPlayer player : level.m_45976_(ServerPlayer.class, new AABB(death.m_20183_()).m_82400_(16.0))) {
                RatsAdvancementsRegistry.BLACK_DEATH_SUMMONED.trigger(player);
            }
            this.m_146870_();
        }
    }

    protected void m_8058_(MerchantOffer offer) {
        if (offer.m_45383_()) {
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), offer.m_45379_()));
        }
    }

    @Nullable
    public BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    public void setWanderTarget(@Nullable BlockPos blockpos1) {
        this.wanderTarget = blockpos1;
    }

    public boolean m_7826_() {
        return false;
    }

    protected void m_7604_() {
        VillagerTrades.ItemListing[] level1 = (VillagerTrades.ItemListing[])PlagueDoctorTrades.PLAGUE_DOCTOR_TRADES.get(1);
        VillagerTrades.ItemListing[] level2 = (VillagerTrades.ItemListing[])PlagueDoctorTrades.PLAGUE_DOCTOR_TRADES.get(2);
        if (level1 != null && level2 != null) {
            MerchantOffer merchantoffer3;
            MerchantOffer merchantoffer2;
            int rolls;
            MerchantOffers merchantoffers = this.m_6616_();
            this.m_35277_(merchantoffers, level1, 5);
            int i = this.m_217043_().m_188503_(level2.length);
            int j = this.m_217043_().m_188503_(level2.length);
            int k = this.m_217043_().m_188503_(level2.length);
            for (rolls = 0; j == i && rolls < 100; ++rolls) {
                j = this.m_217043_().m_188503_(level2.length);
            }
            for (rolls = 0; (k == i || k == j) && rolls < 100; ++rolls) {
                k = this.m_217043_().m_188503_(level2.length);
            }
            VillagerTrades.ItemListing rareTrade1 = level2[i];
            VillagerTrades.ItemListing rareTrade2 = level2[j];
            VillagerTrades.ItemListing rareTrade3 = level2[k];
            MerchantOffer merchantoffer1 = rareTrade1.m_213663_((Entity)this, this.m_217043_());
            if (merchantoffer1 != null) {
                merchantoffers.add((Object)merchantoffer1);
            }
            if ((merchantoffer2 = rareTrade2.m_213663_((Entity)this, this.m_217043_())) != null) {
                merchantoffers.add((Object)merchantoffer2);
            }
            if ((merchantoffer3 = rareTrade3.m_213663_((Entity)this, this.m_217043_())) != null) {
                merchantoffers.add((Object)merchantoffer3);
            }
            if (!RatsMod.RATLANTIS_DATAPACK_ENABLED && this.willDespawn()) {
                merchantoffers.add((Object)PlagueDoctorTrades.COMBINER_TRADE.m_213663_((Entity)this, this.m_217043_()));
                merchantoffers.add((Object)PlagueDoctorTrades.SEPARATOR_TRADE.m_213663_((Entity)this, this.m_217043_()));
                merchantoffers.add((Object)PlagueDoctorTrades.UPGRADE_COMBINED_TRADE.m_213663_((Entity)this, this.m_217043_()));
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_((Item)RatsItemRegistry.PLAGUE_TOME.get())) {
            if (!this.m_6162_() && !this.m_9236_().m_5776_()) {
                BlackDeath death = new BlackDeath((EntityType<? extends Monster>)((EntityType)RatsEntityRegistry.BLACK_DEATH.get()), this.m_9236_());
                death.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                ForgeEventFactory.onFinalizeSpawn((Mob)death, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(death.m_20183_()), (MobSpawnType)MobSpawnType.TRIGGERED, null, null);
                if (this.m_8077_()) {
                    death.m_6593_(this.m_7770_());
                }
                if (!this.m_21205_().m_41619_()) {
                    this.m_19983_(this.m_21205_());
                }
                this.m_9236_().m_7967_((Entity)death);
                RatsAdvancementsRegistry.BLACK_DEATH_SUMMONED.trigger((ServerPlayer)player);
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)RatsSoundRegistry.BLACK_DEATH_SUMMON.get(), SoundSource.HOSTILE, 1.5f, 1.0f);
                this.m_146870_();
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (!(itemstack.m_150930_(Items.f_42601_) || itemstack.m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rats", "plague_doctor_spawn_egg"))) || !this.m_6084_() || this.m_35306_() || this.m_6162_())) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                return super.m_6071_(player, hand);
            }
            if (!this.m_9236_().m_5776_()) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public class MoveToGoal
    extends Goal {
        final PlagueDoctor plagueDoctor;
        final double range;
        final double speed;

        MoveToGoal(PlagueDoctor doctor, double followRange, double speedModifier) {
            this.plagueDoctor = doctor;
            this.range = followRange;
            this.speed = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8041_() {
            this.plagueDoctor.setWanderTarget(null);
            PlagueDoctor.this.m_21573_().m_26573_();
        }

        public boolean m_8036_() {
            BlockPos blockpos = this.plagueDoctor.getWanderTarget();
            return blockpos != null && this.isInRange(blockpos, this.range);
        }

        public void m_8037_() {
            BlockPos blockpos = this.plagueDoctor.getWanderTarget();
            if (blockpos != null && PlagueDoctor.this.m_21573_().m_26571_()) {
                if (this.isInRange(blockpos, 10.0)) {
                    Vec3 vec3d = new Vec3((double)blockpos.m_123341_() - this.plagueDoctor.m_20185_(), (double)blockpos.m_123342_() - this.plagueDoctor.m_20186_(), (double)blockpos.m_123343_() - this.plagueDoctor.m_20189_()).m_82541_();
                    Vec3 vec3d1 = vec3d.m_82490_(10.0).m_82520_(this.plagueDoctor.m_20185_(), this.plagueDoctor.m_20186_(), this.plagueDoctor.m_20189_());
                    PlagueDoctor.this.m_21573_().m_26519_(vec3d1.f_82479_, vec3d1.f_82480_, vec3d1.f_82481_, this.speed);
                } else {
                    PlagueDoctor.this.m_21573_().m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.speed);
                }
            }
        }

        private boolean isInRange(BlockPos pos, double range) {
            return !pos.m_203195_((Position)this.plagueDoctor.m_20182_(), range);
        }
    }
}

