/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.navigation.evaluator;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;

public class WaterSurfaceNodeEvaluator
extends NodeEvaluator {
    private final Long2ObjectMap<BlockPathTypes> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public void m_6028_(PathNavigationRegion region, Mob mob) {
        super.m_6028_(region, mob);
        this.pathTypesByPosCache.clear();
    }

    public void m_6802_() {
        super.m_6802_();
        this.pathTypesByPosCache.clear();
    }

    public Node m_7171_() {
        return this.m_5676_(Mth.m_14107_((double)this.f_77313_.m_20191_().f_82288_), Mth.m_14107_((double)this.f_77313_.m_20191_().f_82292_), Mth.m_14107_((double)this.f_77313_.m_20191_().f_82290_));
    }

    public Target m_7568_(double x, double y, double z) {
        return this.m_230615_(this.m_5676_(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)));
    }

    public int m_6065_(Node[] nodeArray, Node currentNode) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            Node node = this.findAcceptedNode(currentNode.f_77271_ + direction.m_122429_(), currentNode.f_77272_ + direction.m_122430_(), currentNode.f_77273_ + direction.m_122431_());
            map.put(direction, node);
            if (!this.isNodeValid(node)) continue;
            nodeArray[i++] = node;
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            Direction direction2 = direction1.m_122427_();
            Node node1 = this.findAcceptedNode(currentNode.f_77271_ + direction1.m_122429_() + direction2.m_122429_(), currentNode.f_77272_, currentNode.f_77273_ + direction1.m_122431_() + direction2.m_122431_());
            if (!this.isDiagonalNodeValid(node1, (Node)map.get(direction1), (Node)map.get(direction2))) continue;
            nodeArray[i++] = node1;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable Node node) {
        return node != null && !node.f_77279_;
    }

    protected boolean isDiagonalNodeValid(@Nullable Node node, @Nullable Node p_192965_, @Nullable Node p_192966_) {
        return this.isNodeValid(node) && p_192965_ != null && p_192965_.f_77281_ >= 0.0f && p_192966_ != null && p_192966_.f_77281_ >= 0.0f;
    }

    @Nullable
    protected Node findAcceptedNode(int x, int y, int z) {
        float f;
        Node node = null;
        BlockPathTypes blockpathtypes = this.getCachedBlockType(x, y, z);
        if (blockpathtypes == BlockPathTypes.WATER && (f = this.f_77313_.m_21439_(blockpathtypes)) >= 0.0f) {
            node = this.m_5676_(x, y, z);
            node.f_77282_ = blockpathtypes;
            node.f_77281_ = Math.max(node.f_77281_, f);
            if (!this.f_77312_.m_6425_(new BlockPos(x, y, z)).m_76178_() && this.f_77312_.m_6425_(new BlockPos(x, y + 1, z)).m_76178_()) {
                node.f_77281_ += 8.0f;
            }
        }
        return node;
    }

    protected BlockPathTypes getCachedBlockType(int x, int y, int z) {
        return (BlockPathTypes)this.pathTypesByPosCache.computeIfAbsent(BlockPos.m_121882_((int)x, (int)y, (int)z), type -> this.m_8086_((BlockGetter)this.f_77312_, x, y, z));
    }

    public BlockPathTypes m_8086_(BlockGetter getter, int x, int y, int z) {
        return this.m_7209_(getter, x, y, z, this.f_77313_);
    }

    public BlockPathTypes m_7209_(BlockGetter getter, int x, int y, int z, Mob mob) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = x; i < x + this.f_77315_; ++i) {
            for (int j = y; j < y + this.f_77316_; ++j) {
                for (int k = z; k < z + this.f_77317_; ++k) {
                    FluidState fluidstate = getter.m_6425_((BlockPos)mutablePos.m_122178_(i, j, k));
                    BlockState blockstate = getter.m_8055_((BlockPos)mutablePos.m_122178_(i, j, k));
                    if (fluidstate.m_76178_() && blockstate.m_60647_(getter, mutablePos.m_7495_(), PathComputationType.WATER) && blockstate.m_60795_()) {
                        return BlockPathTypes.WATER;
                    }
                    if (fluidstate.m_192917_((Fluid)Fluids.f_76193_)) continue;
                    return BlockPathTypes.OPEN;
                }
            }
        }
        BlockState currentState = getter.m_8055_((BlockPos)mutablePos);
        BlockState aboveState = getter.m_8055_(mutablePos.m_7494_());
        return currentState.m_60647_(getter, (BlockPos)mutablePos, PathComputationType.WATER) && aboveState.m_60795_() ? BlockPathTypes.WATER : BlockPathTypes.OPEN;
    }
}

