/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.navigation.control;

import com.github.alexthe666.rats.server.entity.Plane;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;

public class PlaneMoveControl<T extends Mob>
extends MoveControl {
    private final T plane;

    public PlaneMoveControl(T plane) {
        super(plane);
        this.plane = plane;
    }

    public static float approach(float number, float max, float min) {
        min = Math.abs(min);
        return number < max ? Mth.m_14036_((float)(number + min), (float)number, (float)max) : Mth.m_14036_((float)(number - min), (float)max, (float)number);
    }

    public static float approachDegrees(float number, float max, float min) {
        float add = Mth.m_14177_((float)(max - number));
        return PlaneMoveControl.approach(number, number + add, min);
    }

    public static float degreesDifferenceAbs(float f1, float f2) {
        return Math.abs(Mth.m_14177_((float)(f2 - f1)));
    }

    public void m_8126_() {
        TamedRat rat;
        LivingEntity livingEntity;
        if (((Mob)this.plane).f_19862_) {
            this.plane.m_146922_(this.plane.m_146908_() + 180.0f);
            this.f_24978_ = 0.1f;
            ((Plane)this.plane).setFlightTarget(null);
            return;
        }
        if (this.plane.m_6688_() != null && (livingEntity = this.plane.m_6688_()) instanceof TamedRat && !(rat = (TamedRat)livingEntity).canMove()) {
            return;
        }
        if (((Plane)this.plane).getFlightTarget() == null && this.m_24995_()) {
            ((Plane)this.plane).setFlightTarget(new Vec3(this.m_25000_(), this.m_25001_(), this.m_25002_()));
        }
        if (((Plane)this.plane).getFlightTarget() != null) {
            float distX = (float)(((Plane)this.plane).getFlightTarget().m_7096_() - this.plane.m_20185_());
            float distY = (float)(((Plane)this.plane).getFlightTarget().m_7098_() - this.plane.m_20186_());
            float distZ = (float)(((Plane)this.plane).getFlightTarget().m_7094_() - this.plane.m_20189_());
            double planeDist = Mth.m_14116_((float)(distX * distX + distZ * distZ));
            double yDistMod = 1.0 - (double)Mth.m_14154_((float)(distY * 0.7f)) / planeDist;
            distX = (float)((double)distX * yDistMod);
            distZ = (float)((double)distZ * yDistMod);
            planeDist = Mth.m_14116_((float)(distX * distX + distZ * distZ));
            double dist = Mth.m_14116_((float)(distX * distX + distZ * distZ + distY * distY));
            if (dist > 1.0) {
                float yawCopy = this.plane.m_146908_();
                float atan = (float)Mth.m_14136_((double)distZ, (double)distX);
                float yawTurn = Mth.m_14177_((float)(this.plane.m_146908_() + 90.0f));
                float yawTurnAtan = Mth.m_14177_((float)(atan * 57.295776f));
                this.plane.m_146922_(PlaneMoveControl.approachDegrees(yawTurn, yawTurnAtan, 4.0f) - 90.0f);
                ((Mob)this.plane).f_20883_ = this.plane.m_146908_();
                if (PlaneMoveControl.degreesDifferenceAbs(yawCopy, this.plane.m_146908_()) < 3.0f) {
                    this.f_24978_ = PlaneMoveControl.approach((float)this.f_24978_, 1.2f, 0.005f * (1.2f / (float)this.f_24978_));
                } else {
                    this.f_24978_ = PlaneMoveControl.approach((float)this.f_24978_, 0.2f, 0.025f);
                    if (dist < 100.0 && this.plane.m_5448_() != null) {
                        this.f_24978_ *= dist / 100.0;
                    }
                }
                float finPitch = (float)(-(Mth.m_14136_((double)(-distY), (double)planeDist) * 57.2957763671875));
                this.plane.m_146926_(finPitch);
                float yawTurnHead = this.plane.m_146908_() + 90.0f;
                double xSpeed = this.f_24978_ * (double)Mth.m_14089_((float)(yawTurnHead * ((float)Math.PI / 180))) * Math.abs((double)distX / dist);
                double zSpeed = this.f_24978_ * (double)Mth.m_14031_((float)(yawTurnHead * ((float)Math.PI / 180))) * Math.abs((double)distZ / dist);
                double ySpeed = this.f_24978_ * (double)Mth.m_14031_((float)(finPitch * ((float)Math.PI / 180))) * Math.abs((double)distY / dist);
                this.plane.m_20256_(this.plane.m_20184_().m_82520_(xSpeed * 0.4, ySpeed * 0.4, zSpeed * 0.4));
            }
        }
    }
}

