/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal;

import com.github.alexthe666.rats.server.entity.monster.Pirat;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class PiratWanderGoal
extends Goal {
    private final Pirat rat;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private final double speed;
    private final int executionChance;
    private boolean mustUpdate;

    public PiratWanderGoal(Pirat pirat, double speedModifer) {
        this(pirat, speedModifer, 20);
    }

    public PiratWanderGoal(Pirat pirat, double speedModifer, int chance) {
        this.rat = pirat;
        this.speed = speedModifer;
        this.executionChance = chance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.mustUpdate && this.rat.m_217043_().m_188503_(this.executionChance) != 0) {
            return false;
        }
        Position vec3d = null;
        if (vec3d == null) {
            return false;
        }
        BlockPos water = RatUtils.findLowestWater(BlockPos.m_274446_(vec3d), (PathfinderMob)this.rat);
        this.xPosition = water.m_123341_();
        this.yPosition = water.m_123342_();
        this.zPosition = water.m_123343_();
        this.mustUpdate = false;
        return true;
    }

    public boolean m_8045_() {
        return !this.rat.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.rat.m_21573_().m_26519_(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }
}

