/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.registry.worldgen;

import com.github.alexthe666.rats.data.ratlantis.tags.RatlantisBiomeTags;
import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.server.world.CopyInputStateRuleProcessor;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class RatlantisStructureRegistry {
    public static final ResourceKey<StructureTemplatePool> BARON_RUNWAY_START = RatlantisStructureRegistry.registerPoolKey("baron_runway");
    public static final ResourceKey<StructureTemplatePool> DUTCHRAT_SHIP_START = RatlantisStructureRegistry.registerPoolKey("dutchrat_ship");
    public static final ResourceKey<Structure> BARON_RUNWAY = RatlantisStructureRegistry.registerStructureKey("baron_runway");
    public static final ResourceKey<Structure> DUTCHRAT_SHIP = RatlantisStructureRegistry.registerStructureKey("dutchrat_ship");
    public static final ResourceKey<StructureSet> BARON_RUNWAY_SET = RatlantisStructureRegistry.registerSetKey("baron_runway");
    public static final ResourceKey<StructureSet> DUTCHRAT_SHIP_SET = RatlantisStructureRegistry.registerSetKey("dutchrat_ship");
    public static final ResourceKey<StructureProcessorList> RUIN_RUINS = RatlantisStructureRegistry.registerProcessorKey("ruin_ruins");

    public static void bootstrapStructures(BootstapContext<Structure> context) {
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        HolderGetter pools = context.m_255420_(Registries.f_256948_);
        context.m_255272_(BARON_RUNWAY, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biomes.m_254956_(RatlantisBiomeTags.BARON_RUNWAY_SPAWNS), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)pools.m_255043_(BARON_RUNWAY_START), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), false, Heightmap.Types.OCEAN_FLOOR_WG));
        context.m_255272_(DUTCHRAT_SHIP, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biomes.m_254956_(RatlantisBiomeTags.DUTCHRAT_SHIP_SPAWNS), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)RatlantisEntityRegistry.GHOST_PIRAT.get(), 1, 1, 1)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (Holder)pools.m_255043_(DUTCHRAT_SHIP_START), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)50)), false, Heightmap.Types.WORLD_SURFACE_WG));
    }

    public static void bootstrapPools(BootstapContext<StructureTemplatePool> context) {
        Holder.Reference emptyPool = context.m_255420_(Registries.f_256948_).m_255043_(Pools.f_127186_);
        context.m_255272_(BARON_RUNWAY_START, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210526_((String)new ResourceLocation("rats", "baron_runway").toString()), (Object)1)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        context.m_255272_(DUTCHRAT_SHIP_START, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210526_((String)new ResourceLocation("rats", "dutchrat_ship").toString()), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static void bootstrapSets(BootstapContext<StructureSet> context) {
        HolderGetter structures = context.m_255420_(Registries.f_256944_);
        context.m_255272_(BARON_RUNWAY_SET, (Object)new StructureSet((Holder)structures.m_255043_(BARON_RUNWAY), (StructurePlacement)new RandomSpreadStructurePlacement(100, 70, RandomSpreadType.LINEAR, 8008135)));
        context.m_255272_(DUTCHRAT_SHIP_SET, (Object)new StructureSet((Holder)structures.m_255043_(DUTCHRAT_SHIP), (StructurePlacement)new RandomSpreadStructurePlacement(75, 50, RandomSpreadType.LINEAR, 7177135)));
    }

    public static void bootstrapProcessors(BootstapContext<StructureProcessorList> context) {
        context.m_255272_(RUIN_RUINS, (Object)new StructureProcessorList(List.of(new CopyInputStateRuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK.get(), 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK.get(), 0.35f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_SLAB.get(), 0.35f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED_SLAB.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_SLAB.get(), 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY_SLAB.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_STAIRS.get(), 0.35f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED_STAIRS.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_STAIRS.get(), 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY_STAIRS.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50034_, 0.2f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_GRASS.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50034_, 0.15f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50034_, 0.05f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50034_, 0.05f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50034_, 0.01f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_TILE.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50493_, 0.1f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_DIRT.get()).m_49966_()))))));
    }

    private static ResourceKey<Structure> registerStructureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("rats", name));
    }

    private static ResourceKey<StructureTemplatePool> registerPoolKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("rats", name));
    }

    private static ResourceKey<StructureSet> registerSetKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)new ResourceLocation("rats", name));
    }

    private static ResourceKey<StructureProcessorList> registerProcessorKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("rats", name));
    }
}

